/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.validation;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.Property;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ValidationHelpers {
    public static Iterable<NamedObject> removeUniques(List<NamedObject> items) {
        Iterable iterable = null;
        HashSet allOfName = CollectionLiterals.newHashSet((Object[])new String[0]);
        final HashSet duplicateNames = CollectionLiterals.newHashSet((Object[])new String[0]);
        for (NamedObject i : items) {
            boolean bl = allOfName.contains(i.getName());
            if (bl) {
                duplicateNames.add(i.getName());
                continue;
            }
            allOfName.add(i.getName());
        }
        Functions.Function1<NamedObject, Boolean> function1 = new Functions.Function1<NamedObject, Boolean>(){

            public Boolean apply(NamedObject i) {
                return duplicateNames.contains(i.getName());
            }
        };
        iterable = IterableExtensions.filter(items, (Functions.Function1)function1);
        return iterable;
    }

    public static Iterable<NamedObject> inSameResource(Iterable<NamedObject> items, final Resource resource) {
        Functions.Function1<NamedObject, Boolean> function1 = new Functions.Function1<NamedObject, Boolean>(){

            public Boolean apply(NamedObject i) {
                Resource resource2 = i.getObj().eResource();
                return Objects.equal((Object)resource2, (Object)resource);
            }
        };
        return IterableExtensions.filter(items, (Functions.Function1)function1);
    }

    public static <E extends EObject> void saveRecursiveVisitor(E start, Function<E, E> function) {
        HashSet visited = CollectionLiterals.newHashSet((Object[])new EObject[0]);
        Object next = start;
        while (next != null && !next.eIsProxy() && visited.add(next)) {
            next = (EObject)function.apply(next);
        }
    }

    public static class NamedObject {
        @Property
        private String _name;
        @Property
        private EObject _obj;
        @Property
        private EStructuralFeature _feature;

        public NamedObject(String name, EObject obj, EStructuralFeature feature) {
            this.setName(name);
            this.setObj(obj);
            this.setFeature(feature);
        }

        @Pure
        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        @Pure
        public EObject getObj() {
            return this._obj;
        }

        public void setObj(EObject obj) {
            this._obj = obj;
        }

        @Pure
        public EStructuralFeature getFeature() {
            return this._feature;
        }

        public void setFeature(EStructuralFeature feature) {
            this._feature = feature;
        }
    }

    public static class NamedObjectList
    extends ArrayList<NamedObject> {
        public void addAll(List<? extends EObject> items, final EStructuralFeature feature) {
            Consumer<EObject> consumer = new Consumer<EObject>(){

                @Override
                public void accept(EObject it) {
                    Object object = it.eGet(feature);
                    NamedObject namedObject = new NamedObject((String)object, it, feature);
                    this.add(namedObject);
                }
            };
            items.forEach(consumer);
        }
    }
}

