/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.scoping.ModelLocator;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.generator.fsm.base.FileSystemHelpers;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GeneratorLaunchHelper {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private ModelLocator modelLocator;

    public static Collection<String> getAllDependenciesWithinProjects(final Iterable<String> models) {
        LinkedHashSet linkedHashSet = null;
        GeneratorLaunchHelper generatorLaunchHelper = new GeneratorLaunchHelper();
        Procedures.Procedure1<GeneratorLaunchHelper> procedure1 = new Procedures.Procedure1<GeneratorLaunchHelper>(){

            public void apply(GeneratorLaunchHelper it) {
                RoomUiModule.getInjector().injectMembers((Object)it);
            }
        };
        final GeneratorLaunchHelper helper = (GeneratorLaunchHelper)ObjectExtensions.operator_doubleArrow((Object)generatorLaunchHelper, (Procedures.Procedure1)procedure1);
        LinkedHashSet linkedHashSet2 = CollectionLiterals.newLinkedHashSet((Object[])new String[0]);
        Procedures.Procedure1<LinkedHashSet<String>> procedure12 = new Procedures.Procedure1<LinkedHashSet<String>>(){

            public void apply(LinkedHashSet<String> it) {
                Iterables.addAll(it, (Iterable)models);
                Functions.Function1<String, Iterable<String>> function1 = new Functions.Function1<String, Iterable<String>>(){

                    public Iterable<String> apply(String it) {
                        return helper.getAllDependencies(it);
                    }
                };
                Iterables.addAll(it, (Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)models, (Functions.Function1)function1)));
            }
        };
        linkedHashSet = (LinkedHashSet)ObjectExtensions.operator_doubleArrow((Object)linkedHashSet2, (Procedures.Procedure1)procedure12);
        return linkedHashSet;
    }

    public Iterable<String> getAllDependencies(String filePath) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Iterable iterable = null;
        String string = null;
        String string2 = this.modelLocator.resolve(filePath, null);
        string = string2 != null ? string2 : "";
        URI uri = URI.createURI((String)string);
        String string3 = null;
        if (uri != null) {
            string3 = uri.fileExtension();
        }
        boolean bl4 = bl3 = !(bl2 = "etmap".equalsIgnoreCase(string3));
        if (bl3) {
            return CollectionLiterals.emptyList();
        }
        ResourceSet rs = (ResourceSet)this.resourceSetProvider.get();
        Resource resource = null;
        try {
            resource = rs.getResource(uri, true);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                RuntimeException cfr_ignored_0 = (RuntimeException)throwable;
                resource = null;
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        Resource res = resource;
        EList eList = null;
        if (res != null) {
            eList = res.getContents();
        }
        EObject eObject = null;
        if (eList != null) {
            eObject = (EObject)IterableExtensions.head((Iterable)eList);
        }
        boolean bl5 = bl = eObject == null;
        if (bl) {
            return CollectionLiterals.emptyList();
        }
        URI projectURI = FileSystemHelpers.getProjectURI((EObject)((EObject)IterableExtensions.head((Iterable)res.getContents())));
        if (projectURI == null || !projectURI.isFile() || projectURI.isRelative()) {
            return CollectionLiterals.emptyList();
        }
        final java.nio.file.Path projectPath = Paths.get(projectURI.toFileString(), new String[0]);
        EcoreUtil.resolveAll((ResourceSet)rs);
        Functions.Function1<Resource, String> function1 = new Functions.Function1<Resource, String>(){

            public String apply(Resource it) {
                boolean bl;
                Object object;
                URI uRI;
                IWorkspaceRoot iWorkspaceRoot = null;
                URI it_1 = uRI = it.getURI();
                boolean bl2 = false;
                boolean bl3 = it_1.isPlatformResource();
                if (bl3) {
                    bl2 = true;
                    String string = null;
                    object = ResourcesPlugin.getWorkspace().getRoot();
                    String string2 = it_1.toPlatformString(false);
                    Path path = new Path(string2);
                    IResource platformMember = object.findMember((IPath)path);
                    IPath iPath = null;
                    if (platformMember != null) {
                        iPath = platformMember.getLocation();
                    }
                    String string3 = null;
                    if (iPath != null) {
                        string3 = iPath.toOSString();
                    }
                    String location = string3;
                    String string4 = null;
                    if (location != null && Paths.get(location, new String[0]).startsWith(projectPath)) {
                        string4 = location;
                    }
                    string = string4;
                    iWorkspaceRoot = string;
                }
                if (!bl2 && (bl = it_1.isFile())) {
                    bl2 = true;
                    object = null;
                    boolean bl4 = Paths.get(it_1.toFileString(), new String[0]).startsWith(projectPath);
                    if (bl4) {
                        object = it_1.toFileString();
                    }
                    iWorkspaceRoot = object;
                }
                return iWorkspaceRoot;
            }
        };
        iterable = IterableExtensions.filterNull((Iterable)ListExtensions.map((List)rs.getResources(), (Functions.Function1)function1));
        return iterable;
    }

    public static Map<IProject, List<String>> groupByProject(Collection<String> files) {
        final IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        Functions.Function1<String, IProject> function1 = new Functions.Function1<String, IProject>(){

            public IProject apply(String it) {
                Path path = new Path(it);
                IFile iFile = ws.getFileForLocation((IPath)path);
                IProject iProject = null;
                if (iFile != null) {
                    iProject = iFile.getProject();
                }
                return iProject;
            }
        };
        Map m = IterableExtensions.groupBy(files, (Functions.Function1)function1);
        m.remove(null);
        return m;
    }
}

