/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.ast;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.converter.RoomValueConverterService;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.dctools.GenModelAccess;
import org.eclipse.etrice.dctools.ast.DCLinker;
import org.eclipse.etrice.dctools.ast.internal.DCProposalConfig;
import org.eclipse.etrice.dctools.fsm.ast.CandidateMap;
import org.eclipse.etrice.dctools.fsm.ast.DCLanguage;
import org.eclipse.etrice.dctools.fsm.ast.DCNodeAtOffset;
import org.eclipse.etrice.dctools.fsm.ast.DCParser;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstIdentifierNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstMatchNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstTextNode;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class DCUtil {
    @Inject
    private RoomValueConverterService converterService;
    @Inject
    private DCProposalConfig proposalConfig;
    @Inject
    private GenModelAccess genModelAccess;
    private DCLanguage language = DCLanguage.C_LANGUAGE;

    public DCLanguage setLanguage(DCLanguage language) {
        this.language = language;
        return this.language;
    }

    public FindResult findAtOffset(ILeafNode textNode, int offset) {
        EObject object;
        int n;
        int n2;
        DCAstMatchNode ast = this.parseAndLink((INode)textNode);
        DCAstTextNode astNode = DCNodeAtOffset.find((DCAstMatchNode)ast, (int)(n2 = offset - (n = this.getDelimiterAdjustedOffset((INode)textNode))));
        if (astNode instanceof DCAstIdentifierNode && (object = DCUtil.getLinkedObject((DCAstIdentifierNode)astNode)) != null) {
            int n3 = ((DCAstIdentifierNode)astNode).getBegin();
            int n4 = this.converterService.getCC_StringConverter().getDelim().length();
            int n5 = n3 + n4;
            int n6 = ((DCAstIdentifierNode)astNode).getEnd();
            int n7 = ((DCAstIdentifierNode)astNode).getBegin();
            int n8 = n6 - n7;
            return new FindResult(object, n5, n8);
        }
        return null;
    }

    public int getDelimiterAdjustedOffset(INode astNode) {
        int n = astNode.getOffset();
        int n2 = this.converterService.getCC_StringConverter().getDelim().length();
        return n + n2;
    }

    public DCAstMatchNode parseAndLink(INode astNode) {
        String text = this.converterService.getCC_StringConverter().stripDelim(astNode.getText());
        DCParser parser = new DCParser(this.language);
        DCAstMatchNode ast = parser.parse(text);
        EObject eObject = astNode.getParent().getSemanticElement();
        if (eObject instanceof DetailCode) {
            RoomClass roomClass;
            EObject eObject2 = astNode.getParent().getSemanticElement();
            DetailCode dc = (DetailCode)eObject2;
            DCLinker linker = null;
            TransitionBase transition = (TransitionBase)EcoreUtil2.getContainerOfType((EObject)dc, TransitionBase.class);
            if (transition != null && (roomClass = (RoomClass)EcoreUtil2.getContainerOfType((EObject)dc, RoomClass.class)) instanceof ActorClass) {
                this.genModelAccess.clearCache();
                GraphContainer gc = this.genModelAccess.get((ModelComponent)roomClass);
                Link link = FsmGenExtensions.getLinkFor((GraphContainer)gc, (TransitionBase)transition);
                if (link != null) {
                    DCLinker dCLinker;
                    EObject eObject3 = link.getCommonData();
                    linker = dCLinker = new DCLinker(dc, (MessageData)eObject3);
                }
            }
            if (linker == null) {
                DCLinker dCLinker;
                linker = dCLinker = new DCLinker(dc);
            }
            ast.visit(linker);
            return ast;
        }
        return null;
    }

    public List<ICompletionProposal> getProposals(INode textNode, final int offset) {
        CandidateMap candidates;
        int n;
        int n2;
        int n3;
        ArrayList arrayList = null;
        DCAstMatchNode ast = this.parseAndLink(textNode);
        DCAstTextNode astNode = DCNodeAtOffset.find((DCAstMatchNode)ast, (int)(n3 = (n2 = offset - (n = this.getDelimiterAdjustedOffset(textNode))) - 1));
        if (astNode instanceof DCAstIdentifierNode && (candidates = DCUtil.getCandidates((DCAstIdentifierNode)astNode)) != null) {
            int n4 = ((DCAstIdentifierNode)astNode).getBegin();
            int n5 = this.converterService.getCC_StringConverter().getDelim().length();
            int begin = n4 + n5;
            int n6 = textNode.getOffset();
            int end = offset - n6;
            final String prefix = textNode.getText().substring(begin, end);
            CandidateMap matches = candidates.getMatches(prefix);
            Functions.Function1<Map.Entry<String, EObject>, ICompletionProposal> function1 = new Functions.Function1<Map.Entry<String, EObject>, ICompletionProposal>(){

                public ICompletionProposal apply(Map.Entry<String, EObject> match) {
                    return DCUtil.this.proposalConfig.doCreateProposal(prefix, match.getKey(), match.getValue(), offset);
                }
            };
            return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)matches.entrySet(), (Functions.Function1)function1));
        }
        arrayList = CollectionLiterals.newArrayList((Object[])new ICompletionProposal[0]);
        return arrayList;
    }

    public static EObject getLinkedObject(DCAstIdentifierNode astNode) {
        boolean bl;
        EObject eObject = null;
        EObject eObject2 = astNode.getLinkedObject();
        boolean bl2 = bl = eObject2 != null;
        if (bl) {
            eObject = astNode.getLinkedObject();
        } else {
            boolean bl3;
            EObject eObject3 = null;
            DCAstNode dCAstNode = astNode.getParent();
            boolean bl4 = bl3 = dCAstNode != null;
            if (bl3) {
                eObject3 = astNode.getParent().getLinkedObject();
            }
            eObject = eObject3;
        }
        return eObject;
    }

    public static CandidateMap getCandidates(DCAstIdentifierNode astNode) {
        CandidateMap candidateMap = null;
        Object object = astNode.getLinkedData();
        if (object instanceof CandidateMap) {
            Object object2 = astNode.getLinkedData();
            candidateMap = (CandidateMap)object2;
        } else {
            CandidateMap candidateMap2 = null;
            if (astNode.getParent() != null && astNode.getParent().getLinkedData() instanceof CandidateMap) {
                Object object3 = astNode.getParent().getLinkedData();
                candidateMap2 = (CandidateMap)object3;
            }
            candidateMap = candidateMap2;
        }
        return candidateMap;
    }

    @Accessors
    public static class FindResult {
        private final EObject object;
        private final int begin;
        private final int length;

        public FindResult(EObject object, int begin, int length) {
            this.object = object;
            this.begin = begin;
            this.length = length;
        }

        @Pure
        public EObject getObject() {
            return this.object;
        }

        @Pure
        public int getBegin() {
            return this.begin;
        }

        @Pure
        public int getLength() {
            return this.length;
        }
    }
}

