/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.BasicFsmGenBuilder;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.ICommonDataCalculator;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.NullDiagnostician;
import org.eclipse.etrice.core.genmodel.fsm.TriggerExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.FsmGenFactory;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ExtendedFsmGenBuilder
extends BasicFsmGenBuilder {
    @Extension
    protected ICommonDataCalculator commonDataCalculator;
    @Extension
    protected TriggerExtensions triggerExtensions;
    protected IDiagnostician validator;
    private final FsmGenFactory factory = FsmGenFactory.eINSTANCE;

    public ExtendedFsmGenBuilder(FSMHelpers fsmHelpers, ICommonDataCalculator commonDataCalculator, TriggerExtensions triggerExtensions, IDiagnostician validator) {
        super(fsmHelpers);
        this.commonDataCalculator = commonDataCalculator;
        this.triggerExtensions = triggerExtensions;
        IDiagnostician iDiagnostician = null;
        iDiagnostician = validator == null ? new NullDiagnostician() : validator;
        this.validator = iDiagnostician;
    }

    public GraphContainer withTriggersInStates(GraphContainer gc) {
        boolean bl;
        boolean bl2 = gc.isInitializedTriggersInStates();
        boolean bl3 = bl = !bl2;
        if (bl) {
            boolean bl4;
            Graph graph = gc.getGraph();
            boolean bl5 = bl4 = graph != null;
            if (bl4) {
                Functions.Function1<Node, Boolean> function1 = new Functions.Function1<Node, Boolean>(){

                    public Boolean apply(Node it) {
                        Graph graph = it.getSubgraph();
                        return graph == null;
                    }
                };
                Procedures.Procedure1<Node> procedure1 = new Procedures.Procedure1<Node>(){

                    public void apply(Node it) {
                        ExtendedFsmGenBuilder.this.computeTriggers(it);
                    }
                };
                IteratorExtensions.forEach((Iterator)IteratorExtensions.filter(FsmGenExtensions.getAllStateNodes(gc.getGraph()), (Functions.Function1)function1), (Procedures.Procedure1)procedure1);
            }
            gc.setInitializedTriggersInStates(true);
        }
        return gc;
    }

    public GraphContainer withChainHeads(GraphContainer gc) {
        boolean bl;
        boolean bl2 = gc.isInitializedChainHeads();
        boolean bl3 = bl = !bl2;
        if (bl) {
            boolean bl4;
            Graph graph = gc.getGraph();
            boolean bl5 = bl4 = graph != null;
            if (bl4) {
                Procedures.Procedure1<Link> procedure1 = new Procedures.Procedure1<Link>(){

                    public void apply(Link it) {
                        ExtendedFsmGenBuilder.this.followChain(it, it);
                    }
                };
                IteratorExtensions.forEach(FsmGenExtensions.getAllChainHeads(gc.getGraph()), (Procedures.Procedure1)procedure1);
            }
            gc.setInitializedChainHeads(true);
        }
        return gc;
    }

    public GraphContainer withCommonData(GraphContainer gc) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = gc.isInitializedChainHeads();
        boolean bl5 = bl3 = !bl4;
        if (bl3) {
            this.withChainHeads(gc);
        }
        boolean bl6 = bl2 = !(bl = gc.isInitializedCommonData());
        if (bl2) {
            boolean bl7;
            Graph graph = gc.getGraph();
            boolean bl8 = bl7 = graph != null;
            if (bl7) {
                Procedures.Procedure1<Link> procedure1 = new Procedures.Procedure1<Link>(){

                    public void apply(Link it) {
                        it.setCommonData(ExtendedFsmGenBuilder.this.commonDataCalculator.calculateCommonData(it));
                    }
                };
                IteratorExtensions.forEach(FsmGenExtensions.getAllLinks(gc.getGraph()), (Procedures.Procedure1)procedure1);
            }
            gc.setInitializedCommonData(true);
        }
        return gc;
    }

    private void followChain(Link l, Link head) {
        boolean bl;
        TransitionBase transitionBase = head.getTransition();
        boolean bl2 = bl = !(transitionBase instanceof TriggeredTransition);
        if (bl) {
            l.setIfitemTriggered(false);
        }
        l.getChainHeads().add((Object)head);
        StateGraphNode target = l.getTarget().getStateGraphNode();
        if (target instanceof State || target instanceof TransitionPoint) {
            return;
        }
        EList<Link> eList = l.getTarget().getOutgoing();
        for (Link next : eList) {
            this.followChain(next, head);
        }
    }

    private void computeTriggers(Node s) {
        LinkedHashMap caughtTriggers = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        this.computeTriggersRecursive(s, caughtTriggers);
        s.getCaughtTriggers().clear();
        s.getCaughtTriggers().addAll(caughtTriggers.values());
    }

    private void computeTriggersRecursive(Node s, HashMap<String, CommonTrigger> caughtTriggers) {
        boolean bl;
        this.computeTriggers(IterableExtensions.toList(FsmGenExtensions.getOutgoingTriggeredTransitionLinks(s)), caughtTriggers);
        Functions.Function1<Node, Iterable<Link>> function1 = new Functions.Function1<Node, Iterable<Link>>(){

            public Iterable<Link> apply(Node it) {
                return FsmGenExtensions.getOutgoingTriggeredTransitionLinks(it);
            }
        };
        List trPointTransitions = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map(FsmGenExtensions.getTransitionPointNodes(s.getGraph()), (Functions.Function1)function1)));
        this.computeTriggers(trPointTransitions, caughtTriggers);
        boolean bl2 = FsmGenExtensions.isTopLevel(s.getGraph());
        boolean bl3 = bl = !bl2;
        if (bl) {
            this.computeTriggersRecursive(FsmGenExtensions.getParentState(s), caughtTriggers);
        }
    }

    private void computeTriggers(List<Link> sameLevelLinks, HashMap<String, CommonTrigger> caughtTriggers) {
        final HashMap trans2link = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Consumer<Link> consumer = new Consumer<Link>(){

            @Override
            public void accept(Link it) {
                trans2link.put(it.getTransition(), it);
            }
        };
        sameLevelLinks.forEach(consumer);
        for (Link l : sameLevelLinks) {
            TransitionBase transitionBase = l.getTransition();
            EList eList = ((TriggeredTransition)transitionBase).getTriggers();
            for (Trigger tr : eList) {
                boolean triggerHasGuard = this.fsmHelpers.hasGuard(tr);
                EList eList2 = tr.getMsgFromIfPairs();
                for (MessageFromIf mif : eList2) {
                    TriggeredTransition unguarded;
                    final String tag = this.triggerExtensions.getTriggerTag(mif);
                    CommonTrigger ct = caughtTriggers.get(tag);
                    if (ct == null) {
                        ct = this.createCommonTrigger(l, mif, tag);
                        ct.setHasGuard(triggerHasGuard);
                        caughtTriggers.put(tag, ct);
                        continue;
                    }
                    Functions.Function1<Link, EList<Trigger>> function1 = new Functions.Function1<Link, EList<Trigger>>(){

                        public EList<Trigger> apply(Link it) {
                            TransitionBase transitionBase = it.getTransition();
                            return ((TriggeredTransition)transitionBase).getTriggers();
                        }
                    };
                    Functions.Function1<Trigger, Boolean> function12 = new Functions.Function1<Trigger, Boolean>(){

                        public Boolean apply(Trigger it) {
                            return ExtendedFsmGenBuilder.this.hasMatchingTrigger(it, tag) && !ExtendedFsmGenBuilder.this.fsmHelpers.hasGuard(it);
                        }
                    };
                    Trigger trigger = (Trigger)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map(ct.getLinks(), (Functions.Function1)function1)), (Functions.Function1)function12));
                    EObject eObject = null;
                    if (trigger != null) {
                        eObject = trigger.eContainer();
                    }
                    if ((unguarded = (TriggeredTransition)eObject) != null) {
                        Link unguardedLink = (Link)trans2link.get(unguarded);
                        boolean bl = sameLevelLinks.contains(unguardedLink);
                        if (!bl) continue;
                        if (triggerHasGuard) {
                            int idx = ct.getLinks().indexOf((Object)unguardedLink);
                            ct.setHasGuard(triggerHasGuard);
                            ct.getLinks().add(idx, (Object)l);
                            continue;
                        }
                        this.validationError("Transitions with same trigger on same level have to be guarded!", (EObject)l.getTransition(), (EStructuralFeature)FSMPackage.eINSTANCE.getTriggeredTransition_Triggers());
                        continue;
                    }
                    ct.getLinks().add((Object)l);
                }
            }
        }
    }

    private boolean hasMatchingTrigger(Trigger trig, String tag) {
        EList eList = trig.getMsgFromIfPairs();
        for (MessageFromIf mifp2 : eList) {
            String tr2 = this.triggerExtensions.getTriggerTag(mifp2);
            boolean bl = tr2.equals(tag);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private CommonTrigger createCommonTrigger(Link l, MessageFromIf mif, String tag) {
        CommonTrigger it = this.factory.createCommonTrigger();
        it.setTrigger(tag);
        it.setIfitem(mif.getFrom());
        it.setMsg(mif.getMessage());
        it.getLinks().add((Object)l);
        return it;
    }

    protected void validationError(String msg, EObject obj, EStructuralFeature feature) {
        this.validationError(msg, obj, feature, -1);
    }

    protected void validationError(String msg, EObject obj, EStructuralFeature feature, int idx) {
        this.validator.error(msg, obj, feature, idx);
    }
}

