/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FsmGenChecker {
    public static void check(GraphContainer gc, final ILogger logger) {
        Procedures.Procedure1<Graph> procedure1 = new Procedures.Procedure1<Graph>(){

            public void apply(Graph it) {
                FsmGenChecker.checkGraph(it, logger);
            }
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)gc.eAllContents(), Graph.class), (Procedures.Procedure1)procedure1);
        Procedures.Procedure1<Node> procedure12 = new Procedures.Procedure1<Node>(){

            public void apply(Node it) {
                FsmGenChecker.checkNode(it, logger);
            }
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)gc.eAllContents(), Node.class), (Procedures.Procedure1)procedure12);
        Procedures.Procedure1<Link> procedure13 = new Procedures.Procedure1<Link>(){

            public void apply(Link it) {
                FsmGenChecker.checkLink(it, logger);
            }
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)gc.eAllContents(), Link.class), (Procedures.Procedure1)procedure13);
    }

    private static void checkLink(Link it, ILogger logger) {
        boolean bl;
        boolean bl2;
        TransitionBase transitionBase = it.getTransition();
        boolean bl3 = bl2 = transitionBase == null;
        if (bl2) {
            logger.logError("graph doesn't point to ROOM transition");
        } else {
            boolean bl4 = it.getTransition().eIsProxy();
            if (bl4) {
                logger.logError("unresolved ROOM transition");
            } else {
                boolean bl5;
                EObject eObject = it.getTransition().eContainer();
                boolean bl6 = bl5 = eObject == null;
                if (bl5) {
                    logger.logError("dangling ROOM transition");
                } else {
                    boolean bl7;
                    Node node = it.getTarget();
                    boolean bl8 = bl7 = node == null;
                    if (bl7) {
                        logger.logError("link without target");
                    } else if (it.getSource() == null && it.getTransition() instanceof NonInitialTransition) {
                        logger.logError("non-initial link without source");
                    }
                }
            }
        }
        Node node = it.getSource();
        boolean bl9 = bl = node != null;
        if (bl) {
            FsmGenChecker.checkLinkEnd(it, it.getSource(), logger);
        }
        FsmGenChecker.checkLinkEnd(it, it.getTarget(), logger);
    }

    private static void checkLinkEnd(Link link, Node node, ILogger logger) {
        boolean bl;
        EObject eObject;
        EObject eObject2 = node.eContainer();
        boolean bl2 = Objects.equal((Object)eObject2, (Object)(eObject = link.eContainer()));
        if (bl2) {
            return;
        }
        StateGraphNode stateGraphNode = node.getStateGraphNode();
        boolean bl3 = bl = !(stateGraphNode instanceof TrPoint);
        if (bl) {
            logger.logError("subgraph item is not transition point");
        } else {
            boolean bl4;
            EObject eObject3 = node.eContainer().eContainer();
            boolean bl5 = bl4 = !(eObject3 instanceof Node);
            if (bl4) {
                logger.logError("subgraph item is in unexpected container");
            } else {
                boolean bl6;
                EObject eObject4 = node.eContainer().eContainer();
                StateGraphNode stateGraphNode2 = ((Node)eObject4).getStateGraphNode();
                boolean bl7 = bl6 = !(stateGraphNode2 instanceof State);
                if (bl6) {
                    logger.logError("subgraph item is in unexpected container");
                } else {
                    EObject eObject5;
                    boolean bl8;
                    EObject eObject6 = node.eContainer().eContainer().eContainer();
                    boolean bl9 = bl8 = !Objects.equal((Object)eObject6, (Object)(eObject5 = link.eContainer()));
                    if (bl8) {
                        logger.logError("subgraph item is in unexpected container");
                    }
                }
            }
        }
    }

    private static void checkNode(Node it, ILogger logger) {
        boolean bl;
        Graph graph;
        Object object;
        EList<Link> eList;
        boolean bl2;
        StateGraphNode stateGraphNode = it.getStateGraphNode();
        boolean bl3 = bl2 = stateGraphNode == null;
        if (bl2) {
            logger.logError("graph doesn't point to ROOM state graph node");
        } else {
            boolean bl4 = it.getStateGraphNode().eIsProxy();
            if (bl4) {
                logger.logError("unresolved ROOM graph node");
            } else {
                boolean bl5;
                eList = it.getStateGraphNode().eContainer();
                boolean bl6 = bl5 = eList == null;
                if (bl5) {
                    logger.logError("dangling ROOM graph node");
                } else {
                    boolean bl7;
                    object = it.getStateGraphNode().getName();
                    boolean bl8 = bl7 = object == null;
                    if (bl7) {
                        logger.logError("ROOM graph node without name");
                    } else {
                        graph = it.getGraph();
                        boolean bl9 = bl = graph == null;
                        if (bl) {
                            logger.logError("node isn't contained in a graph");
                        }
                    }
                }
            }
        }
        EList<Link> eList2 = it.getIncoming();
        for (Link l : eList2) {
            StateGraphNode stateGraphNode2;
            boolean bl10;
            object = l.getTarget().getStateGraphNode();
            boolean bl11 = bl10 = !Objects.equal((Object)object, (Object)(stateGraphNode2 = it.getStateGraphNode()));
            if (!bl10) continue;
            logger.logError("ROOM target node of an incoming transition must be myself");
        }
        eList = it.getOutgoing();
        for (Link l_1 : eList) {
            StateGraphNode stateGraphNode3 = l_1.getSource().getStateGraphNode();
            boolean bl12 = bl = !Objects.equal((Object)stateGraphNode3, (Object)(graph = it.getStateGraphNode()));
            if (!bl) continue;
            logger.logError("ROOM source node of an outgoing transition must be myself");
        }
    }

    private static void checkGraph(Graph it, ILogger logger) {
        boolean bl;
        StateGraph stateGraph = it.getStateGraph();
        boolean bl2 = bl = stateGraph == null;
        if (bl) {
            logger.logError("graph doesn't point to ROOM state graph");
        } else {
            boolean bl3 = it.getStateGraph().eIsProxy();
            if (bl3) {
                logger.logError("unresolved ROOM graph");
            } else {
                boolean bl4;
                EObject eObject = it.getStateGraph().eContainer();
                boolean bl5 = bl4 = eObject == null;
                if (bl4) {
                    logger.logError("dangling ROOM graph");
                }
            }
        }
    }
}

