/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.editor;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.ui.editor.IValidatingEditor;
import org.eclipse.etrice.core.common.ui.editor.SaveOnFocusLostListener;
import org.eclipse.etrice.core.ui.editor.SelectedModelHelpProvider;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class RoomEditor
extends XtextEditor
implements IValidatingEditor {
    @Inject
    protected IResourceValidator resourceValidator;
    private SaveOnFocusLostListener partListener;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.partListener = new SaveOnFocusLostListener((XtextEditor)this, "org.eclipse.etrice.ui.common.base", "SaveTextOnFocusLost");
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this.partListener);
        super.dispose();
    }

    public boolean isValid() {
        return (Boolean)this.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource resource) throws Exception {
                List result = RoomEditor.this.resourceValidator.validate((Resource)resource, CheckMode.NORMAL_AND_FAST, new CancelIndicator(){

                    public boolean isCanceled() {
                        return false;
                    }
                });
                if (!result.isEmpty()) {
                    for (Issue issue : result) {
                        if (!issue.isSyntaxError() && issue.getSeverity() != Severity.ERROR) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContextProvider.class)) {
            return new SelectedModelHelpProvider(this);
        }
        return super.getAdapter(key);
    }
}

