/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.highlight;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.ui.highlight.BaseSemanticHighlighter;
import org.eclipse.etrice.core.converter.RoomValueConverterService;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.services.RoomGrammarAccess;
import org.eclipse.etrice.core.ui.highlight.XtextHighlightStyles;
import org.eclipse.etrice.core.ui.util.UIExpressionUtil;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.expressions.ui.highlight.AbstractHighlightStyles;
import org.eclipse.etrice.expressions.ui.highlight.ExpressionRuleFactory;
import org.eclipse.etrice.expressions.ui.highlight.TargetLanguageRuleFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class RoomSemanticHighlightingCalculator
extends BaseSemanticHighlighter {
    @Inject
    RoomGrammarAccess grammar;
    @Inject
    RoomValueConverterService converterService;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        UIExpressionUtil.ExpressionCache expressionCache = new UIExpressionUtil.ExpressionCache();
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            if (cancelIndicator.isCanceled()) break;
            super.provideHighlightingFor(node, resource, acceptor);
            EObject obj = node.getGrammarElement();
            if (!(obj instanceof RuleCall)) continue;
            RuleCall ruleCall = (RuleCall)obj;
            if (ruleCall.getRule() == this.grammar.getAnnotationRule()) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"hl_annotation"});
                continue;
            }
            if (ruleCall.getRule() != this.grammar.getCC_STRINGRule()) continue;
            this.detailCodeHighlight(node, acceptor, expressionCache);
        }
    }

    protected void detailCodeHighlight(INode node, IHighlightedPositionAcceptor acceptor, UIExpressionUtil.ExpressionCache cache) {
        String text = this.converterService.getCC_StringConverter().stripDelim(node.getText());
        int offset = node.getOffset() + this.converterService.getCC_StringConverter().getDelim().length();
        DetailCode dc = null;
        if (node.getParent().getSemanticElement() instanceof DetailCode) {
            dc = (DetailCode)node.getParent().getSemanticElement();
        }
        IDetailExpressionProvider exprProvider = UIExpressionUtil.getExpressionProvider(dc, null, cache);
        XtextHighlightStyles styles = new XtextHighlightStyles();
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules((IRule[])Iterables.toArray((Iterable)Iterables.concat((Iterable)TargetLanguageRuleFactory.getGeneralLiteralRules((AbstractHighlightStyles)styles), (Iterable)ExpressionRuleFactory.getInitialExpressionRules((IDetailExpressionProvider)exprProvider, (AbstractHighlightStyles)styles), (Iterable)TargetLanguageRuleFactory.getGeneralKeywordRules((AbstractHighlightStyles)styles)), IRule.class));
        scanner.setRange((IDocument)new Document(text), 0, text.length());
        IToken lastToken = null;
        while (lastToken != Token.EOF) {
            lastToken = scanner.nextToken();
            if (lastToken == null || lastToken.getData() == null) continue;
            acceptor.addPosition(offset + scanner.getTokenOffset(), scanner.getTokenLength(), new String[]{(String)lastToken.getData()});
        }
    }
}

