/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.linking;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.scoping.ModelLocatorUriResolver;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;

public class ImportAwareHyperlinkHelper
extends HyperlinkHelper {
    @Inject
    protected Provider<XtextHyperlink> hyperlinkProvider;
    @Inject
    protected ModelLocatorUriResolver uriResolver;
    @Inject
    protected EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        XtextHyperlink link = this.createByImportObject(resource, offset);
        if (link == null) {
            link = this.createByImportNode(resource, offset);
        }
        if (link != null) {
            acceptor.accept((IHyperlink)link);
        }
        super.createHyperlinksByOffset(resource, offset, acceptor);
    }

    private XtextHyperlink createByImportObject(XtextResource resource, int offset) {
        EObject eObject = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (eObject == null || !(eObject instanceof Import)) {
            return null;
        }
        Import importObj = (Import)eObject;
        if (importObj.getImportURI() == null) {
            return null;
        }
        String uritext = this.uriResolver.resolve(importObj.getImportURI(), (Resource)resource);
        if (uritext == null) {
            return null;
        }
        XtextHyperlink result = (XtextHyperlink)this.hyperlinkProvider.get();
        result.setHyperlinkText(uritext);
        try {
            result.setURI(URI.createURI((String)uritext));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)importObj);
        result.setHyperlinkRegion(new Region(node.getOffset(), node.getLength()));
        return result;
    }

    private XtextHyperlink createByImportNode(XtextResource resource, int offset) {
        RuleCall rc;
        AbstractRule rule;
        ILeafNode leaf;
        EObject grammarElement;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && parseResult.getRootNode() != null && (grammarElement = (leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset)).getParent().getGrammarElement()) instanceof RuleCall && (rule = (rc = (RuleCall)grammarElement).getRule()).getName().equals("Import")) {
            String text = leaf.getText().substring(1, leaf.getText().length() - 1);
            String uritext = this.uriResolver.resolve(text, (Resource)resource);
            if (uritext == null) {
                return null;
            }
            XtextHyperlink result = (XtextHyperlink)this.hyperlinkProvider.get();
            result.setHyperlinkText(uritext);
            result.setHyperlinkRegion(new Region(leaf.getOffset() + 1, leaf.getLength() - 2));
            try {
                result.setURI(URI.createURI((String)uritext));
                return result;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

