/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.Guard;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FSMExtensions {
    @Inject
    @Extension
    protected FSMHelpers _fSMHelpers;

    public <T> List<T> union(Iterable<T> l, T e) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterables.addAll(ret, l);
        ret.add(e);
        return ret;
    }

    public <T> List<T> union(Iterable<T> l1, Iterable<T> l2) {
        ArrayList ret = new ArrayList();
        Iterables.addAll(ret, l1);
        Iterables.addAll(ret, l2);
        return ret;
    }

    public <T> List<T> minus(List<T> l1, List<T> l2) {
        ArrayList<T> ret = new ArrayList<T>(l1);
        ret.removeAll(l2);
        return ret;
    }

    public List<Transition> getOutgoingTransitionsHierarchical(ExpandedModelComponent ac, State s) {
        ArrayList<Transition> result = new ArrayList<Transition>();
        EList _outgoingTransitions = ac.getOutgoingTransitions((StateGraphNode)s);
        result.addAll((Collection<Transition>)_outgoingTransitions);
        EObject _eContainer = s.eContainer();
        StateGraph sg = (StateGraph)_eContainer;
        EList _trPoints = sg.getTrPoints();
        for (TrPoint tp : _trPoints) {
            if (!(tp instanceof TransitionPoint)) continue;
            EList _outgoingTransitions_1 = ac.getOutgoingTransitions((StateGraphNode)tp);
            result.addAll((Collection<Transition>)_outgoingTransitions_1);
        }
        EObject _eContainer_1 = sg.eContainer();
        if (_eContainer_1 instanceof State) {
            EObject _eContainer_2 = sg.eContainer();
            List<Transition> _outgoingTransitionsHierarchical = this.getOutgoingTransitionsHierarchical(ac, (State)_eContainer_2);
            result.addAll(_outgoingTransitionsHierarchical);
        }
        return result;
    }

    public List<State> getLeafStatesLast(List<State> states) {
        List<State> _xblockexpression = null;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return FSMExtensions.this._fSMHelpers.isLeaf(s);
            }
        };
        Iterable leaf = IterableExtensions.filter(states, (Functions.Function1)_function);
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                boolean _isLeaf = FSMExtensions.this._fSMHelpers.isLeaf(s);
                return !_isLeaf;
            }
        };
        Iterable nonLeaf = IterableExtensions.filter(states, (Functions.Function1)_function_1);
        _xblockexpression = this.union(nonLeaf, leaf);
        return _xblockexpression;
    }

    public List<State> getAllLeafStates(ModelComponent mc) {
        StateGraph _stateMachine = mc.getStateMachine();
        return this._fSMHelpers.getLeafStateList(_stateMachine);
    }

    public List<State> getAllBaseStatesLeavesLast(ModelComponent mc) {
        List _allBaseStates = this._fSMHelpers.getAllBaseStates(mc);
        return this.getLeafStatesLast(_allBaseStates);
    }

    public int getNumberOfInheritedStates(ModelComponent mc) {
        ModelComponent _base = mc.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return 0;
        }
        ModelComponent _base_1 = mc.getBase();
        StateGraph _stateMachine = _base_1.getStateMachine();
        List _stateList = this._fSMHelpers.getStateList(_stateMachine);
        int _size = _stateList.size();
        ModelComponent _base_2 = mc.getBase();
        int _numberOfInheritedStates = this.getNumberOfInheritedStates(_base_2);
        return _size + _numberOfInheritedStates;
    }

    public int getNumberOfInheritedBaseStates(ModelComponent ac) {
        ModelComponent _base = ac.getBase();
        boolean _equals = Objects.equal((Object)_base, null);
        if (_equals) {
            return 0;
        }
        ModelComponent _base_1 = ac.getBase();
        StateGraph _stateMachine = _base_1.getStateMachine();
        List _baseStateList = this._fSMHelpers.getBaseStateList(_stateMachine);
        int _size = _baseStateList.size();
        ModelComponent _base_2 = ac.getBase();
        int _numberOfInheritedBaseStates = this.getNumberOfInheritedBaseStates(_base_2);
        return _size + _numberOfInheritedBaseStates;
    }

    public boolean isConditionOrGuard(DetailCode dc) {
        boolean _xblockexpression = false;
        EObject parent = dc.eContainer();
        boolean _switchResult = false;
        boolean _matched = false;
        if (parent instanceof Guard) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && parent instanceof CPBranchTransition) {
            _matched = true;
            DetailCode _condition = ((CPBranchTransition)parent).getCondition();
            _switchResult = Objects.equal((Object)_condition, (Object)dc);
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }
}

