/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.fsm.generic;

import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ExpandedModelComponent;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.ITransitionChainVisitor;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.TransitionChain;
import org.eclipse.etrice.generator.fsm.base.CodegenHelpers;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;

public class TransitionChainVisitor
implements ITransitionChainVisitor {
    private FSMHelpers fsmHelpers = new FSMHelpers();
    private ExpandedModelComponent xpac;
    private ILanguageExtensionBase langExt;
    private CodegenHelpers codegenHelpers;
    private IDetailCodeTranslator translationProvider;
    private TransitionChain tc = null;
    private boolean dataDriven = false;

    protected TransitionChainVisitor(ExpandedModelComponent xpac, ILanguageExtensionBase languageExt, CodegenHelpers codegenHelpers, IDetailCodeTranslator translationProvider) {
        this.xpac = xpac;
        this.langExt = languageExt;
        this.codegenHelpers = codegenHelpers;
        this.translationProvider = translationProvider;
    }

    protected void init(TransitionChain tc) {
        this.tc = tc;
        if (tc.getTransition() instanceof GuardedTransition) {
            this.dataDriven = true;
        } else if (tc.getTransition() instanceof InitialTransition) {
            this.dataDriven = true;
        }
    }

    public String genActionOperationCall(Transition tr) {
        boolean noIfItem = this.dataDriven;
        for (TransitionChain tc : this.xpac.getChains(tr)) {
            noIfItem |= tc.getTransition() instanceof InitialTransition;
        }
        if (this.fsmHelpers.hasDetailCode(tr.getAction())) {
            if (noIfItem) {
                return String.valueOf(this.codegenHelpers.getActionCodeOperationName(tr)) + "(" + this.langExt.selfPointer(false) + ");\n";
            }
            String dataArg = "";
            if (this.xpac.getData(tr) != null) {
                dataArg = this.langExt.generateArglistAndTypedData(this.tc.getData())[0];
            }
            return String.valueOf(this.codegenHelpers.getActionCodeOperationName(tr)) + "(" + this.langExt.selfPointer(true) + "ifitem" + dataArg + ");\n";
        }
        return "";
    }

    public String genEntryOperationCall(State state) {
        return String.valueOf(this.codegenHelpers.getEntryCodeOperationName(state)) + "(" + this.langExt.selfPointer(false) + ");\n";
    }

    public String genExitOperationCall(State state) {
        return String.valueOf(this.codegenHelpers.getExitCodeOperationName(state)) + "(" + this.langExt.selfPointer(false) + ");\n";
    }

    public String genElseIfBranch(CPBranchTransition tr, boolean isFirst) {
        String result = "";
        if (!isFirst) {
            result = "}\nelse ";
        }
        result = String.valueOf(result) + "if (" + this.translationProvider.getTranslatedCode(tr.getCondition()) + ") {\n";
        return result;
    }

    public String genElseBranch(ContinuationTransition tr) {
        String result = "}\nelse {\n";
        return result;
    }

    public String genEndIf() {
        return "}\n";
    }

    public String genReturnState(State state, boolean executeEntryCode) {
        if (executeEntryCode) {
            return "return " + this.codegenHelpers.getGenStateId(state) + ";";
        }
        return "return " + this.codegenHelpers.getGenStateId(state) + " + STATE_MAX;";
    }

    public String genTypedData(TransitionChain tc) {
        String[] result = this.langExt.generateArglistAndTypedData(tc.getData());
        return result[1];
    }
}

