/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.dialogs;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtilXtend;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.ui.common.base.dialogs.AbstractPropertyDialog;
import org.eclipse.etrice.ui.structure.Activator;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class SPPPropertyDialog
extends AbstractPropertyDialog {
    private SPP spp;
    private IScope scope;
    private boolean newSPP;
    private boolean refitem;

    public SPPPropertyDialog(Shell shell, SPP spp, IScope scope, boolean newSPP, boolean refitem) {
        super(shell, "Edit SPP");
        this.spp = spp;
        this.scope = scope;
        this.newSPP = newSPP;
        this.refitem = refitem;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point size = this.getShell().getSize();
        this.getShell().setSize((int)((double)size.x * 1.2), size.y);
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        boolean connected = SupportUtil.getInstance().getValidationUtil().isReferencedInModel(this.spp);
        NameValidator nv = new NameValidator();
        ProtocolValidator pv = new ProtocolValidator();
        ArrayList<IEObjectDescription> protocols = new ArrayList<IEObjectDescription>();
        for (IEObjectDescription desc : this.scope.getAllElements()) {
            EObject obj = desc.getEObjectOrProxy();
            if (!(obj instanceof ProtocolClass)) continue;
            protocols.add(desc);
        }
        Text name = this.createText(body, "Name:", (EObject)this.spp, FSMPackage.eINSTANCE.getAbstractInterfaceItem_Name(), nv);
        Combo protocol = this.createComboUsingDesc(body, "Protocol:", (EObject)this.spp, ProtocolClass.class, RoomPackage.eINSTANCE.getSPP_Protocol(), protocols, RoomPackage.eINSTANCE.getRoomClass_Name(), pv);
        if (!this.newSPP) {
            if (connected) {
                protocol.setEnabled(false);
            }
            if (this.refitem) {
                name.setEnabled(false);
                protocol.setEnabled(false);
            }
        }
        this.createDecorator((Control)name, "invalid name");
        this.createDecorator((Control)protocol, "no protocol selected");
        name.selectAll();
        name.setFocus();
    }

    protected Image getImage() {
        return Activator.getImage("icons/Structure.gif");
    }

    protected String getFeatureContextHelpId() {
        return "SPPPropertyDialog";
    }

    class NameValidator
    implements IValidator {
        NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                FSMValidationUtilXtend.Result result = SupportUtil.getInstance().getValidationUtil().isUniqueName((InterfaceItem)SPPPropertyDialog.this.spp, name);
                if (!result.isOk()) {
                    return ValidationStatus.error((String)result.getMsg());
                }
                return Status.OK_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

    class ProtocolValidator
    implements IValidator {
        ProtocolValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationStatus.error((String)"select a protocol");
            }
            return Status.OK_STATUS;
        }
    }
}

