/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support.feature;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.ui.structure.support.context.InitialAddShapeContext;
import org.eclipse.etrice.ui.structure.support.context.PositionUpdateContext;
import org.eclipse.etrice.ui.structure.support.feature.CommonUpdateFeature;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class ShapeUpdateFeature
extends CommonUpdateFeature {
    public ShapeUpdateFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected void setPosition(EObject bo, Shape shape, PositionUpdateContext context) {
        IPositionProvider.PosAndSize pos = context.getPositionProvider().getPosition(bo);
        if (pos != null) {
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            ga.setX(pos.getX());
            ga.setY(pos.getY());
            if (pos.getW() > 0) {
                ga.setWidth(pos.getW());
            }
            if (pos.getH() > 0) {
                ga.setHeight(pos.getH());
            }
        }
    }

    protected Map<EObject, Shape> getChildrenShapesForBoClass(ContainerShape containerShape, EClass boEClass) {
        HashMap<EObject, Shape> items = new HashMap<EObject, Shape>();
        for (Shape shape : containerShape.getChildren()) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
            if (!boEClass.isInstance(bo)) continue;
            items.put((EObject)bo, shape);
        }
        return items;
    }

    protected Map<EObject, Shape> addShapesInitial(Collection<? extends EObject> toAdd, ContainerShape containerShape) {
        HashMap<EObject, Shape> shapes = new HashMap<EObject, Shape>();
        for (EObject eObject : toAdd) {
            PictogramElement pe = this.getFeatureProvider().addIfPossible((IAddContext)new InitialAddShapeContext(eObject, containerShape));
            if (pe == null) continue;
            assert (pe instanceof Shape) : "unexpected type";
            Shape shape = (Shape)pe;
            shapes.put(eObject, shape);
        }
        return shapes;
    }

    protected void updatePictogramElements(Collection<? extends PictogramElement> toUpdate, IPositionProvider pp) {
        for (PictogramElement pictogramElement : toUpdate) {
            this.getFeatureProvider().updateIfPossibleAndNeeded((IUpdateContext)new PositionUpdateContext(pictogramElement, pp));
        }
    }

    protected void updatePictogramElements(Collection<? extends PictogramElement> toUpdate) {
        for (PictogramElement pictogramElement : toUpdate) {
            this.getFeatureProvider().updateIfPossibleAndNeeded((IUpdateContext)new UpdateContext(pictogramElement));
        }
    }
}

