/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.client.util.BasicFuture;
import org.json.JSONObject;

public abstract class SingleResponseHandler<T>
extends MessageHandler {
    public static final String USERNAME = "username";
    private static final long TIME_OUT = 30000L;
    private static Timer timer;
    private AtomicBoolean timeoutStarted = new AtomicBoolean(false);
    private MessageConnector conn;
    private BasicFuture<T> future;

    private static synchronized Timer timer() {
        if (timer == null) {
            timer = new Timer(SingleResponseHandler.class.getName() + "_TIMER", true);
        }
        return timer;
    }

    private void cleanup() {
        MessageConnector c = this.conn;
        if (c != null) {
            this.conn = null;
            c.removeMessageHandler(this);
        }
    }

    public SingleResponseHandler(MessageConnector conn, String messageType) {
        super(messageType);
        this.conn = conn;
        this.future = new BasicFuture();
        this.future.whenDone(new Runnable(){

            @Override
            public void run() {
                SingleResponseHandler.this.cleanup();
            }
        });
        conn.addMessageHandler(this);
    }

    @Override
    public void handle(String type, JSONObject message) {
        try {
            this.errorParse(type, message);
            this.future.resolve(this.parse(type, message));
        }
        catch (Throwable e) {
            this.future.reject(e);
        }
    }

    protected void errorParse(String messageType, JSONObject message) throws Exception {
        if (message.has("error")) {
            if (message.has("errorDetails")) {
                System.err.println(message.get("errorDetails"));
            }
            throw new Exception(message.getString("error"));
        }
    }

    protected abstract T parse(String var1, JSONObject var2) throws Exception;

    public T awaitResult() throws Exception {
        return this.getFuture().get();
    }

    private void ensureTimeout() {
        if (!this.future.isDone() && this.timeoutStarted.compareAndSet(false, true)) {
            SingleResponseHandler.timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        SingleResponseHandler.this.future.reject(new TimeoutException());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }, 30000L);
        }
    }

    public BasicFuture<T> getFuture() {
        this.ensureTimeout();
        return this.future;
    }
}

