/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.eclipse.flux.client.ConnectionStatus;
import org.eclipse.flux.client.IChannelListener;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.util.Observable;
import org.eclipse.flux.client.util.ObservableState;
import org.json.JSONObject;

public abstract class AbstractMessageConnector
implements MessageConnector {
    private final ConcurrentMap<String, Collection<IMessageHandler>> messageHandlers = new ConcurrentHashMap<String, Collection<IMessageHandler>>();
    protected final ExecutorService executor;
    private ConcurrentLinkedQueue<IChannelListener> channelListeners = new ConcurrentLinkedQueue();
    protected final ObservableState<ConnectionStatus> connectionStatus = new ObservableState<ConnectionStatus>(ConnectionStatus.INITIALIZING);

    public AbstractMessageConnector(ExecutorService executor) {
        this.executor = executor;
    }

    protected void handleIncomingMessage(final String messageType, final JSONObject message) {
        Collection handlers = (Collection)this.messageHandlers.get(messageType);
        if (handlers != null) {
            for (final IMessageHandler handler : handlers) {
                try {
                    if (!handler.canHandle(messageType, message)) continue;
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            handler.handle(messageType, message);
                        }
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public void addChannelListener(IChannelListener listener) {
        this.channelListeners.add(listener);
    }

    @Override
    public void removeChannelListener(IChannelListener listener) {
        this.channelListeners.remove(listener);
    }

    protected void notifyChannelConnected(String userChannel) {
        for (IChannelListener listener : this.channelListeners) {
            try {
                listener.connected(userChannel);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void notifyChannelDisconnected(String userChannel) {
        for (IChannelListener listener : this.channelListeners) {
            try {
                listener.disconnected(userChannel);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void addMessageHandler(IMessageHandler messageHandler) {
        this.messageHandlers.putIfAbsent(messageHandler.getMessageType(), new ConcurrentLinkedDeque());
        ((Collection)this.messageHandlers.get(messageHandler.getMessageType())).add(messageHandler);
    }

    @Override
    public void removeMessageHandler(IMessageHandler messageHandler) {
        Collection handlers = (Collection)this.messageHandlers.get(messageHandler.getMessageType());
        if (handlers != null) {
            handlers.remove(messageHandler);
        }
    }

    @Override
    public Observable<ConnectionStatus> getState() {
        return this.connectionStatus;
    }
}

