/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.impl;

import org.eclipse.flux.client.config.FluxConfig;
import org.eclipse.flux.client.config.UserPermissions;
import org.eclipse.flux.client.util.Assert;
import org.eclipse.flux.client.util.Console;

public class SimpleUserPermissions
implements UserPermissions {
    private final String user;
    private static final Console console = Console.get(SimpleUserPermissions.class.getName());

    public SimpleUserPermissions(FluxConfig conf) {
        Assert.assertTrue(conf.getUser() != null);
        this.user = conf.getUser();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void checkChannelJoin(String channel) throws UserPermissionException {
        Assert.assertTrue(channel != null);
        if (this.user.equals("$super$") || this.user.equals(channel)) {
            console.log("ACCEPT '" + this.user + "' to join '" + channel + "'");
            return;
        }
        console.log("REJECT '" + this.user + "' to join '" + channel + "'");
        throw this.error("'" + this.user + "' is not allowed to join channel '" + channel + "'");
    }

    private UserPermissionException error(String msg) {
        return new UserPermissionException(msg);
    }

    public static class UserPermissionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UserPermissionException(String msg) {
            super(msg);
        }
    }
}

