/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.impl;

import io.socket.IOAcknowledge;
import io.socket.IOCallback;
import io.socket.SocketIO;
import io.socket.SocketIOException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import org.eclipse.flux.client.ConnectionStatus;
import org.eclipse.flux.client.config.FluxConfig;
import org.eclipse.flux.client.config.SocketIOFluxConfig;
import org.eclipse.flux.client.impl.AbstractMessageConnector;
import org.eclipse.flux.client.util.BasicFuture;
import org.json.JSONException;
import org.json.JSONObject;

public final class SocketIOMessageConnector
extends AbstractMessageConnector {
    private static final long CONNECT_TO_CHANNEL_TIMEOUT = 15000L;
    private SocketIO socket;
    private final SocketIOFluxConfig conf;
    private Set<String> channels = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean isConnected = new AtomicBoolean(false);

    public SocketIOMessageConnector(SocketIOFluxConfig conf, ExecutorService executor) {
        super(executor);
        this.conf = conf;
        try {
            SocketIO.setDefaultSSLSocketFactory((SSLContext)SSLContext.getInstance("Default"));
            this.socket = this.createSocket();
            final BasicFuture connectedFuture = new BasicFuture();
            this.socket.connect(new IOCallback(){

                public void on(String messageType, IOAcknowledge arg1, Object ... data) {
                    if (data.length == 1 && data[0] instanceof JSONObject) {
                        SocketIOMessageConnector.this.handleIncomingMessage(messageType, (JSONObject)data[0]);
                    }
                }

                public void onConnect() {
                    String[] channelsArray;
                    SocketIOMessageConnector.this.connectionStatus.setValue(((ConnectionStatus)SocketIOMessageConnector.this.connectionStatus.getValue()).connect());
                    SocketIOMessageConnector.this.isConnected.compareAndSet(false, true);
                    for (String channel : channelsArray = SocketIOMessageConnector.this.channels.toArray(new String[SocketIOMessageConnector.this.channels.size()])) {
                        SocketIOMessageConnector.this.connectToChannel(channel);
                    }
                    connectedFuture.resolve(null);
                }

                public void onDisconnect() {
                    SocketIOMessageConnector.this.connectionStatus.setValue(((ConnectionStatus)SocketIOMessageConnector.this.connectionStatus.getValue()).close());
                    System.out.println("Socket disconnected: " + SocketIOMessageConnector.this.socket);
                    for (String channel : SocketIOMessageConnector.this.channels) {
                        SocketIOMessageConnector.this.notifyChannelDisconnected(channel);
                    }
                    SocketIOMessageConnector.this.isConnected.compareAndSet(true, false);
                }

                public void onError(SocketIOException ex) {
                    SocketIOMessageConnector.this.connectionStatus.setValue(((ConnectionStatus)SocketIOMessageConnector.this.connectionStatus.getValue()).error((Throwable)ex));
                    connectedFuture.reject((Throwable)ex);
                    ex.printStackTrace();
                    if (((ConnectionStatus)SocketIOMessageConnector.this.connectionStatus.getValue()).isAuthFailure()) {
                        return;
                    }
                    try {
                        this.onDisconnect();
                        SocketIOMessageConnector.this.isConnected.compareAndSet(true, false);
                        SocketIOMessageConnector.this.socket = SocketIOMessageConnector.this.createSocket();
                        SocketIOMessageConnector.this.socket.connect((IOCallback)this);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }

                public void onMessage(String arg0, IOAcknowledge arg1) {
                }

                public void onMessage(JSONObject arg0, IOAcknowledge arg1) {
                }
            });
            connectedFuture.get();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    @Deprecated
    public void connectToChannel(String channel) {
        try {
            this.connectToChannel(channel, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connectToChannelSync(String channel) throws Exception {
        this.connectToChannel(channel, true);
    }

    private void connectToChannel(final String channel, final boolean sync) throws Exception {
        System.out.println("Connecting to Channel: " + channel);
        if (!this.isConnected()) {
            throw new IllegalStateException("Cannot connect to channel. Not connected to socket.io");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Channel name should not be null");
        }
        final BasicFuture connectedFuture = sync ? new BasicFuture() : null;
        try {
            JSONObject message = new JSONObject();
            message.put("channel", (Object)channel);
            this.channels.add(channel);
            this.socket.emit("connectToChannel", new IOAcknowledge(){

                public void ack(Object ... answer) {
                    block5: {
                        try {
                            if (answer.length == 1 && answer[0] instanceof JSONObject && ((JSONObject)answer[0]).getBoolean("connectedToChannel")) {
                                SocketIOMessageConnector.this.notifyChannelConnected(channel);
                                if (sync) {
                                    connectedFuture.resolve(null);
                                }
                            } else {
                                connectedFuture.reject(new IOException("Couldn't connect to channel " + channel));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!sync) break block5;
                            connectedFuture.reject(e);
                        }
                    }
                }
            }, new Object[]{message});
        }
        catch (JSONException e) {
            if (sync) {
                connectedFuture.reject(e);
            }
            e.printStackTrace();
        }
        if (sync) {
            connectedFuture.setTimeout(15000L);
            connectedFuture.get();
        }
    }

    @Override
    public void disconnectFromChannel(final String channel) {
        boolean removed = this.channels.remove(channel);
        if (this.isConnected() && removed) {
            try {
                JSONObject message = new JSONObject();
                message.put("channel", (Object)channel);
                this.socket.emit("disconnectFromChannel", new IOAcknowledge(){

                    public void ack(Object ... answer) {
                        try {
                            if (answer.length == 1 && answer[0] instanceof JSONObject && ((JSONObject)answer[0]).getBoolean("disconnectedFromChannel")) {
                                SocketIOMessageConnector.this.notifyChannelDisconnected(channel);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, new Object[]{message});
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void disconnectFromChannelSync(String channelName) throws Exception {
        throw new Error("Not implemented");
    }

    private SocketIO createSocket() throws MalformedURLException {
        System.out.println("Creating websocket to: " + this.conf.getHost());
        SocketIO socket = new SocketIO(this.conf.getHost());
        if (this.conf.getToken() != null) {
            socket.addHeader("X-flux-user-name", this.conf.getUser());
            socket.addHeader("X-flux-user-token", this.conf.getToken());
        }
        System.out.println("Created websocket: " + socket);
        return socket;
    }

    @Override
    public void send(String messageType, JSONObject message) {
        this.socket.emit(messageType, new Object[]{message});
    }

    @Override
    public boolean isConnected(String channel) {
        return this.isConnected() && this.channels.contains(channel);
    }

    @Override
    public void disconnect() {
        this.socket.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.isConnected.get();
    }

    @Override
    public FluxConfig getConfig() {
        return this.conf;
    }
}

