/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class BasicFuture<T> {
    private boolean isDone = false;
    private Throwable exception;
    private T value;
    private Collection<CompletionCallback<T>> onDone;
    private Timer timer;
    private TimerTask timeoutTask;

    public boolean isDone() {
        return this.isDone;
    }

    public synchronized void resolve(T value) {
        if (this.isDone) {
            return;
        }
        this.value = value;
        this.done();
    }

    public synchronized void reject(Throwable e) {
        if (this.isDone) {
            return;
        }
        this.exception = e;
        if (this.exception == null) {
            this.exception = new RuntimeException();
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        Runnable runOnDone = null;
        BasicFuture basicFuture = this;
        synchronized (basicFuture) {
            if (this.isDone) {
                return;
            }
            this.isDone = true;
            this.notifyAll();
            if (this.onDone != null) {
                final Object[] callbacks = this.onDone.toArray();
                runOnDone = new Runnable(){

                    @Override
                    public void run() {
                        for (Object cb : callbacks) {
                            BasicFuture.this.callback((CompletionCallback)cb);
                        }
                    }
                };
            }
            this.onDone = null;
        }
        if (runOnDone != null) {
            runOnDone.run();
        }
    }

    public synchronized T get() throws InterruptedException, ExecutionException {
        this.waitUntilDone();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.value;
    }

    private synchronized void waitUntilDone() throws ExecutionException {
        while (!this.isDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void whenDone(final Runnable runnable) {
        this.whenDone(new CompletionCallback<T>(){

            @Override
            public void resolved(T result) {
                runnable.run();
            }

            @Override
            public void rejected(Throwable e) {
                runnable.run();
            }
        });
    }

    public synchronized void whenDone(CompletionCallback<T> callback) {
        if (this.isDone()) {
            this.callback(callback);
        } else {
            if (this.onDone == null) {
                this.onDone = new HashSet<CompletionCallback<T>>();
            }
            this.onDone.add(callback);
        }
    }

    private void callback(CompletionCallback<T> callback) {
        if (this.exception != null) {
            callback.rejected(this.exception);
        } else {
            callback.resolved(this.value);
        }
    }

    public void setTimeout(long delay) {
        if (this.isDone()) {
            return;
        }
        this.timeoutTask = new TimerTask(){

            @Override
            public void run() {
                BasicFuture.this.reject(new TimeoutException());
            }
        };
        this.timer().schedule(this.timeoutTask, delay);
        this.whenDone(new Runnable(){

            @Override
            public void run() {
                BasicFuture.this.timeoutTask.cancel();
                BasicFuture.this.timeoutTask = null;
            }
        });
    }

    private synchronized Timer timer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        return this.timer;
    }

    public static interface CompletionCallback<T> {
        public void resolved(T var1);

        public void rejected(Throwable var1);
    }
}

