/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class ExceptionUtil {
    public static Throwable getDeepestCause(Throwable e) {
        Throwable cause = e;
        Throwable parent = e.getCause();
        while (parent != null && parent != e) {
            cause = parent;
            parent = cause.getCause();
        }
        return cause;
    }

    public static String getMessage(Throwable e) {
        Throwable cause = ExceptionUtil.getDeepestCause(e);
        String msg = cause.getClass().getSimpleName() + ": " + cause.getMessage();
        return msg;
    }

    public static String stackTrace(Throwable e) {
        try {
            ByteArrayOutputStream trace = new ByteArrayOutputStream();
            PrintStream dump = new PrintStream((OutputStream)trace, true, "utf8");
            e.printStackTrace(dump);
            return trace.toString("utf8");
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    public static Exception exception(Throwable error) {
        if (error instanceof Exception) {
            return (Exception)error;
        }
        return new RuntimeException(error);
    }

    public static RuntimeException unchecked(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }
}

