/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.client.util;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.flux.client.util.Listener;
import org.eclipse.flux.client.util.Observable;

public class ObservableState<T>
implements Observable<T> {
    private T value;
    private Collection<Listener<T>> listeners;

    public ObservableState(T initialValue) {
        this.value = initialValue;
        this.notifyNewValue(initialValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewValue(T value) {
        Listener[] listeners = null;
        ObservableState observableState = this;
        synchronized (observableState) {
            if (this.listeners != null) {
                listeners = this.listeners.toArray(new Listener[this.listeners.size()]);
            }
        }
        if (listeners != null) {
            for (Listener l : listeners) {
                this.notifyNewValue(l, value);
            }
        }
    }

    private void notifyNewValue(Listener<T> l, T value) {
        l.newValue(this, value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValue(T v) {
        ObservableState observableState = this;
        synchronized (observableState) {
            if (this.equal(this.value, v)) {
                return;
            }
            this.value = v;
        }
        this.notifyNewValue(v);
    }

    private boolean equal(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Listener<T> l) {
        ObservableState observableState = this;
        synchronized (observableState) {
            if (this.listeners == null) {
                this.listeners = this.createCollection();
            }
            this.listeners.add(l);
        }
        this.notifyNewValue(l, this.value);
    }

    private HashSet<Listener<T>> createCollection() {
        return new HashSet<Listener<T>>();
    }

    @Override
    public synchronized void removeListener(Listener<T> l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }
}

