/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.flux.jdt.services.SignatureUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;

public class TypeProposalUtils {
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final String[] IMPORTS_ORDER = new String[]{"java", "javax", "org", "com"};
    private static final int IMPORTS_THRESHOLD = 99;

    static void createName(ITypeBinding type, boolean includePackage, List<String> list) {
        ITypeBinding baseType = type;
        if (type.isArray()) {
            baseType = type.getElementType();
        }
        if (!baseType.isPrimitive() && !baseType.isNullType()) {
            ITypeBinding declaringType = baseType.getDeclaringClass();
            if (declaringType != null) {
                TypeProposalUtils.createName(declaringType, includePackage, list);
            } else if (includePackage && !baseType.getPackage().isUnnamed()) {
                String[] components = baseType.getPackage().getNameComponents();
                int i = 0;
                while (i < components.length) {
                    list.add(components[i]);
                    ++i;
                }
            }
        }
        if (!baseType.isAnonymous()) {
            list.add(type.getName());
        } else {
            list.add("$local$");
        }
    }

    static String getTypeQualifiedName(ITypeBinding type) {
        ArrayList<String> result = new ArrayList<String>(5);
        TypeProposalUtils.createName(type, false, result);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < result.size()) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append((String)result.get(i));
            ++i;
        }
        return buffer.toString();
    }

    static String[] getSuperTypeSignatures(IType subType, IType superType) throws JavaModelException {
        if (superType.isInterface()) {
            return subType.getSuperInterfaceTypeSignatures();
        }
        return new String[]{subType.getSuperclassTypeSignature()};
    }

    static String findMatchingSuperTypeSignature(IType subType, IType superType) throws JavaModelException {
        String[] signatures = TypeProposalUtils.getSuperTypeSignatures(subType, superType);
        int i = 0;
        while (i < signatures.length) {
            String superFQN;
            String signature = signatures[i];
            String qualified = SignatureUtil.qualifySignature(signature, subType);
            String subFQN = SignatureUtil.stripSignatureToFQN(qualified);
            if (subFQN.equals(superFQN = superType.getFullyQualifiedName())) {
                return signature;
            }
            ++i;
        }
        return null;
    }

    static int findMatchingTypeArgumentIndex(String signature, String argument) {
        String[] typeArguments = Signature.getTypeArguments((String)signature);
        int i = 0;
        while (i < typeArguments.length) {
            if (Signature.getSignatureSimpleName((String)typeArguments[i]).equals(argument)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mapTypeParameterIndex(IType[] path, int pathIndex, int paramIndex) throws JavaModelException, ArrayIndexOutOfBoundsException {
        ITypeParameter param;
        if (pathIndex == 0) {
            return paramIndex;
        }
        IType subType = path[pathIndex];
        IType superType = path[pathIndex - 1];
        String superSignature = TypeProposalUtils.findMatchingSuperTypeSignature(subType, superType);
        int index = TypeProposalUtils.findMatchingTypeArgumentIndex(superSignature, (param = subType.getTypeParameters()[paramIndex]).getElementName());
        if (index == -1) {
            return -1;
        }
        return TypeProposalUtils.mapTypeParameterIndex(path, pathIndex - 1, index);
    }

    static IType[] computeInheritancePath(IType subType, IType superType) throws JavaModelException {
        if (superType == null) {
            return null;
        }
        if (superType.equals(subType)) {
            return new IType[]{subType};
        }
        ITypeHierarchy hierarchy = subType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        if (!hierarchy.contains(superType)) {
            return null;
        }
        LinkedList<IType> path = new LinkedList<IType>();
        path.add(superType);
        do {
            superType = hierarchy.getSubtypes(superType)[0];
            path.add(superType);
        } while (!superType.equals(subType));
        return path.toArray(new IType[path.size()]);
    }

    static boolean isPackageInfo(ICompilationUnit cu) {
        return PACKAGE_INFO_JAVA.equals(cu.getElementName());
    }

    static ImportRewrite createImportRewrite(ICompilationUnit compilationUnit) {
        try {
            ImportRewrite rewrite = ImportRewrite.create((ICompilationUnit)compilationUnit, (boolean)true);
            rewrite.setImportOrder(IMPORTS_ORDER);
            rewrite.setOnDemandImportThreshold(99);
            rewrite.setStaticOnDemandImportThreshold(99);
            return rewrite;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if ("java.lang".equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        String mainTypeName = TypeProposalUtils.concatenateName(packageName, typeName);
        return qualifier.equals(mainTypeName);
    }

    private static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }
}

