/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public final class ASTProvider {
    public static final int SHARED_AST_LEVEL = 8;
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    public static final boolean SHARED_BINDING_RECOVERY = true;

    public CompilationUnit getAST(ITypeRoot input, IProgressMonitor progressMonitor) {
        CompilationUnit ast = null;
        ast = ASTProvider.createAST(input, progressMonitor);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            ast = null;
        }
        return ast;
    }

    private static CompilationUnit createAST(ITypeRoot input, final IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setSource(input);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final CompilationUnit[] root = new CompilationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        return;
                    }
                    root[0] = (CompilationUnit)parser.createAST(progressMonitor);
                    ASTNodes.setFlagsToAST((ASTNode)root[0], 4);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, JavaPlugin.getPluginId(), 0, "Error in JDT Core during AST creation", ex);
                JavaPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        return root[0];
    }
}

