/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.AdvancedQuickAssistProcessor;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    public static final String SPLIT_JOIN_VARIABLE_DECLARATION_ID = "org.eclipse.jdt.ui.correction.splitJoinVariableDeclaration.assist";
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ui.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ui.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignParamToField.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ui.correction.addBlock.assist";
    public static final String EXTRACT_LOCAL_ID = "org.eclipse.jdt.ui.correction.extractLocal.assist";
    public static final String EXTRACT_LOCAL_NOT_REPLACE_ID = "org.eclipse.jdt.ui.correction.extractLocalNotReplaceOccurrences.assist";
    public static final String EXTRACT_CONSTANT_ID = "org.eclipse.jdt.ui.correction.extractConstant.assist";
    public static final String INLINE_LOCAL_ID = "org.eclipse.jdt.ui.correction.inlineLocal.assist";
    public static final String CONVERT_LOCAL_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.convertLocalToField.assist";
    public static final String CONVERT_ANONYMOUS_TO_LOCAL_ID = "org.eclipse.jdt.ui.correction.convertAnonymousToLocal.assist";
    public static final String CONVERT_TO_STRING_BUFFER_ID = "org.eclipse.jdt.ui.correction.convertToStringBuffer.assist";
    public static final String CONVERT_TO_MESSAGE_FORMAT_ID = "org.eclipse.jdt.ui.correction.convertToMessageFormat.assist";
    public static final String EXTRACT_METHOD_INPLACE_ID = "org.eclipse.jdt.ui.correction.extractMethodInplace.assist";

    @Override
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTNode> coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            return QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, null) || QuickAssistProcessor.getPickoutTypeFromMulticatchProposals(context, coveringNode, coveredNodes, null) || QuickAssistProcessor.getConvertToMultiCatchProposals(context, coveringNode, null) || QuickAssistProcessor.getUnrollMultiCatchProposals(context, coveringNode, null) || QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, null, null) || QuickAssistProcessor.getRenameRefactoringProposal(context, coveringNode, null, null) || QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, null, null) || QuickAssistProcessor.getUnWrapProposals(context, coveringNode, null) || QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, null) || QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, null) || QuickAssistProcessor.getAddElseProposals(context, coveringNode, null) || QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddBlockProposals(context, coveringNode, null) || QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, null) || QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, null) || QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertEnhancedForLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getGenerateForLoopProposals(context, coveringNode, null, null) || QuickAssistProcessor.getExtractVariableProposal(context, false, null) || QuickAssistProcessor.getExtractMethodProposal(context, coveringNode, false, null) || QuickAssistProcessor.getInlineLocalProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertLocalToFieldProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertAnonymousToNestedProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertAnonymousClassCreationsToLambdaProposals(context, coveringNode, null) || QuickAssistProcessor.getConvertLambdaToAnonymousClassCreationsProposals(context, coveringNode, null) || QuickAssistProcessor.getChangeLambdaBodyToBlockProposal(context, coveringNode, null) || QuickAssistProcessor.getChangeLambdaBodyToExpressionProposal(context, coveringNode, null) || QuickAssistProcessor.getRemoveBlockProposals(context, coveringNode, null) || QuickAssistProcessor.getMakeVariableDeclarationFinalProposals(context, null) || QuickAssistProcessor.getMissingCaseStatementProposals(context, coveringNode, null) || QuickAssistProcessor.getConvertStringConcatenationProposals(context, null) || QuickAssistProcessor.getInferDiamondArgumentsProposal(context, coveringNode, null, null);
        }
        return false;
    }

    @Override
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTNode> coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            ArrayList<ICommandAccess> resultingCollections = new ArrayList<ICommandAccess>();
            boolean noErrorsAtLocation = QuickAssistProcessor.noErrorsAtLocation(locations);
            QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getRenameRefactoringProposal(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getInferDiamondArgumentsProposal(context, coveringNode, locations, resultingCollections);
            QuickAssistProcessor.getGenerateForLoopProposals(context, coveringNode, locations, resultingCollections);
            if (noErrorsAtLocation) {
                boolean problemsAtLocation = locations.length != 0;
                QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getPickoutTypeFromMulticatchProposals(context, coveringNode, coveredNodes, resultingCollections);
                QuickAssistProcessor.getConvertToMultiCatchProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getUnrollMultiCatchProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getUnWrapProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddElseProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddBlockProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getExtractVariableProposal(context, problemsAtLocation, resultingCollections);
                QuickAssistProcessor.getExtractMethodProposal(context, coveringNode, problemsAtLocation, resultingCollections);
                QuickAssistProcessor.getInlineLocalProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertLocalToFieldProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertAnonymousToNestedProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertAnonymousClassCreationsToLambdaProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertLambdaToAnonymousClassCreationsProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getChangeLambdaBodyToBlockProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getChangeLambdaBodyToExpressionProposal(context, coveringNode, resultingCollections);
                if (!QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, resultingCollections)) {
                    QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, resultingCollections);
                }
                QuickAssistProcessor.getConvertEnhancedForLoopProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getRemoveBlockProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getMakeVariableDeclarationFinalProposals(context, resultingCollections);
                QuickAssistProcessor.getConvertStringConcatenationProposals(context, resultingCollections);
                QuickAssistProcessor.getMissingCaseStatementProposals(context, coveringNode, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    static boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if (location.isError() && (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)location.getProblemId()) == null)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    private static boolean getExtractMethodProposal(IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<ICommandAccess> proposals) throws CoreException {
        return true;
    }

    private static boolean getExtractVariableProposal(IInvocationContext context, boolean problemsAtLocation, Collection<ICommandAccess> proposals) throws CoreException {
        return false;
    }

    private static boolean getConvertAnonymousToNestedProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) throws CoreException {
        if (!(node instanceof Name)) {
            return false;
        }
        ASTNode normalized = ASTNodes.getNormalizedNode(node);
        if (normalized.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
            return false;
        }
        AnonymousClassDeclaration anonymTypeDecl = ((ClassInstanceCreation)normalized.getParent()).getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        context.getCompilationUnit();
        String extTypeName = ASTNodes.getSimpleNameIdentifier((Name)node);
        ITypeBinding anonymTypeBinding = anonymTypeDecl.resolveBinding();
        String className = anonymTypeBinding.getInterfaces().length == 0 ? Messages.format(CorrectionMessages.QuickAssistProcessor_name_extension_from_interface, extTypeName) : Messages.format(CorrectionMessages.QuickAssistProcessor_name_extension_from_class, extTypeName);
        String[][] existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(className);
        int i = 1;
        while (existingTypes != null) {
            existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(String.valueOf(className) + ++i);
        }
        return false;
    }

    private static boolean getConvertAnonymousClassCreationsToLambdaProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    public static boolean getConvertLambdaToAnonymousClassCreationsProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getChangeLambdaBodyToBlockProposal(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        ExpressionStatement statementInBlockBody;
        LambdaExpression lambda;
        if (covering instanceof LambdaExpression) {
            lambda = (LambdaExpression)covering;
        } else if (covering.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent();
        } else {
            return false;
        }
        if (!(lambda.getBody() instanceof Expression)) {
            return false;
        }
        if (lambda.resolveMethodBinding() == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)lambda.resolveMethodBinding().getReturnType())) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
        String label = CorrectionMessages.QuickAssistProcessor_change_lambda_body_to_block;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 3);
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getChangeLambdaBodyToExpressionProposal(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        Expression exprBody;
        LambdaExpression lambda;
        if (covering instanceof LambdaExpression) {
            lambda = (LambdaExpression)covering;
        } else {
            if (covering.getLocationInParent() != LambdaExpression.BODY_PROPERTY) return false;
            lambda = (LambdaExpression)covering.getParent();
        }
        if (!(lambda.getBody() instanceof Block)) {
            return false;
        }
        Block lambdaBody = (Block)lambda.getBody();
        if (lambdaBody.statements().size() != 1) {
            return false;
        }
        Statement singleStatement = (Statement)lambdaBody.statements().get(0);
        if (singleStatement instanceof ReturnStatement) {
            Expression returnExpr = ((ReturnStatement)singleStatement).getExpression();
            if (returnExpr == null) {
                return false;
            }
            exprBody = returnExpr;
        } else {
            if (!(singleStatement instanceof ExpressionStatement)) return false;
            Expression expression = ((ExpressionStatement)singleStatement).getExpression();
            if (!QuickAssistProcessor.isValidExpressionBody(expression)) return false;
            exprBody = expression;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression movedBody = (Expression)rewrite.createMoveTarget((ASTNode)exprBody);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)movedBody, null);
        String label = CorrectionMessages.QuickAssistProcessor_change_lambda_body_to_expression;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 3);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isValidExpressionBody(Expression expression) {
        PrefixExpression.Operator operator;
        boolean isValidExpressionBody;
        boolean bl = isValidExpressionBody = expression instanceof Assignment || expression instanceof ClassInstanceCreation || expression instanceof MethodInvocation || expression instanceof PostfixExpression || expression instanceof SuperMethodInvocation;
        if (expression instanceof PrefixExpression && ((operator = ((PrefixExpression)expression).getOperator()) == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT)) {
            isValidExpressionBody = true;
        }
        return isValidExpressionBody;
    }

    public static boolean getInferDiamondArgumentsProposal(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        ClassInstanceCreation creation;
        Type type;
        if (QuickAssistProcessor.containsMatchingProblem(locations, 16778099)) {
            return false;
        }
        ParameterizedType createdType = null;
        if (node instanceof Name) {
            ASTNode type2;
            Name name = ASTNodes.getTopMostName((Name)node);
            if ((name.getLocationInParent() == SimpleType.NAME_PROPERTY || name.getLocationInParent() == NameQualifiedType.NAME_PROPERTY) && (type2 = name.getParent()).getLocationInParent() == ParameterizedType.TYPE_PROPERTY && (createdType = (ParameterizedType)type2.getParent()).getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
                return false;
            }
        } else if (node instanceof ParameterizedType) {
            createdType = (ParameterizedType)node;
            if (createdType.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
                return false;
            }
        } else if (node instanceof ClassInstanceCreation && (type = (creation = (ClassInstanceCreation)node).getType()) instanceof ParameterizedType) {
            createdType = (ParameterizedType)type;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getJoinVariableProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ASTNode parent = node.getParent();
        VariableDeclarationFragment fragment = null;
        boolean onFirstAccess = false;
        if (node instanceof SimpleName && node.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            onFirstAccess = true;
            SimpleName name = (SimpleName)node;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            ASTNode declaring = context.getASTRoot().findDeclaringNode(binding);
            if (!(declaring instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)declaring;
        } else {
            if (!(parent instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)parent;
        }
        IVariableBinding binding = fragment.resolveBinding();
        Expression initializer = fragment.getInitializer();
        if (initializer != null && initializer.getNodeType() != 33 || binding == null || binding.isField()) {
            return false;
        }
        if (!(fragment.getParent() instanceof VariableDeclarationStatement)) {
            return false;
        }
        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
        SimpleName[] names = LinkedNodeFinder.findByBinding(statement.getParent(), (IBinding)binding);
        if (names.length <= 1 || names[0] != fragment.getName()) {
            return false;
        }
        SimpleName firstAccess = names[1];
        if (onFirstAccess ? firstAccess != node : firstAccess.getLocationInParent() != Assignment.LEFT_HAND_SIDE_PROPERTY) {
            return false;
        }
        Assignment assignment = (Assignment)firstAccess.getParent();
        if (assignment.getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY) {
            return false;
        }
        ExpressionStatement assignParent = (ExpressionStatement)assignment.getParent();
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_joindeclaration_description;
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1);
        proposal.setCommandId(SPLIT_JOIN_VARIABLE_DECLARATION_ID);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)assignment.getRightHandSide());
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)placeholder, null);
        if (onFirstAccess) {
            rewrite.replace((ASTNode)assignParent, rewrite.createMoveTarget((ASTNode)statement), null);
        } else if (ASTNodes.isControlStatementBody(assignParent.getLocationInParent())) {
            Block block = ast.newBlock();
            rewrite.replace((ASTNode)assignParent, (ASTNode)block, null);
        } else {
            rewrite.remove((ASTNode)assignParent, null);
        }
        proposal.setEndPosition(rewrite.track((ASTNode)fragment.getName()));
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getSplitVariableProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        ExpressionStatement newStatement;
        VariableDeclarationStatement statement;
        VariableDeclarationFragment fragment;
        if (node instanceof VariableDeclarationFragment) {
            fragment = (VariableDeclarationFragment)node;
        } else if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            fragment = (VariableDeclarationFragment)node.getParent();
        } else {
            return false;
        }
        if (fragment.getInitializer() == null) {
            return false;
        }
        ASTNode fragParent = fragment.getParent();
        if (fragParent instanceof VariableDeclarationStatement) {
            statement = (VariableDeclarationStatement)fragParent;
        } else if (fragParent instanceof VariableDeclarationExpression) {
            if (fragParent.getLocationInParent() == TryStatement.RESOURCES_PROPERTY) {
                return false;
            }
            statement = (Statement)fragParent.getParent();
        } else {
            return false;
        }
        ASTNode statementParent = statement.getParent();
        StructuralPropertyDescriptor property = statement.getLocationInParent();
        if (!property.isChildListProperty()) {
            return false;
        }
        List list = ASTNodes.getChildListProperty(statementParent, (ChildListPropertyDescriptor)property);
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_splitdeclaration_description;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1);
        boolean commandConflict = false;
        for (ICommandAccess completionProposal : resultingCollections) {
            if (!(completionProposal instanceof ChangeCorrectionProposal) || !SPLIT_JOIN_VARIABLE_DECLARATION_ID.equals(((ChangeCorrectionProposal)completionProposal).getCommandId())) continue;
            commandConflict = true;
        }
        if (!commandConflict) {
            proposal.setCommandId(SPLIT_JOIN_VARIABLE_DECLARATION_ID);
        }
        int insertIndex = list.indexOf(statement);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)fragment.getInitializer());
        ITypeBinding binding = fragment.getInitializer().resolveTypeBinding();
        if (placeholder instanceof ArrayInitializer && binding != null && binding.isArray()) {
            ArrayCreation creation = ast.newArrayCreation();
            creation.setInitializer((ArrayInitializer)placeholder);
            ITypeBinding componentType = binding.getElementType();
            Object type = null;
            type = componentType.isPrimitive() ? ast.newPrimitiveType(PrimitiveType.toCode((String)componentType.getName())) : ast.newSimpleType((Name)ast.newSimpleName(componentType.getName()));
            creation.setType(ast.newArrayType((Type)type, binding.getDimensions()));
            placeholder = creation;
        }
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide(placeholder);
        assignment.setLeftHandSide((Expression)ast.newSimpleName(fragment.getName().getIdentifier()));
        if (statement instanceof VariableDeclarationStatement) {
            newStatement = ast.newExpressionStatement((Expression)assignment);
            ++insertIndex;
        } else {
            rewrite.replace(fragment.getParent(), (ASTNode)assignment, null);
            VariableDeclarationFragment newFrag = ast.newVariableDeclarationFragment();
            newFrag.setName(ast.newSimpleName(fragment.getName().getIdentifier()));
            newFrag.extraDimensions().addAll(DimensionRewrite.copyDimensions(fragment.extraDimensions(), rewrite));
            VariableDeclarationExpression oldVarDecl = (VariableDeclarationExpression)fragParent;
            VariableDeclarationStatement newVarDec = ast.newVariableDeclarationStatement(newFrag);
            newVarDec.setType((Type)rewrite.createCopyTarget((ASTNode)oldVarDecl.getType()));
            newVarDec.modifiers().addAll(ASTNodeFactory.newModifiers(ast, oldVarDecl.getModifiers()));
            newStatement = newVarDec;
        }
        ListRewrite listRewriter = rewrite.getListRewrite(statementParent, (ChildListPropertyDescriptor)property);
        listRewriter.insertAt((ASTNode)newStatement, insertIndex, null);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertStringConcatenationProposals(IInvocationContext context, Collection<ICommandAccess> resultingCollections) {
        ASTNode node = context.getCoveringNode();
        BodyDeclaration parentDecl = ASTResolving.findParentBodyDeclaration(node);
        if (!(parentDecl instanceof MethodDeclaration) && !(parentDecl instanceof Initializer)) {
            return false;
        }
        AST ast = node.getAST();
        ITypeBinding stringBinding = ast.resolveWellKnownType("java.lang.String");
        if (node instanceof Expression && !(node instanceof InfixExpression)) {
            node = node.getParent();
        }
        if (node instanceof VariableDeclarationFragment) {
            node = ((VariableDeclarationFragment)node).getInitializer();
        } else if (node instanceof Assignment) {
            node = ((Assignment)node).getRightHandSide();
        }
        InfixExpression oldInfixExpression = null;
        while (node instanceof InfixExpression) {
            InfixExpression curr = (InfixExpression)node;
            if (curr.resolveTypeBinding() != stringBinding || curr.getOperator() != InfixExpression.Operator.PLUS) break;
            oldInfixExpression = curr;
            node = node.getParent();
        }
        if (oldInfixExpression == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        LinkedCorrectionProposal stringBufferProposal = QuickAssistProcessor.getConvertToStringBufferProposal(context, ast, oldInfixExpression);
        resultingCollections.add(stringBufferProposal);
        ASTRewriteCorrectionProposal messageFormatProposal = QuickAssistProcessor.getConvertToMessageFormatProposal(context, ast, oldInfixExpression);
        if (messageFormatProposal != null) {
            resultingCollections.add(messageFormatProposal);
        }
        return true;
    }

    private static LinkedCorrectionProposal getConvertToStringBufferProposal(IInvocationContext context, AST ast, InfixExpression oldInfixExpression) {
        String bufferName;
        Statement insertAfter;
        ListRewrite listRewrite;
        ICompilationUnit cu = context.getCompilationUnit();
        String bufferOrBuilderName = JavaModelUtil.is50OrHigher(cu.getJavaProject()) ? "StringBuilder" : "StringBuffer";
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        SimpleName existingBuffer = QuickAssistProcessor.getEnclosingAppendBuffer(oldInfixExpression);
        String mechanismName = BasicElementLabels.getJavaElementName(existingBuffer == null ? bufferOrBuilderName : existingBuffer.getIdentifier());
        String label = Messages.format(CorrectionMessages.QuickAssistProcessor_convert_to_string_buffer_description, mechanismName);
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 1);
        proposal.setCommandId(CONVERT_TO_STRING_BUFFER_ID);
        String groupID = "nameId";
        Statement enclosingStatement = ASTResolving.findParentStatement((ASTNode)oldInfixExpression);
        if (existingBuffer != null) {
            if (ASTNodes.isControlStatementBody(enclosingStatement.getLocationInParent())) {
                Block newBlock = ast.newBlock();
                listRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
                insertAfter = null;
                rewrite.replace((ASTNode)enclosingStatement, (ASTNode)newBlock, null);
            } else {
                listRewrite = rewrite.getListRewrite(enclosingStatement.getParent(), (ChildListPropertyDescriptor)enclosingStatement.getLocationInParent());
                insertAfter = enclosingStatement;
            }
            bufferName = existingBuffer.getIdentifier();
        } else {
            VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
            Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)oldInfixExpression));
            SimpleType bufferType = ast.newSimpleType(ast.newName(bufferOrBuilderName));
            ClassInstanceCreation newBufferExpression = ast.newClassInstanceCreation();
            String[] newBufferNames = new String[]{};
            bufferName = newBufferNames[0];
            SimpleName bufferNameDeclaration = ast.newSimpleName(bufferName);
            frag.setName(bufferNameDeclaration);
            proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameDeclaration), true, groupID);
            int i = 0;
            while (i < newBufferNames.length) {
                proposal.addLinkedPositionProposal(groupID, newBufferNames[i], null);
                ++i;
            }
            newBufferExpression.setType((Type)bufferType);
            frag.setInitializer((Expression)newBufferExpression);
            VariableDeclarationStatement bufferDeclaration = ast.newVariableDeclarationStatement(frag);
            bufferDeclaration.setType((Type)ast.newSimpleType(ast.newName(bufferOrBuilderName)));
            insertAfter = bufferDeclaration;
            Statement statement = ASTResolving.findParentStatement((ASTNode)oldInfixExpression);
            if (ASTNodes.isControlStatementBody(statement.getLocationInParent())) {
                Block newBlock = ast.newBlock();
                listRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
                listRewrite.insertFirst((ASTNode)bufferDeclaration, null);
                listRewrite.insertLast(rewrite.createMoveTarget((ASTNode)statement), null);
                rewrite.replace((ASTNode)statement, (ASTNode)newBlock, null);
            } else {
                listRewrite = rewrite.getListRewrite(statement.getParent(), (ChildListPropertyDescriptor)statement.getLocationInParent());
                listRewrite.insertBefore((ASTNode)bufferDeclaration, (ASTNode)statement, null);
            }
        }
        ArrayList<Expression> operands = new ArrayList<Expression>();
        QuickAssistProcessor.collectInfixPlusOperands((Expression)oldInfixExpression, operands);
        Statement lastAppend = insertAfter;
        for (Expression operand : operands) {
            MethodInvocation appendIncovationExpression = ast.newMethodInvocation();
            appendIncovationExpression.setName(ast.newSimpleName("append"));
            SimpleName bufferNameReference = ast.newSimpleName(bufferName);
            if (existingBuffer == null) {
                proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameReference), true, groupID);
            }
            appendIncovationExpression.setExpression((Expression)bufferNameReference);
            appendIncovationExpression.arguments().add(rewrite.createCopyTarget((ASTNode)operand));
            ExpressionStatement appendExpressionStatement = ast.newExpressionStatement((Expression)appendIncovationExpression);
            if (lastAppend == null) {
                listRewrite.insertFirst((ASTNode)appendExpressionStatement, null);
            } else {
                listRewrite.insertAfter((ASTNode)appendExpressionStatement, (ASTNode)lastAppend, null);
            }
            lastAppend = appendExpressionStatement;
        }
        if (existingBuffer != null) {
            proposal.setEndPosition(rewrite.track((ASTNode)lastAppend));
            if (insertAfter != null) {
                rewrite.remove((ASTNode)enclosingStatement, null);
            }
        } else {
            MethodInvocation bufferToString = ast.newMethodInvocation();
            bufferToString.setName(ast.newSimpleName("toString"));
            SimpleName bufferNameReference = ast.newSimpleName(bufferName);
            bufferToString.setExpression((Expression)bufferNameReference);
            proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameReference), true, groupID);
            rewrite.replace((ASTNode)oldInfixExpression, (ASTNode)bufferToString, null);
            proposal.setEndPosition(rewrite.track((ASTNode)bufferToString));
        }
        return proposal;
    }

    private static void collectInfixPlusOperands(Expression expression, List<Expression> collector) {
        if (expression instanceof InfixExpression && ((InfixExpression)expression).getOperator() == InfixExpression.Operator.PLUS) {
            InfixExpression infixExpression = (InfixExpression)expression;
            QuickAssistProcessor.collectInfixPlusOperands(infixExpression.getLeftOperand(), collector);
            QuickAssistProcessor.collectInfixPlusOperands(infixExpression.getRightOperand(), collector);
            List extendedOperands = infixExpression.extendedOperands();
            Iterator iter = extendedOperands.iterator();
            while (iter.hasNext()) {
                QuickAssistProcessor.collectInfixPlusOperands((Expression)iter.next(), collector);
            }
        } else {
            collector.add(expression);
        }
    }

    private static SimpleName getEnclosingAppendBuffer(InfixExpression infixExpression) {
        String typeName;
        IBinding binding;
        Expression expression;
        MethodInvocation methodInvocation;
        if (infixExpression.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && (methodInvocation = (MethodInvocation)infixExpression.getParent()).getParent() instanceof Statement && "append".equals(methodInvocation.getName().getIdentifier()) && (expression = methodInvocation.getExpression()) instanceof SimpleName && (binding = ((SimpleName)expression).resolveBinding()) instanceof IVariableBinding && ("java.lang.StringBuilder".equals(typeName = ((IVariableBinding)binding).getType().getQualifiedName()) || "java.lang.StringBuffer".equals(typeName))) {
            return (SimpleName)expression;
        }
        return null;
    }

    private static ASTRewriteCorrectionProposal getConvertToMessageFormatProposal(IInvocationContext context, AST ast, InfixExpression oldInfixExpression) {
        return null;
    }

    public static boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean containsMatchingProblem(IProblemLocation[] locations, int problemId) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if ("org.eclipse.jdt.core.problem".equals(location.getMarkerType()) && location.getProblemId() == problemId) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getAddFinallyProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getAddElseProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static void removeException(ASTRewrite rewrite, UnionType unionType, Type exception) {
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)unionType, UnionType.TYPES_PROPERTY);
        List types = unionType.types();
        for (Type type : types) {
            if (!type.equals((Object)exception)) continue;
            listRewrite.remove((ASTNode)type, null);
        }
    }

    private static void addExceptionToThrows(AST ast, MethodDeclaration methodDeclaration, ASTRewrite rewrite, Type type2) {
        ITypeBinding binding = type2.resolveBinding();
        if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptionTypes())) {
            Type newType = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type2);
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
            listRewriter.insertLast((ASTNode)newType, null);
        }
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null || !tryStatement.resources().isEmpty()) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody(tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List<Type> thrownExceptions) {
        int i = 0;
        while (i < thrownExceptions.size()) {
            Type name = thrownExceptions.get(i);
            ITypeBinding elem = name.resolveBinding();
            if (elem != null && Bindings.isSuperType(elem, binding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean getPickoutTypeFromMulticatchProposals(IInvocationContext context, ASTNode node, ArrayList<ASTNode> coveredNodes, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getConvertToMultiCatchProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getUnrollMultiCatchProposals(IInvocationContext context, ASTNode covering, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static void setCatchClauseBody(CatchClause newCatchClause, ASTRewrite rewrite, CatchClause catchClause) {
        List statements = catchClause.getBody().statements();
        Iterator iterator2 = statements.iterator();
        while (iterator2.hasNext()) {
            newCatchClause.getBody().statements().add(rewrite.createCopyTarget((ASTNode)iterator2.next()));
        }
    }

    private static boolean getRenameLocalProposals(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getRenameRefactoringProposal(IInvocationContext context, ASTNode node, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) throws CoreException {
        return true;
    }

    private static boolean containsQuickFixableRenameLocal(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if ("org.eclipse.jdt.core.problem".equals(location.getMarkerType())) {
                    switch (location.getProblemId()) {
                        case 536871002: 
                        case 536871006: 
                        case 536871007: 
                        case 570425435: 
                        case 570425436: 
                        case 570425437: {
                            return true;
                        }
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static ASTNode getCopyOfInner(ASTRewrite rewrite, ASTNode statement, boolean toControlStatementBody) {
        if (statement.getNodeType() == 8) {
            Block block = (Block)statement;
            List innerStatements = block.statements();
            int nStatements = innerStatements.size();
            if (nStatements == 1) {
                return rewrite.createCopyTarget((ASTNode)innerStatements.get(0));
            }
            if (nStatements > 1) {
                if (toControlStatementBody) {
                    return rewrite.createCopyTarget((ASTNode)block);
                }
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)innerStatements.get(0);
                ASTNode last = (ASTNode)innerStatements.get(nStatements - 1);
                return listRewrite.createCopyTarget(first, last);
            }
            return null;
        }
        return rewrite.createCopyTarget(statement);
    }

    private static boolean getUnWrapProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean isControlStatementWithBlock(ASTNode node) {
        switch (node.getNodeType()) {
            case 19: 
            case 24: 
            case 25: 
            case 61: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    private static boolean getRemoveBlockProposals(IInvocationContext context, ASTNode coveringNode, Collection<ICommandAccess> resultingCollections) {
        return false;
    }

    private static boolean getAddBlockProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof Statement)) {
            return false;
        }
        if (!QuickAssistProcessor.isControlStatementWithBlock(node) && QuickAssistProcessor.isControlStatementWithBlock(node.getParent())) {
            int statementStart = node.getStartPosition();
            int statementEnd = statementStart + node.getLength();
            int offset = context.getSelectionOffset();
            int length = context.getSelectionLength();
            if (length == 0 ? offset != statementEnd : offset > statementStart || offset + length < statementEnd) {
                return false;
            }
            node = node.getParent();
        }
        ChildPropertyDescriptor childProperty = null;
        Statement child = null;
        switch (node.getNodeType()) {
            case 25: {
                Statement then = ((IfStatement)node).getThenStatement();
                Statement elseStatement = ((IfStatement)node).getElseStatement();
                if (then instanceof Block && (elseStatement instanceof Block || elseStatement == null)) break;
                int thenEnd = then.getStartPosition() + then.getLength();
                int selectionEnd = context.getSelectionOffset() + context.getSelectionLength();
                if (!(then instanceof Block)) {
                    if (selectionEnd <= thenEnd) {
                        childProperty = IfStatement.THEN_STATEMENT_PROPERTY;
                        child = then;
                        break;
                    }
                    if (elseStatement != null && selectionEnd < elseStatement.getStartPosition()) {
                        try {
                            TokenScanner scanner = new TokenScanner((ITypeRoot)context.getCompilationUnit());
                            int elseTokenStart = scanner.getNextStartOffset(thenEnd, true);
                            if (selectionEnd < elseTokenStart) {
                                childProperty = IfStatement.THEN_STATEMENT_PROPERTY;
                                child = then;
                                break;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                if (elseStatement == null || elseStatement instanceof Block || context.getSelectionOffset() < thenEnd) break;
                childProperty = IfStatement.ELSE_STATEMENT_PROPERTY;
                child = elseStatement;
                break;
            }
            case 61: {
                Statement whileBody = ((WhileStatement)node).getBody();
                if (whileBody instanceof Block) break;
                childProperty = WhileStatement.BODY_PROPERTY;
                child = whileBody;
                break;
            }
            case 24: {
                Statement forBody = ((ForStatement)node).getBody();
                if (forBody instanceof Block) break;
                childProperty = ForStatement.BODY_PROPERTY;
                child = forBody;
                break;
            }
            case 70: {
                Statement enhancedForBody = ((EnhancedForStatement)node).getBody();
                if (enhancedForBody instanceof Block) break;
                childProperty = EnhancedForStatement.BODY_PROPERTY;
                child = enhancedForBody;
                break;
            }
            case 19: {
                Statement doBody = ((DoStatement)node).getBody();
                if (doBody instanceof Block) break;
                childProperty = DoStatement.BODY_PROPERTY;
                child = doBody;
            }
        }
        if (child == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ASTNode childPlaceholder = rewrite.createMoveTarget((ASTNode)child);
        Block replacingBody = ast.newBlock();
        replacingBody.statements().add(childPlaceholder);
        rewrite.set(node, (StructuralPropertyDescriptor)childProperty, (Object)replacingBody, null);
        String label = childProperty == IfStatement.THEN_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replacethenwithblock_description : (childProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replaceelsewithblock_description : CorrectionMessages.QuickAssistProcessor_replacebodywithblock_description);
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5);
        proposal.setCommandId(ADD_BLOCK_ID);
        proposal.setEndPosition(rewrite.track((ASTNode)child));
        resultingCollections.add(proposal);
        if (node.getNodeType() == 25) {
            IfStatement ifStatement;
            Statement elseStatment;
            rewrite = ASTRewrite.create((AST)ast);
            while (node.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                node = node.getParent();
            }
            boolean missingBlockFound = false;
            boolean foundElse = false;
            do {
                ifStatement = (IfStatement)node;
                Statement thenStatment = ifStatement.getThenStatement();
                elseStatment = ifStatement.getElseStatement();
                if (!(thenStatment instanceof Block)) {
                    ASTNode childPlaceholder1 = rewrite.createMoveTarget((ASTNode)thenStatment);
                    Block replacingBody1 = ast.newBlock();
                    replacingBody1.statements().add(childPlaceholder1);
                    rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.THEN_STATEMENT_PROPERTY, (Object)replacingBody1, null);
                    if (thenStatment != child) {
                        missingBlockFound = true;
                    }
                }
                if (elseStatment != null) {
                    foundElse = true;
                }
                node = elseStatment;
            } while (elseStatment instanceof IfStatement);
            if (elseStatment != null && !(elseStatment instanceof Block)) {
                ASTNode childPlaceholder2 = rewrite.createMoveTarget((ASTNode)elseStatment);
                Block replacingBody2 = ast.newBlock();
                replacingBody2.statements().add(childPlaceholder2);
                rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)replacingBody2, null);
                if (elseStatment != child) {
                    missingBlockFound = true;
                }
            }
            if (missingBlockFound && foundElse) {
                String label2 = CorrectionMessages.QuickAssistProcessor_replacethenelsewithblock_description;
                ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 6);
                resultingCollections.add(proposal2);
            }
        }
        return true;
    }

    private static boolean getInvertEqualsProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        MethodInvocation replacement;
        if (!(node instanceof MethodInvocation) && !((node = node.getParent()) instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation method = (MethodInvocation)node;
        String identifier = method.getName().getIdentifier();
        if (!"equals".equals(identifier) && !"equalsIgnoreCase".equals(identifier)) {
            return false;
        }
        List arguments = method.arguments();
        if (arguments.size() != 1) {
            return false;
        }
        Expression right = (Expression)arguments.get(0);
        ITypeBinding binding = right.resolveTypeBinding();
        if (!(binding == null || binding.isClass() || binding.isInterface() || binding.isEnum())) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Expression left = method.getExpression();
        AST ast = method.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (left == null) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(ast.newThisExpression());
            replacement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else if (right instanceof ThisExpression) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(rewrite.createCopyTarget((ASTNode)left));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else {
            Expression leftExpression = left;
            while (leftExpression instanceof ParenthesizedExpression) {
                leftExpression = ((ParenthesizedExpression)left).getExpression();
            }
            rewrite.replace((ASTNode)right, rewrite.createCopyTarget((ASTNode)leftExpression), null);
            if (right instanceof CastExpression || right instanceof Assignment || right instanceof ConditionalExpression || right instanceof InfixExpression) {
                ParenthesizedExpression paren = ast.newParenthesizedExpression();
                paren.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
                rewrite.replace((ASTNode)left, (ASTNode)paren, null);
            } else {
                rewrite.replace((ASTNode)left, rewrite.createCopyTarget((ASTNode)right), null);
            }
        }
        String label = CorrectionMessages.QuickAssistProcessor_invertequals_description;
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getArrayInitializerToArrayCreation(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        if (!(node instanceof ArrayInitializer)) {
            return false;
        }
        ArrayInitializer initializer = (ArrayInitializer)node;
        ASTNode parent = initializer.getParent();
        while (parent instanceof ArrayInitializer) {
            initializer = (ArrayInitializer)parent;
            parent = parent.getParent();
        }
        ITypeBinding typeBinding = initializer.resolveTypeBinding();
        if (!(parent instanceof VariableDeclaration) || typeBinding == null || !typeBinding.isArray()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_typetoarrayInitializer_description;
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(node, imports);
        String typeName = imports.addImport(typeBinding, (ImportRewrite.ImportRewriteContext)importRewriteContext);
        ArrayCreation creation = ast.newArrayCreation();
        creation.setInitializer((ArrayInitializer)rewrite.createMoveTarget((ASTNode)initializer));
        creation.setType((ArrayType)ASTNodeFactory.newType(ast, typeName));
        rewrite.replace((ASTNode)initializer, (ASTNode)creation, null);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getCreateInSuperClassProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) throws CoreException {
        if (!(node instanceof SimpleName) || !(node.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration decl = (MethodDeclaration)node.getParent();
        if (decl.getName() != node || decl.resolveBinding() == null || Modifier.isPrivate((int)decl.getModifiers())) {
            return false;
        }
        context.getCompilationUnit();
        context.getASTRoot();
        IMethodBinding binding = decl.resolveBinding();
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        ITypeBinding[] superTypes = Bindings.getAllSuperTypes(binding.getDeclaringClass());
        if (resultingCollections == null) {
            int i = 0;
            while (i < superTypes.length) {
                ITypeBinding curr = superTypes[i];
                if (curr.isFromSource() && Bindings.findOverriddenMethodInType(curr, binding) == null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        List params = decl.parameters();
        String[] paramNames = new String[paramTypes.length];
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = param.getName().getIdentifier();
            ++i;
        }
        i = 0;
        while (i < superTypes.length) {
            IMethodBinding method;
            ITypeBinding curr = superTypes[i];
            if (curr.isFromSource() && (method = Bindings.findOverriddenMethodInType(curr, binding)) == null) {
                curr.getTypeDeclaration();
            }
            ++i;
        }
        return true;
    }

    private static boolean getConvertEnhancedForLoopProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getConvertForLoopProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getConvertIterableLoopProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    public static boolean getGenerateForLoopProposals(IInvocationContext context, ASTNode coveringNode, IProblemLocation[] locations, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static ForStatement getEnclosingForStatementHeader(ASTNode node) {
        return QuickAssistProcessor.getEnclosingHeader(node, ForStatement.class, new StructuralPropertyDescriptor[]{ForStatement.INITIALIZERS_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ForStatement.UPDATERS_PROPERTY});
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends ASTNode> T getEnclosingHeader(ASTNode node, Class<T> headerType, StructuralPropertyDescriptor ... headerProperties) {
        if (!headerType.isInstance(node)) ** GOTO lbl17
        return (T)((ASTNode)headerType.cast(node));
lbl-1000:
        // 1 sources

        {
            parent = node.getParent();
            if (headerType.isInstance(parent)) {
                locationInParent = node.getLocationInParent();
                var8_5 = headerProperties;
                var7_6 = headerProperties.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    property = var8_5[var6_7];
                    if (locationInParent == property) {
                        return (T)((ASTNode)headerType.cast(parent));
                    }
                    ++var6_7;
                }
                return null;
            }
            node = parent;
lbl17:
            // 2 sources

            ** while (node != null)
        }
lbl18:
        // 1 sources

        return null;
    }

    private static boolean getMakeVariableDeclarationFinalProposals(IInvocationContext context, Collection<ICommandAccess> resultingCollections) {
        return true;
    }

    private static boolean getInlineLocalProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) throws CoreException {
        return true;
    }

    private static boolean getMissingCaseStatementProposals(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) {
        return true;
    }

    private static boolean getConvertLocalToFieldProposal(IInvocationContext context, ASTNode node, Collection<ICommandAccess> proposals) throws CoreException {
        return true;
    }
}

