/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.flux.client.IChannelListener;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.core.ChannelSwitcher;
import org.json.JSONException;
import org.json.JSONObject;

public class ServiceDiscoveryConnector {
    private static final String DISCOVER_SERVICE_REQUEST = "discoverServiceRequest";
    private static final String DISCOVER_SERVICE_RESPONSE = "discoverServiceResponse";
    private static final String SERVICE_STATUS_CHANGE = "serviceStatusChange";
    private static final String START_SERVICE_REQUEST = "startServiceRequest";
    private static final String START_SERVICE_RESPONSE = "startServiceResponse";
    protected static final String[] COPY_PROPS = new String[]{"service", "requestSenderID", "username", "callback_id"};
    private ChannelSwitcher channelSwitcher;
    private MessageConnector mc;
    private String serviceTypeId;
    private List<Runnable> onDispose = new ArrayList<Runnable>();
    private IChannelListener channelListener = new IChannelListener(){

        public void connected(String userChannel) {
            ServiceDiscoveryConnector.this.sendStatus(userChannel, "ready");
        }

        public void disconnected(String userChannel) {
            if (ServiceDiscoveryConnector.this.mc != null && ServiceDiscoveryConnector.this.mc.isConnected()) {
                ServiceDiscoveryConnector.this.sendStatus(userChannel, "unavailable", "Disconnected");
            }
        }
    };

    private boolean forMe(JSONObject message) {
        try {
            return message.getString("service").equals(this.serviceTypeId);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ServiceDiscoveryConnector(ChannelSwitcher switcher, MessageConnector messagingConnector, String serviceTypeId, boolean keepAlive) {
        this.channelSwitcher = switcher;
        this.mc = messagingConnector;
        this.serviceTypeId = serviceTypeId;
        this.mc.addChannelListener(this.channelListener);
        String userChannel = switcher.getChannel();
        if (userChannel != null) {
            this.sendStatus(userChannel, "ready");
        }
        this.handler((IMessageHandler)new MessageHandler(DISCOVER_SERVICE_REQUEST){

            public void handle(String messageType, JSONObject message) {
                String user = ServiceDiscoveryConnector.this.channelSwitcher.getChannel();
                try {
                    if (ServiceDiscoveryConnector.this.forMe(message) && (message.get("username").equals(user) || "$super$".equals(user))) {
                        JSONObject response = new JSONObject(message, COPY_PROPS);
                        response.put("status", (Object)(message.get("username").equals(user) ? "ready" : "available"));
                        ServiceDiscoveryConnector.this.mc.send(ServiceDiscoveryConnector.DISCOVER_SERVICE_RESPONSE, response);
                    }
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        });
        this.mc.addMessageHandler((IMessageHandler)new MessageHandler(START_SERVICE_REQUEST){

            public void handle(String messageType, JSONObject message) {
                ServiceDiscoveryConnector.this.mc.removeMessageHandler((IMessageHandler)this);
                try {
                    String user = message.getString("username");
                    JSONObject serviceStartedMessage = new JSONObject(message, COPY_PROPS);
                    ServiceDiscoveryConnector.this.mc.send(ServiceDiscoveryConnector.START_SERVICE_RESPONSE, serviceStartedMessage);
                    ServiceDiscoveryConnector.this.sendStatus(user, "starting");
                    ServiceDiscoveryConnector.this.channelSwitcher.switchToChannel(user);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private synchronized void handler(final IMessageHandler h) {
        this.onDispose.add(new Runnable(){

            @Override
            public void run() {
                ServiceDiscoveryConnector.this.mc.removeMessageHandler(h);
            }
        });
        this.mc.addMessageHandler(h);
    }

    public synchronized void dispose() {
        try {
            if (this.mc != null) {
                this.sendStatus(this.channelSwitcher.getChannel(), "unavailable", "Shutdown");
                for (Runnable r : this.onDispose) {
                    r.run();
                }
            }
            this.mc = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendStatus(String user, String status) {
        this.sendStatus(user, status, null);
    }

    private void sendStatus(String user, String status, String error) {
        try {
            JSONObject msg = new JSONObject();
            msg.put("username", (Object)user);
            msg.put("service", (Object)this.serviceTypeId);
            msg.put("status", (Object)status);
            if (error != null) {
                msg.put("error", (Object)error);
            }
            this.mc.send(SERVICE_STATUS_CHANGE, msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

