/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import org.eclipse.core.runtime.Assert;
import org.eclipse.flux.jdt.services.SignatureUtil;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;

public class CompletionProposalDescriptionProvider {
    private static final String QUALIFIER_SEPARATOR = " - ";
    private static final String RETURN_TYPE_SEPARATOR = " : ";
    private static final String VAR_TYPE_SEPARATOR = " : ";
    private CompletionContext fContext;

    public CompletionProposalDescriptionProvider(CompletionContext context) {
        this.fContext = context;
    }

    public StringBuilder createParameterList(CompletionProposal proposal) {
        int kind = proposal.getKind();
        switch (kind) {
            case 6: 
            case 26: {
                return this.appendUnboundedParameterList(new StringBuilder(), proposal);
            }
            case 9: 
            case 16: {
                return this.appendTypeParameterList(new StringBuilder(), proposal);
            }
            case 1: 
            case 27: {
                return this.appendUnboundedParameterList(new StringBuilder(), proposal);
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    private StringBuilder appendUnboundedParameterList(StringBuilder buffer, CompletionProposal methodProposal) {
        char[] signature = SignatureUtil.fix83600(methodProposal.getSignature());
        char[][] parameterNames = methodProposal.findParameterNames(null);
        char[][] parameterTypes = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = this.createTypeDisplayName(SignatureUtil.getLowerBound(parameterTypes[i]));
            ++i;
        }
        if (Flags.isVarargs((int)methodProposal.getFlags())) {
            int index = parameterTypes.length - 1;
            parameterTypes[index] = this.convertToVararg(parameterTypes[index]);
        }
        return this.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    private StringBuilder appendTypeParameterList(StringBuilder buffer, CompletionProposal typeProposal) {
        char[] signature = SignatureUtil.fix83600(typeProposal.getSignature());
        char[][] typeParameters = Signature.getTypeArguments((char[])signature);
        int i = 0;
        while (i < typeParameters.length) {
            char[] param = typeParameters[i];
            typeParameters[i] = Signature.toCharArray((char[])param);
            ++i;
        }
        return this.appendParameterSignature(buffer, typeParameters, null);
    }

    private char[] convertToVararg(char[] typeName) {
        if (typeName == null) {
            return typeName;
        }
        int len = typeName.length;
        if (len < 2) {
            return typeName;
        }
        if (typeName[len - 1] != ']') {
            return typeName;
        }
        if (typeName[len - 2] != '[') {
            return typeName;
        }
        char[] vararg = new char[len + 1];
        System.arraycopy(typeName, 0, vararg, 0, len - 2);
        vararg[len - 2] = 46;
        vararg[len - 1] = 46;
        vararg[len] = 46;
        return vararg;
    }

    private char[] createTypeDisplayName(char[] typeSignature) throws IllegalArgumentException {
        char[] displayName = Signature.getSimpleName((char[])Signature.toCharArray((char[])typeSignature));
        boolean useShortGenerics = false;
        if (useShortGenerics) {
            int pos;
            StringBuffer buf = new StringBuffer();
            buf.append(displayName);
            do {
                if ((pos = buf.indexOf("? extends ")) >= 0) {
                    buf.replace(pos, pos + 10, "+");
                    continue;
                }
                pos = buf.indexOf("? super ");
                if (pos < 0) continue;
                buf.replace(pos, pos + 8, "-");
            } while (pos >= 0);
            return buf.toString().toCharArray();
        }
        return displayName;
    }

    private final StringBuilder appendParameterSignature(StringBuilder buffer, char[][] parameterTypes, char[][] parameterNames) {
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterTypes[i]);
                if (parameterNames != null && parameterNames[i] != null) {
                    buffer.append(' ');
                    buffer.append(parameterNames[i]);
                }
                ++i;
            }
        }
        return buffer;
    }

    StringBuilder createMethodProposalLabel(CompletionProposal methodProposal) {
        String qualifier;
        StringBuilder description = new StringBuilder();
        description.append("[");
        description.append("{\"value\":\"");
        description.append(methodProposal.getName());
        description.append('(');
        this.appendUnboundedParameterList(description, methodProposal);
        description.append(')');
        if (!methodProposal.isConstructor()) {
            char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(methodProposal.getSignature()))));
            description.append(" : ");
            description.append(returnType);
        }
        description.append("\"}");
        description.append(",");
        description.append("{\"value\":\"");
        description.append(QUALIFIER_SEPARATOR);
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        if (methodProposal.getRequiredProposals() != null && (qualifier = Signature.getQualifier((String)declaringType)).length() > 0) {
            description.append(qualifier);
            description.append('.');
        }
        declaringType = Signature.getSimpleName((String)declaringType);
        description.append(declaringType);
        description.append("\",\"style\":{");
        description.append("\"color\":\"#AAAAAA\"");
        description.append("}");
        description.append("}");
        description.append("]");
        return description;
    }

    StringBuilder createJavadocMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append("[");
        nameBuffer.append("{\"value\":\"");
        nameBuffer.append(methodProposal.getCompletion());
        nameBuffer.append("\"}");
        nameBuffer.append(",");
        nameBuffer.append("{\"value\":\"");
        nameBuffer.append(QUALIFIER_SEPARATOR);
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(declaringType);
        nameBuffer.append("\",\"style\":{");
        nameBuffer.append("\"color\":\"#AAAAAA\"");
        nameBuffer.append("}");
        nameBuffer.append("}");
        nameBuffer.append("]");
        return nameBuffer;
    }

    StringBuilder createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append("[");
        nameBuffer.append("{\"value\":\"");
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        nameBuffer.append(" : ");
        char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(methodProposal.getSignature()))));
        nameBuffer.append(returnType);
        nameBuffer.append("\"}");
        nameBuffer.append(",");
        nameBuffer.append("{\"value\":\"");
        nameBuffer.append(QUALIFIER_SEPARATOR);
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(String.format("Override method in '%s'", declaringType));
        nameBuffer.append("\",\"style\":{");
        nameBuffer.append("\"color\":\"#AAAAAA\"");
        nameBuffer.append("}");
        nameBuffer.append("}");
        nameBuffer.append("]");
        return nameBuffer;
    }

    private String extractDeclaringTypeFQN(CompletionProposal methodProposal) {
        char[] declaringTypeSignature = methodProposal.getDeclarationSignature();
        if (declaringTypeSignature == null) {
            return "java.lang.Object";
        }
        return SignatureUtil.stripSignatureToFQN(String.valueOf(declaringTypeSignature));
    }

    StringBuilder createTypeProposalLabel(CompletionProposal typeProposal) {
        char[] signature = this.fContext != null && this.fContext.isInJavadoc() ? Signature.getTypeErasure((char[])typeProposal.getSignature()) : typeProposal.getSignature();
        char[] fullName = Signature.toCharArray((char[])signature);
        return this.createTypeProposalLabel(fullName);
    }

    StringBuilder createJavadocTypeProposalLabel(CompletionProposal typeProposal) {
        char[] fullName = Signature.toCharArray((char[])typeProposal.getSignature());
        return this.createJavadocTypeProposalLabel(fullName);
    }

    StringBuilder createJavadocSimpleProposalLabel(CompletionProposal proposal) {
        return this.createSimpleLabel(proposal);
    }

    StringBuilder createTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append("[");
        nameBuffer.append("{\"value\":\"");
        nameBuffer.append(new String(fullName, qIndex, fullName.length - qIndex));
        nameBuffer.append("\"}");
        if (qIndex > 0) {
            nameBuffer.append(",");
            nameBuffer.append("{\"value\":\"");
            nameBuffer.append(QUALIFIER_SEPARATOR);
            nameBuffer.append(new String(fullName, 0, qIndex - 1));
            nameBuffer.append("\",\"style\":{");
            nameBuffer.append("\"color\":\"#AAAAAA\"");
            nameBuffer.append("}");
            nameBuffer.append("}");
        }
        nameBuffer.append("]");
        return nameBuffer;
    }

    StringBuilder createJavadocTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append("[");
        nameBuffer.append("{\"value\":\"");
        nameBuffer.append("{@link ");
        nameBuffer.append(new String(fullName, qIndex, fullName.length - qIndex));
        nameBuffer.append('}');
        nameBuffer.append("\"}");
        if (qIndex > 0) {
            nameBuffer.append(",");
            nameBuffer.append("{\"value\":\"");
            nameBuffer.append(QUALIFIER_SEPARATOR);
            nameBuffer.append(new String(fullName, 0, qIndex - 1));
            nameBuffer.append("\",\"style\":{");
            nameBuffer.append("\"color\":\"#AAAAAA\"");
            nameBuffer.append("}");
            nameBuffer.append("}");
        }
        nameBuffer.append("]");
        return nameBuffer;
    }

    private int findSimpleNameStart(char[] array) {
        int lastDot = 0;
        int i = 0;
        int len = array.length;
        while (i < len) {
            char ch = array[i];
            if (ch == '<') {
                return lastDot;
            }
            if (ch == '.') {
                lastDot = i + 1;
            }
            ++i;
        }
        return lastDot;
    }

    StringBuilder createSimpleLabelWithType(CompletionProposal proposal) {
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append("[");
        nameBuffer.append("{\"value\":\"");
        nameBuffer.append(proposal.getCompletion());
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            nameBuffer.append(" : ");
            nameBuffer.append(typeName);
        }
        nameBuffer.append("\"}");
        nameBuffer.append("]");
        return nameBuffer;
    }

    private boolean isThisPrefix(char[] string) {
        if (string == null || string.length < 5) {
            return false;
        }
        return string[0] == 't' && string[1] == 'h' && string[2] == 'i' && string[3] == 's' && string[4] == '.';
    }

    StringBuilder createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        char[] name = proposal.getCompletion();
        if (!this.isThisPrefix(name)) {
            name = proposal.getName();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append("{\"value\":\"");
        buf.append(name);
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            buf.append(" : ");
            buf.append(typeName);
        }
        buf.append("\"}");
        char[] declaration = proposal.getDeclarationSignature();
        if (declaration != null && (declaration = Signature.getSignatureSimpleName((char[])declaration)).length > 0) {
            String declaringType;
            String qualifier;
            buf.append(",");
            buf.append("{\"value\":\"");
            buf.append(QUALIFIER_SEPARATOR);
            if (proposal.getRequiredProposals() != null && (qualifier = Signature.getQualifier((String)(declaringType = this.extractDeclaringTypeFQN(proposal)))).length() > 0) {
                buf.append(qualifier);
                buf.append('.');
            }
            buf.append(declaration);
            buf.append("\",\"style\":{");
            buf.append("\"color\":\"#AAAAAA\"");
            buf.append("}");
            buf.append("}");
        }
        buf.append("]");
        return buf;
    }

    StringBuilder createPackageProposalLabel(CompletionProposal proposal) {
        Assert.isTrue((proposal.getKind() == 8 ? 1 : 0) != 0);
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append("{\"value\":\"");
        buf.append(String.valueOf(proposal.getDeclarationSignature()));
        buf.append("\"}");
        buf.append("]");
        return buf;
    }

    StringBuilder createSimpleLabel(CompletionProposal proposal) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append("{\"value\":\"");
        buf.append(String.valueOf(proposal.getCompletion()));
        buf.append("\"}");
        buf.append("]");
        return buf;
    }

    StringBuilder createAnonymousTypeLabel(CompletionProposal proposal) {
        char[] signatureQualifier;
        char[] declaringTypeSignature = proposal.getDeclarationSignature();
        declaringTypeSignature = Signature.getTypeErasure((char[])declaringTypeSignature);
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append("{\"value\":\"");
        buf.append(Signature.getSignatureSimpleName((char[])declaringTypeSignature));
        buf.append('(');
        this.appendUnboundedParameterList(buf, proposal);
        buf.append(')');
        buf.append("  ");
        buf.append("Anonymous Inner Type");
        buf.append("\"}");
        if (proposal.getRequiredProposals() != null && (signatureQualifier = Signature.getSignatureQualifier((char[])declaringTypeSignature)).length > 0) {
            buf.append(",");
            buf.append("{\"value\":\"");
            buf.append(QUALIFIER_SEPARATOR);
            buf.append(signatureQualifier);
            buf.append("\",\"style\":{");
            buf.append("\"color\":\"#AAAAAA\"");
            buf.append("}");
            buf.append("}");
        }
        buf.append("]");
        return buf;
    }

    public StringBuilder createDescription(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: 
            case 11: 
            case 12: 
            case 24: 
            case 26: {
                if (this.fContext != null && this.fContext.isInJavadoc()) {
                    return this.createJavadocMethodProposalLabel(proposal);
                }
                return this.createMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createOverrideMethodProposalLabel(proposal);
            }
            case 1: 
            case 27: {
                return this.createAnonymousTypeLabel(proposal);
            }
            case 9: {
                return this.createTypeProposalLabel(proposal);
            }
            case 16: {
                return this.createJavadocTypeProposalLabel(proposal);
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.createJavadocSimpleProposalLabel(proposal);
            }
            case 15: {
                return this.createJavadocMethodProposalLabel(proposal);
            }
            case 8: {
                return this.createPackageProposalLabel(proposal);
            }
            case 2: 
            case 13: 
            case 25: {
                return this.createLabelWithTypeAndDeclaration(proposal);
            }
            case 5: 
            case 10: {
                return this.createSimpleLabelWithType(proposal);
            }
            case 3: 
            case 4: {
                return this.createSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public StringBuilder createMetadata(CompletionProposal proposal) {
        StringBuilder buf = new StringBuilder();
        buf.append("{ 'kind' : ");
        buf.append(proposal.getKind());
        buf.append(", 'flags' : ");
        buf.append(proposal.getFlags());
        buf.append("}");
        return buf;
    }
}

