/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.flux.client.CallbackIDAwareMessageHandler;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.core.DownloadProject;
import org.eclipse.flux.core.Repository;
import org.json.JSONArray;
import org.json.JSONObject;

public class InitializeServiceEnvironment {
    private static int GET_PROJECTS_CALLBACK = "InitializeServiceEnvironment - getProjectsCallback".hashCode();
    private final MessageConnector messagingConnector;
    final Repository repository;
    private IMessageHandler getProjectsResponseHandler;
    private IMessageHandler projectConnectedHandler;

    public InitializeServiceEnvironment(MessageConnector messagingConnector, Repository repository) {
        this.messagingConnector = messagingConnector;
        this.repository = repository;
    }

    public void start() {
        this.getProjectsResponseHandler = new CallbackIDAwareMessageHandler("getProjectsResponse", GET_PROJECTS_CALLBACK){

            public void handle(String messageType, JSONObject message) {
                InitializeServiceEnvironment.this.handleGetProjectsResponse(message);
            }
        };
        this.messagingConnector.addMessageHandler(this.getProjectsResponseHandler);
        this.projectConnectedHandler = new MessageHandler("projectConnected"){

            public void handle(String messageType, JSONObject message) {
                InitializeServiceEnvironment.this.handleProjectConnected(message);
            }
        };
        this.messagingConnector.addMessageHandler(this.projectConnectedHandler);
        try {
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.repository.getUsername());
            message.put("callback_id", GET_PROJECTS_CALLBACK);
            this.messagingConnector.send("getProjectsRequest", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleGetProjectsResponse(JSONObject message) {
        try {
            String username = message.getString("username");
            if (this.repository.getUsername().equals(username)) {
                JSONArray projects = message.getJSONArray("projects");
                int i = 0;
                while (i < projects.length()) {
                    JSONObject project = projects.getJSONObject(i);
                    String projectName = project.getString("name");
                    this.initializeProject(projectName);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleProjectConnected(JSONObject message) {
        try {
            String username = message.getString("username");
            String projectName = message.getString("project");
            if (this.repository.getUsername().equals(username)) {
                this.initializeProject(projectName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeProject(String projectName) {
        try {
            if (this.repository.isConnected(projectName)) {
                return;
            }
            DownloadProject downloadProject = new DownloadProject(this.messagingConnector, projectName, this.repository.getUsername());
            downloadProject.run(new DownloadProject.CompletionCallback(){

                public void downloadFailed() {
                }

                public void downloadComplete(IProject downloadedProject) {
                    try {
                        downloadedProject.build(6, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    InitializeServiceEnvironment.this.repository.addProject(downloadedProject);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.messagingConnector.removeMessageHandler(this.getProjectsResponseHandler);
        this.messagingConnector.removeMessageHandler(this.projectConnectedHandler);
    }
}

