/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.formatter.IndentManipulation;

public class JavaDocCommentReader
extends Reader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    @Override
    public int read() {
        if (this.fCurrPos < this.fEndPos) {
            char ch = this.fBuffer.getChar(this.fCurrPos++);
            if (this.fWasNewLine && !IndentManipulation.isLineDelimiterChar((char)ch)) {
                while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch)) {
                    ch = this.fBuffer.getChar(this.fCurrPos++);
                }
                if (ch == '*') {
                    if (this.fCurrPos < this.fEndPos) {
                        while ((ch = this.fBuffer.getChar(this.fCurrPos++)) == '*') {
                        }
                    } else {
                        return -1;
                    }
                }
            }
            this.fWasNewLine = IndentManipulation.isLineDelimiterChar((char)ch);
            return ch;
        }
        return -1;
    }

    @Override
    public void close() {
        this.fBuffer = null;
    }

    @Override
    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
        if (this.fCurrPos < this.fEndPos && '\r' == this.fBuffer.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
        if (this.fCurrPos < this.fEndPos && '\n' == this.fBuffer.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
    }

    public int getOffset() {
        return this.fCurrPos;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        int i = off;
        while (i < end) {
            int ch = this.read();
            if (ch == -1) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (char)ch;
            ++i;
        }
        return len;
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    public String getString() throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = this.read()) != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

