/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.LinkedList;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    public static JSONArray editsToJsonArray(TextEdit edit) {
        final LinkedList list = new LinkedList();
        edit.accept(new TextEditVisitor(){

            public boolean visit(DeleteEdit delete) {
                try {
                    JSONObject json = new JSONObject();
                    json.put("offset", delete.getOffset());
                    json.put("length", delete.getLength());
                    json.put("text", (Object)"");
                    list.addFirst(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return super.visit(delete);
            }

            public boolean visit(InsertEdit insert) {
                try {
                    JSONObject json = new JSONObject();
                    json.put("offset", insert.getOffset());
                    json.put("length", 0);
                    json.put("text", (Object)insert.getText());
                    list.addFirst(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return super.visit(insert);
            }

            public boolean visit(ReplaceEdit replace) {
                try {
                    JSONObject json = new JSONObject();
                    json.put("offset", replace.getOffset());
                    json.put("length", replace.getLength());
                    json.put("text", (Object)replace.getText());
                    list.addFirst(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return super.visit(replace);
            }
        });
        return new JSONArray(list);
    }

    public static int getOffsetAdjustment(TextEdit edit, final int offset) {
        final int[] holder = new int[1];
        edit.accept(new TextEditVisitor(){

            public boolean visit(DeleteEdit edit) {
                if (offset >= edit.getOffset()) {
                    holder[0] = holder[0] - edit.getLength();
                }
                return super.visit(edit);
            }

            public boolean visit(InsertEdit edit) {
                if (offset >= edit.getOffset()) {
                    holder[0] = holder[0] + edit.getText().length();
                }
                return super.visit(edit);
            }

            public boolean visit(ReplaceEdit edit) {
                if (offset >= edit.getOffset()) {
                    holder[0] = holder[0] + (edit.getText().length() - edit.getLength());
                }
                return super.visit(edit);
            }
        });
        return holder[0];
    }
}

