/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.maven.cli.MavenCli;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.slf4j.Logger;

public final class CLIReportingUtils {
    public static final long MB = 0x100000L;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    public static final String BUILD_VERSION_PROPERTY = "version";

    public static String showVersion() {
        String LS = System.getProperty("line.separator");
        Properties properties = CLIReportingUtils.getBuildProperties();
        StringBuilder version = new StringBuilder();
        version.append(CLIReportingUtils.createMavenVersionString(properties)).append(LS);
        version.append(CLIReportingUtils.reduce(properties.getProperty("distributionShortName") + " home: " + System.getProperty("maven.home", "<unknown maven home>"))).append(LS);
        version.append("Java version: ").append(System.getProperty("java.version", "<unknown java version>")).append(", vendor: ").append(System.getProperty("java.vendor", "<unknown vendor>")).append(LS);
        version.append("Java home: ").append(System.getProperty("java.home", "<unknown java home>")).append(LS);
        version.append("Default locale: ").append(Locale.getDefault()).append(", platform encoding: ").append(System.getProperty("file.encoding", "<unknown encoding>")).append(LS);
        version.append("OS name: \"").append(Os.OS_NAME).append("\", version: \"").append(Os.OS_VERSION).append("\", arch: \"").append(Os.OS_ARCH).append("\", family: \"").append(Os.OS_FAMILY).append("\"");
        return version.toString();
    }

    static String createMavenVersionString(Properties buildProperties) {
        String timestamp = CLIReportingUtils.reduce(buildProperties.getProperty("timestamp"));
        String version = CLIReportingUtils.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = CLIReportingUtils.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = CLIReportingUtils.reduce(buildProperties.getProperty("distributionName"));
        String msg = distributionName + " ";
        msg = msg + (version != null ? version : "<version unknown>");
        if (rev != null || timestamp != null) {
            msg = msg + " (";
            msg = msg + (rev != null ? rev : "");
            if (timestamp != null) {
                String ts = CLIReportingUtils.formatTimestamp(Long.valueOf(timestamp));
                msg = msg + (rev != null ? "; " : "") + ts;
            }
            msg = msg + ")";
        }
        return msg;
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getBuildProperties() {
        Properties properties = new Properties();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
        finally {
            IOUtil.close((InputStream)resourceAsStream);
        }
        return properties;
    }

    public static void showError(Logger logger, String message, Throwable e, boolean showStackTrace) {
        if (showStackTrace) {
            logger.error(message, e);
        } else {
            logger.error(message);
            if (e != null) {
                logger.error(e.getMessage());
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    logger.error("Caused by: " + cause.getMessage());
                }
            }
        }
    }

    public static String formatTimestamp(long timestamp) {
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getRawOffset();
        long m = Math.abs((long)offset / 60000L % 60L);
        long h = Math.abs((long)offset / 3600000L % 24L);
        int offsetDir = (int)Math.signum(offset);
        char offsetSign = offsetDir >= 0 ? (char)'+' : '-';
        return String.format("%tFT%<tT%s%02d:%02d", timestamp, Character.valueOf(offsetSign), h, m);
    }

    public static String formatDuration(long duration) {
        long ms = duration % 1000L;
        long s = duration / 1000L % 60L;
        long m = duration / 60000L % 60L;
        long h = duration / 3600000L % 24L;
        long d = duration / 86400000L;
        String format = d > 0L ? "%d d %02d:%02d h" : (h > 0L ? "%2$02d:%3$02d h" : (m > 0L ? "%3$02d:%4$02d min" : "%4$d.%5$03d s"));
        return String.format(format, d, h, m, s, ms);
    }
}

