/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import org.eclipse.flux.client.IChannelListener;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.core.Activator;
import org.eclipse.flux.core.ChannelSwitcher;
import org.eclipse.flux.core.KeepAliveConnector;
import org.eclipse.flux.core.LiveEditCoordinator;
import org.eclipse.flux.core.Repository;
import org.eclipse.flux.core.ServiceDiscoveryConnector;
import org.eclipse.flux.jdt.services.ContentAssistService;
import org.eclipse.flux.jdt.services.InitializeServiceEnvironment;
import org.eclipse.flux.jdt.services.JavaDocService;
import org.eclipse.flux.jdt.services.LiveEditUnits;
import org.eclipse.flux.jdt.services.NavigationService;
import org.eclipse.flux.jdt.services.QuickAssistService;
import org.eclipse.flux.jdt.services.RenameService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;

public class JDTComponent {
    public static final String JDT_SERVICE_ID = "org.eclipse.flux.jdt";
    private static long WAIT_TIME_PERIOD = 100L;
    private ServiceDiscoveryConnector discoveryConnector;
    private KeepAliveConnector keepAliveConnector;

    @Activate
    public void activate(ComponentContext context) throws Exception {
        final boolean lazyStart = Activator.getDefault().isLazyStart();
        final ChannelSwitcher channelSwitcher = Activator.getDefault().getChannelSwitcher();
        final MessageConnector messagingConnector = Activator.getDefault().getMessageConnector();
        if (messagingConnector != null) {
            new Thread(){

                @Override
                public void run() {
                    String userChannel = channelSwitcher.getChannel();
                    JdtChannelListener jdtChannelListener = new JdtChannelListener();
                    while (userChannel == null) {
                        try {
                            1.sleep(WAIT_TIME_PERIOD);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        userChannel = channelSwitcher.getChannel();
                    }
                    JDTComponent.this.discoveryConnector = new ServiceDiscoveryConnector(channelSwitcher, messagingConnector, JDTComponent.JDT_SERVICE_ID, lazyStart);
                    if (lazyStart) {
                        JDTComponent.this.keepAliveConnector = new KeepAliveConnector(channelSwitcher, messagingConnector, JDTComponent.JDT_SERVICE_ID);
                    }
                    jdtChannelListener.connected(userChannel);
                    messagingConnector.addChannelListener((IChannelListener)jdtChannelListener);
                }
            }.start();
        }
    }

    @Deactivate
    public synchronized void deactivate(ComponentContext context) {
        if (this.discoveryConnector != null) {
            this.discoveryConnector.dispose();
        }
        if (this.keepAliveConnector != null) {
            this.keepAliveConnector.dispose();
        }
    }

    private class JdtChannelListener
    implements IChannelListener {
        private LiveEditUnits liveEditUnits;
        private ContentAssistService contentAssistService;
        private NavigationService navigationService;
        private RenameService renameService;
        private JavaDocService javadocService;
        private QuickAssistService quickAssistService;
        private InitializeServiceEnvironment initializer;

        private JdtChannelListener() {
        }

        public void connected(String userChannel) {
            String initJdtStr;
            boolean lazyStart = Activator.getDefault().isLazyStart();
            if (lazyStart && "$super$".equals(userChannel)) {
                return;
            }
            MessageConnector messagingConnector = Activator.getDefault().getMessageConnector();
            Repository repository = Activator.getDefault().getRepository();
            LiveEditCoordinator liveEditCoordinator = Activator.getDefault().getLiveEditCoordinator();
            this.liveEditUnits = new LiveEditUnits(messagingConnector, liveEditCoordinator, repository);
            this.contentAssistService = new ContentAssistService(messagingConnector, this.liveEditUnits);
            this.navigationService = new NavigationService(messagingConnector, this.liveEditUnits);
            this.renameService = new RenameService(messagingConnector, this.liveEditUnits);
            this.javadocService = new JavaDocService(messagingConnector, this.liveEditUnits);
            this.quickAssistService = new QuickAssistService(messagingConnector, this.liveEditUnits);
            String string = initJdtStr = System.getProperty("flux-initjdt") == null ? System.getenv("FLUX_INIT_JDT") : System.getProperty("flux-initjdt");
            if (initJdtStr != null && Boolean.valueOf(initJdtStr).booleanValue()) {
                this.initializer = new InitializeServiceEnvironment(messagingConnector, repository);
                this.initializer.start();
            }
        }

        public void disconnected(String userChannel) {
            boolean lazyStart = Activator.getDefault().isLazyStart();
            if (lazyStart && "$super$".equals(userChannel)) {
                return;
            }
            this.liveEditUnits.dispose();
            this.contentAssistService.dispose();
            this.navigationService.dispose();
            this.renameService.dispose();
            this.javadocService.dispose();
            this.quickAssistService.dispose();
            if (this.initializer != null) {
                this.initializer.dispose();
            }
        }
    }
}

