/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import org.eclipse.core.resources.IResource;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.jdt.services.LiveEditUnits;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.json.JSONException;
import org.json.JSONObject;

public class NavigationService {
    private LiveEditUnits liveEditUnits;
    private MessageConnector messagingConnector;
    private IMessageHandler navigationRequestHandler;

    public NavigationService(MessageConnector messagingConnector, LiveEditUnits liveEditUnits) {
        this.messagingConnector = messagingConnector;
        this.liveEditUnits = liveEditUnits;
        this.navigationRequestHandler = new MessageHandler("navigationrequest"){

            public void handle(String messageType, JSONObject message) {
                NavigationService.this.handleNavigationRequest(message);
            }
        };
        messagingConnector.addMessageHandler(this.navigationRequestHandler);
    }

    protected void handleNavigationRequest(JSONObject message) {
        try {
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            int callbackID = message.getInt("callback_id");
            String liveEditID = String.valueOf(projectName) + "/" + resourcePath;
            if (this.liveEditUnits.isLiveEditResource(username, liveEditID)) {
                int offset = message.getInt("offset");
                int length = message.getInt("length");
                String sender = message.getString("requestSenderID");
                JSONObject navigationResult = this.computeNavigation(username, liveEditID, offset, length);
                if (navigationResult != null) {
                    JSONObject responseMessage = new JSONObject();
                    responseMessage.put("username", (Object)username);
                    responseMessage.put("project", (Object)projectName);
                    responseMessage.put("resource", (Object)resourcePath);
                    responseMessage.put("callback_id", callbackID);
                    responseMessage.put("requestSenderID", (Object)sender);
                    responseMessage.put("navigation", (Object)navigationResult);
                    this.messagingConnector.send("navigationresponse", responseMessage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject computeNavigation(String username, String requestorResourcePath, int offset, int length) {
        try {
            ICompilationUnit liveEditUnit = this.liveEditUnits.getLiveEditUnit(username, requestorResourcePath);
            if (liveEditUnit == null) return null;
            IJavaElement[] elements = liveEditUnit.codeSelect(offset, length);
            if (elements == null) return null;
            if (elements.length <= 0) return null;
            JSONObject result = new JSONObject();
            IJavaElement element = elements[0];
            IResource resource = element.getResource();
            if (resource != null && resource.getProject() != null) {
                String projectName = resource.getProject().getName();
                String resourcePath = resource.getProjectRelativePath().toString();
                result.put("project", (Object)projectName);
                result.put("resource", (Object)resourcePath);
                if (!(element instanceof ISourceReference)) return result;
                ISourceRange nameRange = ((ISourceReference)element).getNameRange();
                result.put("offset", nameRange.getOffset());
                result.put("length", nameRange.getLength());
                return result;
            }
            while (true) {
                if (element == null || element instanceof IClassFile) {
                    if (!(element instanceof IClassFile)) return null;
                    IClassFile classFile = (IClassFile)element;
                    ISourceRange sourceRange = classFile.getSourceRange();
                    if (sourceRange == null) return null;
                    String projectName = element.getJavaProject().getProject().getName();
                    String resourcePath = classFile.getParent().getElementName().replace('.', '/');
                    resourcePath = "classpath:/" + resourcePath + "/" + classFile.getElementName();
                    result.put("project", (Object)projectName);
                    result.put("resource", (Object)resourcePath);
                    return result;
                }
                element = element.getParent();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void dispose() {
        this.messagingConnector.removeMessageHandler(this.navigationRequestHandler);
    }
}

