/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.jdt.services.LiveEditUnits;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.DocumentAdapter;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.QuickFixProcessor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.json.JSONException;
import org.json.JSONObject;

public class QuickAssistService {
    private MessageConnector MessageConnector;
    private LiveEditUnits liveEditUnits;
    private IMessageHandler quickfixRequestHandler;
    DocumentListener documentListener;

    public QuickAssistService(MessageConnector MessageConnector2, LiveEditUnits liveEditUnits) {
        this.MessageConnector = MessageConnector2;
        this.liveEditUnits = liveEditUnits;
        this.quickfixRequestHandler = new MessageHandler("quickfixrequest"){

            public void handle(String type, JSONObject message) {
                QuickAssistService.this.handleQuickAssist(message);
            }
        };
        MessageConnector2.addMessageHandler(this.quickfixRequestHandler);
        this.documentListener = new DocumentListener();
    }

    protected void handleQuickAssist(JSONObject message) {
        try {
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            boolean applyFix = false;
            try {
                applyFix = Boolean.parseBoolean(message.getString("apply-fix"));
            }
            catch (Exception exception) {}
            int callbackID = message.getInt("callback_id");
            String liveEditID = String.valueOf(projectName) + "/" + resourcePath;
            if (this.liveEditUnits.isLiveEditResource(username, liveEditID)) {
                int offset = message.getInt("offset");
                int length = message.getInt("length");
                int problemID = message.getInt("id");
                String sender = message.getString("requestSenderID");
                JSONObject assistResult = this.getAssistProposals(username, liveEditID, problemID, offset, length, applyFix);
                if (applyFix) {
                    if (this.documentListener.event != null) {
                        JSONObject responseMessage = new JSONObject();
                        responseMessage.put("username", (Object)username);
                        responseMessage.put("project", (Object)projectName);
                        responseMessage.put("resource", (Object)resourcePath);
                        responseMessage.put("offset", this.documentListener.event.getOffset());
                        responseMessage.put("removedCharCount", this.documentListener.event.getDocument().getLength());
                        responseMessage.put("addedCharacters", (Object)this.documentListener.event.getText());
                        System.out.println(responseMessage);
                        this.MessageConnector.send("liveResourceChanged", responseMessage);
                    }
                } else if (assistResult != null) {
                    JSONObject responseMessage = new JSONObject();
                    responseMessage.put("username", (Object)username);
                    responseMessage.put("project", (Object)projectName);
                    responseMessage.put("resource", (Object)resourcePath);
                    responseMessage.put("callback_id", callbackID);
                    responseMessage.put("requestSenderID", (Object)sender);
                    responseMessage.put("quickfix", (Object)assistResult);
                    this.MessageConnector.send("quickfixresponse", responseMessage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static IProblemLocation filterOutProblems(IProblem[] problems, int id) {
        int i = 0;
        while (i < problems.length) {
            System.out.println(problems[i].getID());
            if (problems[i].getID() == id) {
                return new ProblemLocation(problems[i]);
            }
            ++i;
        }
        return null;
    }

    protected static IProblemLocation[] convertProblems(IProblem[] problems) {
        IProblemLocation[] result = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            result[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return result;
    }

    public JSONObject getAssistProposals(String username, String requestorResourcePath, int problemID, int offset, int length, boolean applyFix) {
        try {
            ICompilationUnit liveEditUnit = this.liveEditUnits.getLiveEditUnit(username, requestorResourcePath);
            if (liveEditUnit != null) {
                IProblemLocation location = this.getProblemLocations(liveEditUnit, problemID, offset, length);
                return this.applyProposals(offset, length, applyFix, liveEditUnit, location);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IProblemLocation getProblemLocations(ICompilationUnit liveEditUnit, int problemID, int offset, int length) {
        IProblemLocation[] locations;
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setKind(8);
        parser.setSource(liveEditUnit);
        parser.setResolveBindings(true);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        IProblem[] problems = unit.getProblems();
        if (problemID > 0) {
            return QuickAssistService.filterOutProblems(problems, problemID);
        }
        IProblemLocation[] iProblemLocationArray = locations = QuickAssistService.convertProblems(unit.getProblems());
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation iProblemLocation = iProblemLocationArray[n2];
            if (offset >= iProblemLocation.getOffset() && offset <= iProblemLocation.getOffset() + iProblemLocation.getLength()) {
                return iProblemLocation;
            }
            ++n2;
        }
        return null;
    }

    private JSONObject applyProposals(int offset, int length, boolean applyFix, ICompilationUnit liveEditUnit, IProblemLocation problem) throws CoreException, JavaModelException, JSONException {
        QuickFixProcessor processor = new QuickFixProcessor();
        AssistContext context = new AssistContext(liveEditUnit, offset, length);
        IJavaCompletionProposal[] proposals = processor.getCorrections(context, new IProblemLocation[]{problem});
        if (proposals == null || proposals.length == 0) {
            return null;
        }
        if (applyFix) {
            IBuffer buffer = liveEditUnit.getBuffer();
            if (buffer != null) {
                IDocument document;
                Object object = document = buffer instanceof IDocument ? (IDocument)buffer : new DocumentAdapter(buffer);
                if (proposals[0] instanceof CUCorrectionProposal) {
                    CUCorrectionProposal proposal = (CUCorrectionProposal)proposals[0];
                    String preview = proposal.getPreviewContent();
                    System.out.println(document.getLength());
                    System.out.println(preview.length());
                    try {
                        document.addDocumentListener((IDocumentListener)this.documentListener);
                        document.replace(0, preview.length(), preview);
                        liveEditUnit.getBuffer().setContents(proposal.getPreviewContent());
                        liveEditUnit.reconcile(0, true, null, null);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }
        ArrayList<JSONObject> jsonProposals = new ArrayList<JSONObject>(proposals.length);
        IJavaCompletionProposal[] iJavaCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaCompletionProposal proposal = iJavaCompletionProposalArray[n2];
            JSONObject jsonDescription = this.getDescription(proposal);
            JSONObject jsonProposal = new JSONObject();
            jsonProposal.put("description", (Object)jsonDescription);
            jsonProposal.put("relevance", proposal.getRelevance());
            jsonProposals.add(jsonProposal);
            ++n2;
        }
        JSONObject result = new JSONObject();
        result.put("quickfix", jsonProposals);
        return result;
    }

    protected JSONObject getDescription(IJavaCompletionProposal proposal) throws JSONException {
        JSONObject description = new JSONObject();
        description.put("display", (Object)proposal.getDisplayString());
        return description;
    }

    public void dispose() {
        this.MessageConnector.removeMessageHandler(this.quickfixRequestHandler);
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentEvent event = null;

        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.event = event;
        }

        public DocumentEvent getDocumentEvent() {
            return this.event;
        }
    }
}

