/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.ArrayList;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.jdt.services.LiveEditUnits;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RenameService {
    private LiveEditUnits liveEditUnits;
    private MessageConnector messagingConnector;
    private IMessageHandler contentAssistRequestHandler;

    public RenameService(MessageConnector messagingConnector, LiveEditUnits liveEditUnits) {
        this.messagingConnector = messagingConnector;
        this.liveEditUnits = liveEditUnits;
        this.contentAssistRequestHandler = new MessageHandler("renameinfilerequest"){

            public void handle(String messageType, JSONObject message) {
                RenameService.this.handleRenameInFileRequest(message);
            }
        };
        messagingConnector.addMessageHandler(this.contentAssistRequestHandler);
    }

    protected void handleRenameInFileRequest(JSONObject message) {
        try {
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            int callbackID = message.getInt("callback_id");
            String liveEditID = String.valueOf(projectName) + "/" + resourcePath;
            if (this.liveEditUnits.isLiveEditResource(username, liveEditID)) {
                int offset = message.getInt("offset");
                int length = message.getInt("length");
                String sender = message.getString("requestSenderID");
                JSONArray references = this.computeReferences(username, liveEditID, offset, length);
                if (references != null) {
                    JSONObject responseMessage = new JSONObject();
                    responseMessage.put("username", (Object)username);
                    responseMessage.put("project", (Object)projectName);
                    responseMessage.put("resource", (Object)resourcePath);
                    responseMessage.put("callback_id", callbackID);
                    responseMessage.put("requestSenderID", (Object)sender);
                    responseMessage.put("references", (Object)references);
                    this.messagingConnector.send("renameinfileresponse", responseMessage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONArray computeReferences(String username, String resourcePath, int offset, int length) {
        try {
            ICompilationUnit unit = this.liveEditUnits.getLiveEditUnit(username, resourcePath);
            if (unit != null) {
                ASTParser parser = ASTParser.newParser((int)4);
                parser.setKind(8);
                parser.setSource(unit);
                parser.setResolveBindings(true);
                ASTNode compilationUnit = parser.createAST(null);
                final ASTNode nameNode = NodeFinder.perform((ASTNode)compilationUnit, (int)offset, (int)length);
                final ArrayList nodes = new ArrayList();
                if (nameNode instanceof SimpleName) {
                    compilationUnit.accept(new ASTVisitor(){

                        public boolean visit(SimpleName node) {
                            if (node.getIdentifier().equals(((SimpleName)nameNode).getIdentifier())) {
                                nodes.add(node);
                            }
                            return super.visit(node);
                        }
                    });
                }
                JSONArray references = new JSONArray();
                for (ASTNode astNode : nodes) {
                    JSONObject nodeObject = new JSONObject();
                    nodeObject.put("offset", astNode.getStartPosition());
                    nodeObject.put("length", astNode.getLength());
                    references.put((Object)nodeObject);
                }
                return references;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void dispose() {
        this.messagingConnector.removeMessageHandler(this.contentAssistRequestHandler);
    }
}

