/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.core;

import java.util.HashSet;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.flux.client.FluxClient;
import org.eclipse.flux.client.IChannelListener;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.config.FluxConfig;
import org.eclipse.flux.client.config.SocketIOFluxConfig;
import org.eclipse.flux.core.ChannelSwitcher;
import org.eclipse.flux.core.IRepositoryListener;
import org.eclipse.flux.core.LiveEditCoordinator;
import org.eclipse.flux.core.Repository;
import org.eclipse.flux.core.internal.CloudSyncMetadataListener;
import org.eclipse.flux.core.internal.CloudSyncResourceListener;
import org.eclipse.flux.core.util.ExceptionUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.flux.core";
    private static final String CONNECTED_PROJECTS_ID = "connected.projects";
    private static Activator plugin;
    private MessageConnector messageConnector;
    private ChannelSwitcher channelSwitcher;
    private Repository repository;
    private LiveEditCoordinator liveEditCoordinator;
    private boolean lazyStart = false;
    private CloudSyncResourceListener resourceListener;
    private CloudSyncMetadataListener metadataListener;
    private IRepositoryListener repositoryListener;
    private IResourceChangeListener workspaceListener;
    private final IChannelListener SERVICE_STARTER = new IChannelListener(){

        public void connected(String userChannel) {
            if (!Activator.this.lazyStart || !"$super$".equals(userChannel)) {
                try {
                    plugin.initCoreService(userChannel);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        public void disconnected(String userChannel) {
            if (!Activator.this.lazyStart || !"$super$".equals(userChannel)) {
                Activator.this.disposeCoreServices(userChannel);
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        String channel;
        plugin = this;
        String host = Activator.getHostUrl();
        String login = Activator.getUserId();
        String token = Activator.getUserToken();
        String lazyStartStr = System.getProperty("flux.lazyStart") == null ? System.getenv("FLUX_LAZY_START") : System.getProperty("flux.lazyStart");
        this.lazyStart = lazyStartStr != null && Boolean.valueOf(lazyStartStr) != false;
        String string = channel = System.getProperty("flux.channel.id") == null ? System.getenv("FLUX_CHANNEL_ID") : System.getProperty("flux.channel.id");
        if (channel == null) {
            channel = login;
        }
        if (!host.isEmpty()) {
            this.messageConnector = new FluxClient(Executors.newFixedThreadPool(1)).connect((FluxConfig)new SocketIOFluxConfig(host, login, token));
            this.channelSwitcher = new ChannelSwitcher(this.messageConnector);
            this.messageConnector.addChannelListener(this.SERVICE_STARTER);
            final String userChannel = this.lazyStart ? "$super$" : channel;
            FluxClient.DEFAULT_INSTANCE.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Activator.this.channelSwitcher.switchToChannel(userChannel);
                    }
                    catch (Exception e) {
                        Activator.log(e);
                    }
                }
            });
        }
    }

    public static String getHostUrl() {
        String host;
        String string = host = System.getProperty("flux-host") == null ? System.getenv("FLUX_HOST") : System.getProperty("flux-host");
        if (host == null) {
            host = InstanceScope.INSTANCE.getNode(PLUGIN_ID).get("FLUX_URL", "");
        }
        return host;
    }

    public static String getUserId() {
        String login;
        String string = login = System.getProperty("flux.user.name") == null ? System.getenv("FLUX_USER_ID") : System.getProperty("flux.user.name");
        if (login == null) {
            login = InstanceScope.INSTANCE.getNode(PLUGIN_ID).get("FLUX_USER_ID", "");
        }
        return login;
    }

    public static String getUserToken() {
        String token;
        String string = token = System.getProperty("flux.user.token") == null ? System.getenv("FLUX_USER_TOKEN") : System.getProperty("flux.user.token");
        if (token == null) {
            token = InstanceScope.INSTANCE.getNode(PLUGIN_ID).get("FLUX_USER_TOKEN", "");
        }
        return token;
    }

    public static boolean isConnectionSettingsViaPreferences() {
        return System.getProperty("flux-host") == null && System.getenv("FLUX_HOST") == null && System.getProperty("flux.user.name") == null && System.getenv("FLUX_USER_ID") == null && System.getProperty("flux.user.token") == null && System.getenv("FLUX_USER_TOKEN") == null;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.messageConnector != null) {
            this.messageConnector.disconnect();
        }
        plugin = null;
    }

    private void initCoreService(String userChannel) throws CoreException {
        this.repository = new Repository(this.messageConnector, userChannel);
        this.liveEditCoordinator = new LiveEditCoordinator(this.messageConnector);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.resourceListener = new CloudSyncResourceListener(this.repository);
        workspace.addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
        this.metadataListener = new CloudSyncMetadataListener(this.repository);
        workspace.addResourceChangeListener((IResourceChangeListener)this.metadataListener, 16);
        this.repositoryListener = new IRepositoryListener(){

            @Override
            public void projectDisconnected(IProject project) {
                Activator.this.removeConnectedProjectPreference(project.getName());
            }

            @Override
            public void projectConnected(IProject project) {
                Activator.this.addConnectedProjectPreference(project.getName());
            }

            @Override
            public void resourceChanged(IResource resource) {
            }
        };
        this.getRepository().addRepositoryListener(this.repositoryListener);
        this.workspaceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getResource() instanceof IProject) {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) {
                        return;
                    }
                    if (delta.getKind() == 2) {
                        IProject project = (IProject)event.getResource();
                        Activator.this.removeConnectedProjectPreference(project.getName());
                    } else {
                        delta.getKind();
                    }
                }
            }
        };
        workspace.addResourceChangeListener(this.workspaceListener);
        this.updateProjectConnections();
    }

    private void disposeCoreServices(String userChannel) {
        if (userChannel.equals(this.repository.getUsername())) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener(this.workspaceListener);
            workspace.removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            workspace.removeResourceChangeListener((IResourceChangeListener)this.metadataListener);
            this.repository.removeRepositoryListener(this.repositoryListener);
            this.liveEditCoordinator.dispose();
            this.repository.dispose();
        }
    }

    private void updateProjectConnections() throws CoreException {
        String[] projects;
        String[] stringArray = projects = this.getConnectedProjectPreferences();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName);
            if (project.exists()) {
                if (!project.isOpen()) {
                    project.open(null);
                }
                Repository repository = Activator.getDefault().getRepository();
                repository.addProject(project);
            }
            ++n2;
        }
    }

    private String[] getConnectedProjectPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        String[] projects = StringUtils.split((String)preferences.get(CONNECTED_PROJECTS_ID, ""), (String)";");
        return projects;
    }

    private void addConnectedProjectPreference(String projectName) {
        String[] projects;
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        String currentPreferences = preferences.get(CONNECTED_PROJECTS_ID, "");
        String[] stringArray = projects = StringUtils.split((String)currentPreferences, (String)";");
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String existingProjectName = stringArray[n2];
            if (existingProjectName.equals(projectName)) {
                return;
            }
            ++n2;
        }
        currentPreferences = String.valueOf(currentPreferences) + ";" + projectName;
        preferences.put(CONNECTED_PROJECTS_ID, currentPreferences);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void removeConnectedProjectPreference(String projectName) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        String currentPreferences = preferences.get(CONNECTED_PROJECTS_ID, "");
        String[] projects = StringUtils.split((String)currentPreferences, (String)";");
        HashSet<String> retainedProjects = new HashSet<String>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String existingProjectName = stringArray[n2];
            if (!existingProjectName.equals(projectName)) {
                retainedProjects.add(existingProjectName);
            }
            ++n2;
        }
        String newPreferences = StringUtils.join(retainedProjects, (String)";");
        preferences.put(CONNECTED_PROJECTS_ID, newPreferences);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ChannelSwitcher getChannelSwitcher() {
        return this.channelSwitcher;
    }

    public MessageConnector getMessageConnector() {
        return this.messageConnector;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public LiveEditCoordinator getLiveEditCoordinator() {
        return this.liveEditCoordinator;
    }

    public static void log(Throwable ex) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, ExceptionUtil.getMessage(ex), ex));
    }

    public boolean isLazyStart() {
        return this.lazyStart;
    }
}

