/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.core;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.flux.client.IChannelListener;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.core.ChannelSwitcher;
import org.json.JSONObject;

public final class KeepAliveConnector {
    private static final String SERVICE_REQUIRED_REQUEST = "serviceRequiredRequest";
    private static final String SERVICE_REQUIRED_RESPONSE = "serviceRequiredResponse";
    private static final long KEEP_ALIVE_DELAY = 10800L;
    private static final long KEEP_ALIVE_RESPONSE_WAIT_TIME = 5L;
    private ChannelSwitcher channelSwitcher;
    private MessageConnector messageConnector;
    private String serviceTypeId;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> scheduledKeepAliveMessage = null;
    private ScheduledFuture<?> scheduledShutDown = null;
    private long keepAliveDelay;
    private long keepAliveResponseTimeout;
    private List<MessageHandler> messageHandlers = Collections.emptyList();
    private IMessageHandler keepAliveResponseHandler = new MessageHandler("serviceRequiredResponse"){

        public void handle(String messageType, JSONObject message) {
            KeepAliveConnector.this.unsetScheduledShutdown();
            KeepAliveConnector.this.setKeepAliveDelayedMessage();
        }
    };
    private IChannelListener channelListener = new IChannelListener(){

        public void connected(String userChannel) {
            KeepAliveConnector.this.unsetScheduledShutdown();
            KeepAliveConnector.this.unsetKeepAliveDelayedMessage();
            KeepAliveConnector.this.setKeepAliveDelayedMessage();
        }

        public void disconnected(String userChannel) {
            KeepAliveConnector.this.unsetScheduledShutdown();
            KeepAliveConnector.this.unsetKeepAliveDelayedMessage();
            KeepAliveConnector.this.setKeepAliveDelayedMessage();
        }
    };

    public KeepAliveConnector(ChannelSwitcher switcher, MessageConnector mc, String serviceTypeId) {
        this(switcher, mc, serviceTypeId, 10800L, 5L);
    }

    public KeepAliveConnector(ChannelSwitcher switcher, MessageConnector mc, String serviceTypeId, long keepAliveDelay, long keepAliveResponseTimeout) {
        this.channelSwitcher = switcher;
        this.messageConnector = mc;
        this.serviceTypeId = serviceTypeId;
        this.executor = Executors.newScheduledThreadPool(2);
        this.keepAliveDelay = keepAliveDelay;
        this.keepAliveResponseTimeout = keepAliveResponseTimeout;
        this.messageConnector.addMessageHandler(this.keepAliveResponseHandler);
        this.setKeepAliveDelayedMessage();
        mc.addChannelListener(this.channelListener);
    }

    private synchronized void unsetKeepAliveDelayedMessage() {
        if (this.scheduledKeepAliveMessage != null && !this.scheduledKeepAliveMessage.isCancelled()) {
            this.scheduledKeepAliveMessage.cancel(false);
        }
    }

    private synchronized void unsetScheduledShutdown() {
        if (this.scheduledShutDown != null && !this.scheduledShutDown.isCancelled()) {
            this.scheduledShutDown.cancel(false);
        }
    }

    private synchronized void setKeepAliveDelayedMessage() {
        this.scheduledKeepAliveMessage = this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                KeepAliveConnector.this.setScheduledShutdown();
            }
        }, this.keepAliveDelay, TimeUnit.SECONDS);
    }

    private synchronized void setScheduledShutdown() {
        try {
            this.scheduledShutDown = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    System.exit(0);
                }
            }, this.keepAliveResponseTimeout, TimeUnit.SECONDS);
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.channelSwitcher.getChannel());
            message.put("service", (Object)this.serviceTypeId);
            this.messageConnector.send(SERVICE_REQUIRED_REQUEST, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.messageConnector.removeChannelListener(this.channelListener);
        this.unsetScheduledShutdown();
        this.unsetKeepAliveDelayedMessage();
        this.executor.shutdown();
        this.messageConnector.removeMessageHandler(this.keepAliveResponseHandler);
        for (IMessageHandler iMessageHandler : this.messageHandlers) {
            this.messageConnector.removeMessageHandler(iMessageHandler);
        }
    }
}

