/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.flux.jdt.services.ProposalReplcamentInfo;
import org.eclipse.flux.jdt.services.SignatureUtil;
import org.eclipse.flux.jdt.services.TypeProposalUtils;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;

public class CompletionProposalReplacementProvider {
    private static final char SPACE = ' ';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COMMA = ',';
    private ICompilationUnit compilationUnit;
    private int offset;
    private String prefix;
    private CompletionProposal proposal;
    private CompletionContext context;
    private ImportRewrite importRewrite;

    public CompletionProposalReplacementProvider(ICompilationUnit compilationUnit, CompletionProposal proposal, CompletionContext context, int offset, String prefix) {
        this.compilationUnit = compilationUnit;
        this.offset = offset;
        this.prefix = prefix;
        this.proposal = proposal;
        this.context = context;
        this.importRewrite = TypeProposalUtils.createImportRewrite(compilationUnit);
    }

    public ProposalReplcamentInfo createReplacement() {
        ProposalReplcamentInfo replacementInfo = new ProposalReplcamentInfo();
        replacementInfo.replacement = this.createReplacement(this.proposal, '\u0000', replacementInfo.positions).toString();
        try {
            replacementInfo.extraChanges = this.importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return replacementInfo;
    }

    public StringBuilder createReplacement(CompletionProposal proposal, char trigger, List<Integer> positions) {
        StringBuilder completionBuffer = new StringBuilder();
        if (this.isSupportingRequiredProposals(proposal)) {
            CompletionProposal[] requiredProposals = proposal.getRequiredProposals();
            int i = 0;
            while (requiredProposals != null && i < requiredProposals.length) {
                if (requiredProposals[i].getKind() == 9) {
                    this.appendRequiredType(completionBuffer, requiredProposals[i], trigger, positions);
                } else if (requiredProposals[i].getKind() == 23) {
                    this.appendImportProposal(completionBuffer, requiredProposals[i], proposal.getKind());
                } else if (requiredProposals[i].getKind() == 22) {
                    this.appendImportProposal(completionBuffer, requiredProposals[i], proposal.getKind());
                } else if (requiredProposals[i].getKind() == 21) {
                    this.appendImportProposal(completionBuffer, requiredProposals[i], proposal.getKind());
                } else {
                    Assert.isTrue((boolean)false);
                }
                ++i;
            }
        }
        this.appendReplacementString(completionBuffer, proposal, positions);
        return completionBuffer;
    }

    private boolean isSupportingRequiredProposals(CompletionProposal proposal) {
        return proposal != null && (proposal.getKind() == 6 || proposal.getKind() == 2 || proposal.getKind() == 9 || proposal.getKind() == 26 || proposal.getKind() == 27);
    }

    protected boolean hasArgumentList(CompletionProposal proposal) {
        if (12 == proposal.getKind()) {
            return false;
        }
        char[] completion = proposal.getCompletion();
        return !this.isInJavadoc() && completion.length > 0 && completion[completion.length - 1] == ')';
    }

    private boolean isInJavadoc() {
        return this.context.isInJavadoc();
    }

    private void appendReplacementString(StringBuilder buffer, CompletionProposal proposal, List<Integer> positions) {
        if (!this.hasArgumentList(proposal)) {
            buffer.append(proposal.getKind() == 9 ? this.computeJavaTypeReplacementString(proposal) : String.valueOf(proposal.getCompletion()));
            return;
        }
        this.appendMethodNameReplacement(buffer, proposal);
        if (this.hasParameters(proposal)) {
            this.appendGuessingCompletion(buffer, proposal, positions);
        }
        buffer.append(')');
        if (this.canAutomaticallyAppendSemicolon(proposal)) {
            buffer.append(';');
        }
    }

    private boolean hasParameters(CompletionProposal proposal) throws IllegalArgumentException {
        return Signature.getParameterCount((char[])proposal.getSignature()) > 0;
    }

    private void appendMethodNameReplacement(StringBuilder buffer, CompletionProposal proposal) {
        if (proposal.getKind() == 24) {
            String coreCompletion = String.valueOf(proposal.getCompletion());
            buffer.append(coreCompletion);
        }
        if (proposal.getKind() != 26) {
            buffer.append(proposal.getName());
        }
        buffer.append('(');
    }

    private void appendGuessingCompletion(StringBuilder buffer, CompletionProposal proposal, List<Integer> positions) {
        char[][] parameterNames = proposal.findParameterNames(null);
        int count = parameterNames.length;
        int i = 0;
        while (i < count) {
            if (i != 0) {
                buffer.append(',');
                buffer.append(' ');
            }
            char[] argument = parameterNames[i];
            positions.add(buffer.length());
            positions.add(argument.length);
            buffer.append(argument);
            ++i;
        }
    }

    private final boolean canAutomaticallyAppendSemicolon(CompletionProposal proposal) {
        return !proposal.isConstructor() && CharOperation.equals((char[])new char[]{'V'}, (char[])Signature.getReturnType((char[])proposal.getSignature()));
    }

    private StringBuilder appendRequiredType(StringBuilder buffer, CompletionProposal typeProposal, char trigger, List<Integer> positions) {
        boolean onlyAppendArguments;
        this.appendReplacementString(buffer, typeProposal, positions);
        if (this.compilationUnit == null) {
            return buffer;
        }
        IJavaProject project = this.compilationUnit.getJavaProject();
        if (!this.shouldProposeGenerics(project)) {
            return buffer;
        }
        char[] completion = typeProposal.getCompletion();
        if (completion.length > 0 && (completion[completion.length - 1] == ';' || completion[completion.length - 1] == '.')) {
            return buffer;
        }
        try {
            onlyAppendArguments = this.proposal.getCompletion().length == 0 && this.offset > 0 && this.compilationUnit.getBuffer().getChar(this.offset - 1) == '<';
        }
        catch (JavaModelException javaModelException) {
            onlyAppendArguments = false;
        }
        if (onlyAppendArguments || this.shouldAppendArguments(typeProposal, trigger)) {
            this.appendParameterList(buffer, this.computeTypeArgumentProposals(typeProposal), positions, onlyAppendArguments);
        }
        return buffer;
    }

    private final boolean shouldProposeGenerics(IJavaProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return !CompletionProposalReplacementProvider.isVersionLessThan(sourceVersion, "1.5");
    }

    public static boolean isVersionLessThan(String version1, String version2) {
        if ("cldc1.1".equals(version1)) {
            version1 = "1.1a";
        }
        if ("cldc1.1".equals(version2)) {
            version2 = "1.1a";
        }
        return version1.compareTo(version2) < 0;
    }

    private IJavaElement resolveJavaElement(IJavaProject project, CompletionProposal proposal) throws JavaModelException {
        char[] signature = proposal.getSignature();
        String typeName = SignatureUtil.stripSignatureToFQN(String.valueOf(signature));
        return project.findType(typeName);
    }

    private String[] computeTypeArgumentProposals(CompletionProposal proposal) {
        try {
            IType type = (IType)this.resolveJavaElement(this.compilationUnit.getJavaProject(), proposal);
            if (type == null) {
                return new String[0];
            }
            ITypeParameter[] parameters = type.getTypeParameters();
            if (parameters.length == 0) {
                return new String[0];
            }
            String[] arguments = new String[parameters.length];
            ITypeBinding expectedTypeBinding = this.getExpectedTypeForGenericParameters();
            if (expectedTypeBinding != null && expectedTypeBinding.isParameterizedType()) {
                IType expectedType = (IType)expectedTypeBinding.getJavaElement();
                IType[] path = TypeProposalUtils.computeInheritancePath(type, expectedType);
                if (path == null) {
                    return new String[0];
                }
                int[] indices = new int[parameters.length];
                int paramIdx = 0;
                while (paramIdx < parameters.length) {
                    indices[paramIdx] = TypeProposalUtils.mapTypeParameterIndex(path, path.length - 1, paramIdx);
                    ++paramIdx;
                }
                ITypeBinding[] typeArguments = expectedTypeBinding.getTypeArguments();
                int paramIdx2 = 0;
                while (paramIdx2 < parameters.length) {
                    if (indices[paramIdx2] != -1) {
                        ITypeBinding binding = typeArguments[indices[paramIdx2]];
                        arguments[paramIdx2] = this.computeTypeProposal(binding, parameters[paramIdx2]);
                    }
                    ++paramIdx2;
                }
            }
            int i = 0;
            while (i < arguments.length) {
                if (arguments[i] == null) {
                    arguments[i] = this.computeTypeProposal(parameters[i]);
                }
                ++i;
            }
            return arguments;
        }
        catch (JavaModelException javaModelException) {
            return new String[0];
        }
    }

    private String computeTypeProposal(ITypeParameter parameter) throws JavaModelException {
        String[] bounds = parameter.getBounds();
        String elementName = parameter.getElementName();
        if (bounds.length == 1 && !"java.lang.Object".equals(bounds[0])) {
            return Signature.getSimpleName((String)bounds[0]);
        }
        return elementName;
    }

    private String computeTypeProposal(ITypeBinding binding, ITypeParameter parameter) throws JavaModelException {
        String name = TypeProposalUtils.getTypeQualifiedName(binding);
        if (binding.isWildcardType()) {
            if (binding.isUpperbound()) {
                return binding.getBound().getName();
            }
            return this.computeTypeProposal(parameter);
        }
        return name;
    }

    private StringBuilder appendParameterList(StringBuilder buffer, String[] typeArguments, List<Integer> positions, boolean onlyAppendArguments) {
        if (typeArguments != null && typeArguments.length > 0) {
            if (!onlyAppendArguments) {
                buffer.append('<');
            }
            StringBuffer separator = new StringBuffer(3);
            separator.append(',');
            int i = 0;
            while (i != typeArguments.length) {
                if (i != 0) {
                    buffer.append(separator);
                }
                positions.add(buffer.length());
                positions.add(typeArguments[i].length());
                buffer.append(typeArguments[i]);
                ++i;
            }
            if (!onlyAppendArguments) {
                buffer.append('>');
            }
        }
        return buffer;
    }

    private boolean shouldAppendArguments(CompletionProposal proposal, char trigger) {
        if (trigger != '\u0000' && trigger != '<' && trigger != '(') {
            return false;
        }
        char[] completion = proposal.getCompletion();
        if (completion.length == 0) {
            return false;
        }
        int index = this.prefix.length() - 1;
        while (index >= 0 && Character.isUnicodeIdentifierPart(this.prefix.charAt(index)) && this.prefix.charAt(index) != '\n') {
            --index;
        }
        if (index < 0) {
            return true;
        }
        char ch = this.prefix.charAt(index);
        return ch != '<' && ch != '\n';
    }

    private StringBuilder appendImportProposal(StringBuilder buffer, CompletionProposal proposal, int coreKind) {
        int proposalKind = proposal.getKind();
        String qualifiedTypeName = null;
        char[] qualifiedType = null;
        if (proposalKind == 23) {
            qualifiedType = proposal.getSignature();
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else if (proposalKind == 22 || proposalKind == 21) {
            qualifiedType = Signature.getTypeErasure((char[])proposal.getDeclarationSignature());
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else {
            Assert.isTrue((boolean)false);
        }
        if (this.importRewrite != null) {
            if (proposalKind == 23) {
                String simpleType = this.importRewrite.addImport(qualifiedTypeName, null);
                if (coreKind == 6) {
                    buffer.append(simpleType);
                    buffer.append(',');
                    return buffer;
                }
            } else {
                String res = this.importRewrite.addStaticImport(qualifiedTypeName, String.valueOf(proposal.getName()), proposalKind == 21, null);
                int dot = res.lastIndexOf(46);
                if (dot != -1) {
                    buffer.append(this.importRewrite.addImport(res.substring(0, dot), null));
                    buffer.append('.');
                    return buffer;
                }
            }
            return buffer;
        }
        if (this.compilationUnit != null && CompletionProposalReplacementProvider.isImplicitImport(Signature.getQualifier((String)qualifiedTypeName), this.compilationUnit)) {
            if (proposal.getKind() == 23 && coreKind == 2) {
                return buffer;
            }
            qualifiedTypeName = String.valueOf(Signature.getSignatureSimpleName((char[])qualifiedType));
        }
        buffer.append(qualifiedTypeName);
        buffer.append('.');
        return buffer;
    }

    private static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if ("java.lang".equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        String mainTypeName = CompletionProposalReplacementProvider.concatenateName(packageName, typeName);
        return qualifier.equals(mainTypeName);
    }

    private static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    private ITypeBinding getExpectedTypeForGenericParameters() {
        char[][] chKeys = this.context.getExpectedTypesKeys();
        if (chKeys == null || chKeys.length == 0) {
            return null;
        }
        String[] keys = new String[chKeys.length];
        int i = 0;
        while (i < keys.length) {
            keys[i] = String.valueOf(chKeys[0]);
            ++i;
        }
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setProject(this.compilationUnit.getJavaProject());
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        final HashMap bindings = new HashMap();
        ASTRequestor requestor = new ASTRequestor(){

            public void acceptBinding(String bindingKey, IBinding binding) {
                bindings.put(bindingKey, binding);
            }
        };
        parser.createASTs(new ICompilationUnit[0], keys, requestor, null);
        if (bindings.size() > 0) {
            return (ITypeBinding)bindings.get(keys[0]);
        }
        return null;
    }

    private String computeJavaTypeReplacementString(CompletionProposal proposal) {
        String replacement = String.valueOf(proposal.getCompletion());
        if (this.isImportCompletion(proposal)) {
            return replacement;
        }
        if (proposal.getKind() == 9 && this.context.isInJavadocText()) {
            return SignatureUtil.getSimpleTypeName(proposal);
        }
        String qualifiedTypeName = SignatureUtil.getQualifiedTypeName(proposal);
        if (this.compilationUnit != null && TypeProposalUtils.isPackageInfo(this.compilationUnit)) {
            return qualifiedTypeName;
        }
        if (qualifiedTypeName.indexOf(46) == -1 && replacement.length() > 0) {
            return qualifiedTypeName;
        }
        int dotIndex = this.prefix.lastIndexOf(46);
        if (dotIndex != -1 && qualifiedTypeName.toLowerCase().startsWith(this.prefix.substring(0, dotIndex + 1).toLowerCase())) {
            return qualifiedTypeName;
        }
        if (replacement.indexOf(46) == -1) {
            if (this.isInJavadoc()) {
                return SignatureUtil.getSimpleTypeName(proposal);
            }
            return replacement;
        }
        if (this.importRewrite != null) {
            return this.importRewrite.addImport(qualifiedTypeName, null);
        }
        if (this.compilationUnit != null && TypeProposalUtils.isImplicitImport(Signature.getQualifier((String)qualifiedTypeName), this.compilationUnit)) {
            return Signature.getSimpleName((String)qualifiedTypeName);
        }
        return qualifiedTypeName;
    }

    private boolean isImportCompletion(CompletionProposal proposal) {
        char[] completion = proposal.getCompletion();
        if (completion.length == 0) {
            return false;
        }
        char last = completion[completion.length - 1];
        return last == ';' || last == '.';
    }
}

