/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.jdt.services.CompletionProposalDescriptionProvider;
import org.eclipse.flux.jdt.services.CompletionProposalReplacementProvider;
import org.eclipse.flux.jdt.services.LiveEditUnits;
import org.eclipse.flux.jdt.services.ProposalReplcamentInfo;
import org.eclipse.flux.jdt.services.Utils;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentAssistService {
    private LiveEditUnits liveEditUnits;
    private MessageConnector messagingConnector;
    private IMessageHandler contentAssistRequestHandler;

    public ContentAssistService(MessageConnector messagingConnector, LiveEditUnits liveEditUnits) {
        this.messagingConnector = messagingConnector;
        this.liveEditUnits = liveEditUnits;
        this.contentAssistRequestHandler = new MessageHandler("contentassistrequest"){

            public void handle(String messageType, JSONObject message) {
                ContentAssistService.this.handleContentAssistRequest(message);
            }
        };
        messagingConnector.addMessageHandler(this.contentAssistRequestHandler);
    }

    protected void handleContentAssistRequest(JSONObject message) {
        try {
            String username = message.getString("username");
            String projectName = message.getString("project");
            String resourcePath = message.getString("resource");
            int callbackID = message.getInt("callback_id");
            String liveEditID = String.valueOf(projectName) + "/" + resourcePath;
            if (this.liveEditUnits.isLiveEditResource(username, liveEditID)) {
                int offset = message.getInt("offset");
                String prefix = message.optString("prefix");
                String sender = message.getString("requestSenderID");
                JSONObject responseMessage = new JSONObject();
                responseMessage.put("username", (Object)username);
                responseMessage.put("project", (Object)projectName);
                responseMessage.put("resource", (Object)resourcePath);
                responseMessage.put("callback_id", callbackID);
                responseMessage.put("requestSenderID", (Object)sender);
                responseMessage.put("proposals", (Object)this.computeContentAssist(username, liveEditID, offset, prefix));
                this.messagingConnector.send("contentassistresponse", responseMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected JSONArray computeContentAssist(String username, String resourcePath, int offset, String prefix) throws JSONException {
        final ArrayList proposals = new ArrayList();
        final CompletionContext[] completionContextParam = new CompletionContext[1];
        ICompilationUnit liveEditUnit = this.liveEditUnits.getLiveEditUnit(username, resourcePath);
        try {
            if (liveEditUnit != null) {
                CompletionRequestor collector = new CompletionRequestor(){

                    public void accept(CompletionProposal proposal) {
                        proposals.add(proposal);
                    }

                    public void acceptContext(CompletionContext context) {
                        super.acceptContext(context);
                        completionContextParam[0] = context;
                    }
                };
                collector.setAllowsRequiredProposals(2, 9, true);
                collector.setAllowsRequiredProposals(2, 23, true);
                collector.setAllowsRequiredProposals(2, 21, true);
                collector.setAllowsRequiredProposals(6, 9, true);
                collector.setAllowsRequiredProposals(6, 23, true);
                collector.setAllowsRequiredProposals(6, 22, true);
                collector.setAllowsRequiredProposals(26, 9, true);
                collector.setAllowsRequiredProposals(27, 9, true);
                collector.setAllowsRequiredProposals(1, 9, true);
                collector.setAllowsRequiredProposals(9, 9, true);
                liveEditUnit.codeComplete(offset, collector, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        ArrayList<JSONObject> jsonProposals = new ArrayList<JSONObject>(proposals.size());
        CompletionContext completionContext = completionContextParam[0];
        for (CompletionProposal proposal : proposals) {
            JSONObject jsonDescription = this.getDescription(proposal, completionContext);
            ProposalReplcamentInfo replacementInfo = new CompletionProposalReplacementProvider(liveEditUnit, proposal, completionContext, offset, prefix).createReplacement();
            JSONObject jsonProposal = new JSONObject();
            jsonProposal.put("description", (Object)jsonDescription);
            jsonProposal.put("proposal", (Object)replacementInfo.replacement);
            int initOffset = offset - prefix.length();
            if (replacementInfo.extraChanges != null) {
                jsonProposal.put("additionalEdits", (Object)Utils.editsToJsonArray(replacementInfo.extraChanges));
                initOffset += Utils.getOffsetAdjustment(replacementInfo.extraChanges, initOffset);
            }
            if (replacementInfo.positions != null && !replacementInfo.positions.isEmpty()) {
                jsonProposal.put("positions", (Object)this.getPositions(replacementInfo.positions, initOffset));
            }
            jsonProposal.put("escapePosition", initOffset + replacementInfo.replacement.length());
            jsonProposal.put("style", (Object)"attributedString");
            jsonProposal.put("replace", true);
            jsonProposal.put("relevance", proposal.getRelevance());
            jsonProposals.add(jsonProposal);
        }
        Collections.sort(jsonProposals, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                try {
                    int diff = o2.getInt("relevance") - o1.getInt("relevance");
                    if (diff == 0) {
                        JSONArray nameDescription1 = o1.getJSONObject("description").getJSONArray("segments");
                        JSONArray nameDescription2 = o2.getJSONObject("description").getJSONArray("segments");
                        StringBuilder nameBuffer1 = new StringBuilder();
                        int i = 0;
                        while (i < nameDescription1.length()) {
                            nameBuffer1.append(nameDescription1.getJSONObject(i).getString("value"));
                            ++i;
                        }
                        StringBuilder nameBuffer2 = new StringBuilder();
                        int i2 = 0;
                        while (i2 < nameDescription2.length()) {
                            nameBuffer2.append(nameDescription2.getJSONObject(i2).getString("value"));
                            ++i2;
                        }
                        return nameBuffer1.toString().compareTo(nameBuffer2.toString());
                    }
                    return diff;
                }
                catch (JSONException jSONException) {
                    return -1;
                }
            }
        });
        return new JSONArray(jsonProposals);
    }

    private JSONArray getPositions(List<Integer> positionsList, int initOffset) throws JSONException {
        if (positionsList != null && positionsList.size() % 2 == 0) {
            JSONArray jsonPositions = new JSONArray();
            int i = 0;
            while (i < positionsList.size()) {
                JSONObject position = new JSONObject();
                position.put("offset", positionsList.get(i) + initOffset);
                position.put("length", (Object)positionsList.get(i + 1));
                jsonPositions.put((Object)position);
                i += 2;
            }
            return jsonPositions;
        }
        return null;
    }

    protected JSONObject getDescription(CompletionProposal proposal, CompletionContext context) throws JSONException {
        CompletionProposalDescriptionProvider provider = new CompletionProposalDescriptionProvider(context);
        JSONObject description = new JSONObject();
        if (proposal.getKind() == 6) {
            JSONObject src = new JSONObject();
            src.put("src", (Object)"../js/editor/textview/methpub_obj.gif");
            description.put("icon", (Object)src);
        } else if (proposal.getKind() == 2) {
            JSONObject src = new JSONObject();
            src.put("src", (Object)"../js/editor/textview/field_public_obj.gif");
            description.put("icon", (Object)src);
        } else if (proposal.getKind() == 9) {
            JSONObject src = new JSONObject();
            src.put("src", (Object)"../js/editor/textview/class_obj.gif");
            description.put("icon", (Object)src);
        }
        description.put("segments", (Object)new JSONArray(provider.createDescription(proposal).toString()));
        description.put("metadata", (Object)new JSONObject((Object)provider.createMetadata(proposal)));
        return description;
    }

    public void dispose() {
        this.messagingConnector.removeMessageHandler(this.contentAssistRequestHandler);
    }
}

