/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.jdt.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.compiler.IProblem;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveEditProblemRequestor
implements IProblemRequestor {
    private MessageConnector messagingConnector;
    private String resourcePath;
    private final List<IProblem> problems;
    private String username;
    private String projectName;

    public LiveEditProblemRequestor(MessageConnector messagingConnector, String username, String projectName, String resourcePath) {
        this.messagingConnector = messagingConnector;
        this.username = username;
        this.projectName = projectName;
        this.resourcePath = resourcePath;
        this.problems = new ArrayList<IProblem>();
    }

    public void acceptProblem(IProblem problem) {
        this.problems.add(problem);
    }

    public void beginReporting() {
        this.problems.clear();
    }

    public void endReporting() {
        this.sendMarkers(this.problems.toArray(new IProblem[this.problems.size()]));
    }

    public boolean isActive() {
        return true;
    }

    private void sendMarkers(IProblem[] problems) {
        String problemsJSON = this.toJSON(problems);
        try {
            JSONArray array = new JSONArray(problemsJSON);
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.username);
            message.put("project", (Object)this.projectName);
            message.put("resource", (Object)this.resourcePath);
            message.put("problems", (Object)array);
            this.messagingConnector.send("liveMetadataChanged", message);
            System.out.println("livemetadata transmitted");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String toJSON(IProblem[] problems) {
        StringBuilder result = new StringBuilder();
        boolean flag = false;
        result.append("[");
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (flag) {
                result.append(",");
            }
            result.append("{");
            result.append("\"id\":" + problem.getID());
            result.append(",\"author\":org.eclipse.flux.jdt");
            result.append(",\"description\":" + JSONObject.quote((String)problem.getMessage()));
            result.append(",\"line\":" + problem.getSourceLineNumber());
            result.append(",\"severity\":\"" + (problem.isError() ? "error" : "warning") + "\"");
            result.append(",\"start\":" + problem.getSourceStart());
            int end = problem.getSourceEnd() + 1;
            result.append(",\"end\":" + end);
            result.append("}");
            flag = true;
            ++n2;
        }
        result.append("]");
        return result.toString();
    }
}

