/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LinkedProposalPositionGroup {
    private final String fGroupId;
    private final List<PositionInformation> fPositions;
    private final List<Proposal> fProposals;

    public static PositionInformation createPositionInformation(ITrackedNodePosition pos, int sequenceRank) {
        return new TrackedNodePosition(pos, sequenceRank);
    }

    public LinkedProposalPositionGroup(String groupID) {
        this.fGroupId = groupID;
        this.fPositions = new ArrayList<PositionInformation>();
        this.fProposals = new ArrayList<Proposal>();
    }

    public void addPosition(PositionInformation position) {
        this.fPositions.add(position);
    }

    public void addPosition(ITrackedNodePosition position, int sequenceRank) {
        this.addPosition(LinkedProposalPositionGroup.createPositionInformation(position, sequenceRank));
    }

    public void addPosition(ITrackedNodePosition position, boolean isFirst) {
        this.addPosition(position, isFirst ? 0 : 1);
    }

    public void addProposal(Proposal proposal) {
        this.fProposals.add(proposal);
    }

    public void addProposal(String displayString, Image image, int relevance) {
        this.addProposal(new Proposal(displayString, image, relevance));
    }

    public void addProposal(ITypeBinding type, ICompilationUnit cu, int relevance) {
        this.addProposal(new JavaLinkedModeProposal(cu, type, relevance));
    }

    public String getGroupId() {
        return this.fGroupId;
    }

    public PositionInformation[] getPositions() {
        return this.fPositions.toArray(new PositionInformation[this.fPositions.size()]);
    }

    public Proposal[] getProposals() {
        return this.fProposals.toArray(new Proposal[this.fProposals.size()]);
    }

    private static final class JavaLinkedModeProposal
    extends Proposal {
        private final ITypeBinding fTypeProposal;
        private final ICompilationUnit fCompilationUnit;

        public JavaLinkedModeProposal(ICompilationUnit unit, ITypeBinding typeProposal, int relevance) {
            super(BindingLabelProvider.getBindingLabel((IBinding)typeProposal, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_POST_QUALIFIED), null, relevance);
            this.fTypeProposal = typeProposal;
            this.fCompilationUnit = unit;
        }

        @Override
        public TextEdit computeEdits(int offset, LinkedPosition position, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            ImportRewrite impRewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
            String replaceString = impRewrite.addImport(this.fTypeProposal);
            MultiTextEdit composedEdit = new MultiTextEdit();
            composedEdit.addChild((TextEdit)new ReplaceEdit(position.getOffset(), position.getLength(), replaceString));
            composedEdit.addChild(impRewrite.rewriteImports(null));
            return composedEdit;
        }
    }

    public static abstract class PositionInformation {
        public abstract int getOffset();

        public abstract int getLength();

        public abstract int getSequenceRank();
    }

    public static class Proposal {
        private String fDisplayString;
        private Image fImage;
        private int fRelevance;

        public Proposal(String displayString, Image image, int relevance) {
            this.fDisplayString = displayString;
            this.fImage = image;
            this.fRelevance = relevance;
        }

        public String getDisplayString() {
            return this.fDisplayString;
        }

        public Image getImage() {
            return this.fImage;
        }

        public int getRelevance() {
            return this.fRelevance;
        }

        public void setImage(Image image) {
            this.fImage = image;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public TextEdit computeEdits(int offset, LinkedPosition position, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            return new ReplaceEdit(position.getOffset(), position.getLength(), this.fDisplayString);
        }
    }

    public static class StartPositionInformation
    extends PositionInformation {
        private ITrackedNodePosition fPos;

        public StartPositionInformation(ITrackedNodePosition pos) {
            this.fPos = pos;
        }

        @Override
        public int getOffset() {
            return this.fPos.getStartPosition();
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public int getSequenceRank() {
            return 0;
        }
    }

    private static class TrackedNodePosition
    extends PositionInformation {
        private final ITrackedNodePosition fPos;
        private final int fSequenceRank;

        public TrackedNodePosition(ITrackedNodePosition pos, int sequenceRank) {
            this.fPos = pos;
            this.fSequenceRank = sequenceRank;
        }

        @Override
        public int getOffset() {
            return this.fPos.getStartPosition();
        }

        @Override
        public int getLength() {
            return this.fPos.getLength();
        }

        @Override
        public int getSequenceRank() {
            return this.fSequenceRank;
        }
    }

    public static class TrackedNodesPosition
    extends PositionInformation {
        private final Collection<ITrackedNodePosition> fPos;

        public TrackedNodesPosition(Collection<ITrackedNodePosition> pos) {
            this.fPos = pos;
        }

        @Override
        public int getOffset() {
            int minStart = Integer.MAX_VALUE;
            for (ITrackedNodePosition node : this.fPos) {
                minStart = Math.min(minStart, node.getStartPosition());
            }
            return minStart == Integer.MAX_VALUE ? -1 : minStart;
        }

        @Override
        public int getLength() {
            int minStart = Integer.MAX_VALUE;
            int maxEnd = 0;
            for (ITrackedNodePosition node : this.fPos) {
                minStart = Math.min(minStart, node.getStartPosition());
                maxEnd = Math.max(maxEnd, node.getStartPosition() + node.getLength());
            }
            return minStart == Integer.MAX_VALUE ? 0 : maxEnd - this.getOffset();
        }

        @Override
        public int getSequenceRank() {
            return 0;
        }
    }
}

