/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;

public class AssistContext
extends TextInvocationContext
implements IInvocationContext {
    private final ICompilationUnit fCompilationUnit;
    private CompilationUnit fASTRoot;
    private NodeFinder fNodeFinder;

    private AssistContext(ICompilationUnit cu, ISourceViewer sourceViewer, int offset, int length) {
        super(sourceViewer, offset, length);
        Assert.isLegal((cu != null ? 1 : 0) != 0);
        this.fCompilationUnit = cu;
    }

    public AssistContext(ICompilationUnit cu, int offset, int length) {
        this(cu, null, offset, length);
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    @Override
    public int getSelectionLength() {
        return Math.max(this.getLength(), 0);
    }

    @Override
    public int getSelectionOffset() {
        return this.getOffset();
    }

    @Override
    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = SharedASTProvider.getAST((ITypeRoot)this.fCompilationUnit, null);
            if (this.fASTRoot == null) {
                this.fASTRoot = ASTResolving.createQuickFixAST(this.fCompilationUnit, null);
            }
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit root) {
        this.fASTRoot = root;
    }

    @Override
    public ASTNode getCoveringNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.getOffset(), this.getLength());
        }
        return this.fNodeFinder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.getOffset(), this.getLength());
        }
        return this.fNodeFinder.getCoveredNode();
    }
}

