/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.flux.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.flux.client.CallbackIDAwareMessageHandler;
import org.eclipse.flux.client.IMessageHandler;
import org.eclipse.flux.client.MessageConnector;
import org.eclipse.flux.client.MessageHandler;
import org.eclipse.flux.core.ConnectedProject;
import org.eclipse.flux.core.IRepositoryListener;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Repository {
    private String username;
    private MessageConnector messagingConnector;
    private Collection<IMessageHandler> messageHandlers;
    private ConcurrentMap<String, ConnectedProject> syncedProjects;
    private Collection<IRepositoryListener> repositoryListeners;
    private static int GET_PROJECT_CALLBACK = "Repository - getProjectCallback".hashCode();
    private static int GET_RESOURCE_CALLBACK = "Repository - getResourceCallback".hashCode();
    private AtomicBoolean connected;

    public Repository(MessageConnector messagingConnector, String user) {
        this.username = user;
        this.connected = new AtomicBoolean(true);
        this.messagingConnector = messagingConnector;
        this.syncedProjects = new ConcurrentHashMap<String, ConnectedProject>();
        this.repositoryListeners = new ConcurrentLinkedDeque<IRepositoryListener>();
        this.messageHandlers = new ArrayList<IMessageHandler>(9);
        MessageHandler resourceChangedHandler = new MessageHandler("resourceChanged"){

            public void handle(String messageType, JSONObject message) {
                Repository.this.updateResource(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)resourceChangedHandler);
        this.messageHandlers.add((IMessageHandler)resourceChangedHandler);
        MessageHandler resourceCreatedHandler = new MessageHandler("resourceCreated"){

            public void handle(String messageType, JSONObject message) {
                Repository.this.createResource(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)resourceCreatedHandler);
        this.messageHandlers.add((IMessageHandler)resourceCreatedHandler);
        MessageHandler resourceDeletedHandler = new MessageHandler("resourceDeleted"){

            public void handle(String messageType, JSONObject message) {
                Repository.this.deleteResource(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)resourceDeletedHandler);
        this.messageHandlers.add((IMessageHandler)resourceDeletedHandler);
        MessageHandler getProjectsRequestHandler = new MessageHandler("getProjectsRequest"){

            public void handle(String messageType, JSONObject message) {
                Repository.this.getProjects(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)getProjectsRequestHandler);
        this.messageHandlers.add((IMessageHandler)getProjectsRequestHandler);
        MessageHandler getProjectRequestHandler = new MessageHandler("getProjectRequest"){

            public void handle(String messageType, JSONObject message) {
                Repository.this.getProject(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)getProjectRequestHandler);
        this.messageHandlers.add((IMessageHandler)getProjectRequestHandler);
        CallbackIDAwareMessageHandler getProjectResponseHandler = new CallbackIDAwareMessageHandler("getProjectResponse", GET_PROJECT_CALLBACK){

            public void handle(String messageType, JSONObject message) {
                Repository.this.getProjectResponse(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)getProjectResponseHandler);
        this.messageHandlers.add((IMessageHandler)getProjectResponseHandler);
        MessageHandler getResourceRequestHandler = new MessageHandler("getResourceRequest"){

            public void handle(String messageType, JSONObject message) {
                try {
                    String resourcePath = message.getString("resource");
                    if (resourcePath.startsWith("classpath:")) {
                        Repository.this.getClasspathResource(message);
                    } else {
                        Repository.this.getResource(message);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)getResourceRequestHandler);
        this.messageHandlers.add((IMessageHandler)getResourceRequestHandler);
        CallbackIDAwareMessageHandler getResourceResponseHandler = new CallbackIDAwareMessageHandler("getResourceResponse", GET_RESOURCE_CALLBACK){

            public void handle(String messageType, JSONObject message) {
                Repository.this.getResourceResponse(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)getResourceResponseHandler);
        this.messageHandlers.add((IMessageHandler)getResourceResponseHandler);
        MessageHandler getMetadataRequestHandler = new MessageHandler("getMetadataRequest"){

            public void handle(String messageType, JSONObject message) {
                Repository.this.getMetadata(message);
            }
        };
        this.messagingConnector.addMessageHandler((IMessageHandler)getMetadataRequestHandler);
        this.messageHandlers.add((IMessageHandler)getMetadataRequestHandler);
    }

    public String getUsername() {
        return this.username;
    }

    protected void connect() {
        for (String projectName : this.syncedProjects.keySet()) {
            this.sendProjectConnectedMessage(projectName);
            this.syncConnectedProject(projectName);
        }
    }

    public ConnectedProject getProject(IProject project) {
        return this.getProject(project.getName());
    }

    public ConnectedProject getProject(String projectName) {
        return (ConnectedProject)this.syncedProjects.get(projectName);
    }

    public boolean isConnected(IProject project) {
        return this.syncedProjects.containsKey(project.getName());
    }

    public boolean isConnected(String project) {
        return this.syncedProjects.containsKey(project);
    }

    public void addProject(IProject project) {
        String projectName = project.getName();
        if (!this.syncedProjects.containsKey(projectName)) {
            this.syncedProjects.put(projectName, new ConnectedProject(project));
            this.notifyProjectConnected(project);
            this.sendProjectConnectedMessage(projectName);
            this.syncConnectedProject(projectName);
        }
    }

    public void removeProject(IProject project) {
        String projectName = project.getName();
        if (this.syncedProjects.containsKey(projectName)) {
            this.syncedProjects.remove(projectName);
            this.notifyProjectDisonnected(project);
            try {
                JSONObject message = new JSONObject();
                message.put("username", (Object)this.username);
                message.put("project", (Object)projectName);
                this.messagingConnector.send("projectDisconnected", message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void syncConnectedProject(String projectName) {
        try {
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.username);
            message.put("project", (Object)projectName);
            message.put("includeDeleted", true);
            message.put("callback_id", GET_PROJECT_CALLBACK);
            this.messagingConnector.send("getProjectRequest", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void sendProjectConnectedMessage(String projectName) {
        try {
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.username);
            message.put("project", (Object)projectName);
            this.messagingConnector.send("projectConnected", message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConnectedProject[] getConnectedProjects() {
        return this.syncedProjects.values().toArray(new ConnectedProject[this.syncedProjects.size()]);
    }

    public void getProjects(JSONObject request) {
        try {
            int callbackID = this.getIntMaybe(request, "callback_id");
            String sender = request.getString("requestSenderID");
            String username = request.getString("username");
            if (this.username.equals(username)) {
                JSONArray projects = new JSONArray();
                for (String projectName : this.syncedProjects.keySet()) {
                    JSONObject proj = new JSONObject();
                    proj.put("name", (Object)projectName);
                    projects.put((Object)proj);
                }
                JSONObject message = new JSONObject();
                message.put("callback_id", callbackID);
                message.put("requestSenderID", (Object)sender);
                message.put("username", (Object)this.username);
                message.put("projects", (Object)projects);
                this.messagingConnector.send("getProjectsResponse", message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getIntMaybe(JSONObject request, String prop) throws JSONException {
        if (request.has(prop)) {
            return request.getInt(prop);
        }
        return 0;
    }

    public void getProject(JSONObject request) {
        block4: {
            try {
                int callbackID = request.getInt("callback_id");
                String sender = request.getString("requestSenderID");
                String projectName = request.getString("project");
                String username = request.getString("username");
                final ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
                if (!this.username.equals(username) || connectedProject == null) break block4;
                final JSONArray files = new JSONArray();
                IProject project = connectedProject.getProject();
                try {
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            JSONObject projectResource = new JSONObject();
                            String path = resource.getProjectRelativePath().toString();
                            try {
                                projectResource.put("path", (Object)path);
                                projectResource.put("timestamp", connectedProject.getTimestamp(path));
                                projectResource.put("hash", (Object)connectedProject.getHash(path));
                                if (resource instanceof IFile) {
                                    projectResource.put("type", (Object)"file");
                                } else if (resource instanceof IFolder) {
                                    projectResource.put("type", (Object)"folder");
                                }
                                files.put((Object)projectResource);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            return true;
                        }
                    }, 2, 4);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JSONObject message = new JSONObject();
                message.put("callback_id", callbackID);
                message.put("requestSenderID", (Object)sender);
                message.put("username", (Object)this.username);
                message.put("project", (Object)projectName);
                message.put("username", (Object)this.username);
                message.put("files", (Object)files);
                this.messagingConnector.send("getProjectResponse", message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void getProjectResponse(JSONObject response) {
        try {
            String username = response.getString("username");
            String projectName = response.getString("project");
            JSONArray files = response.getJSONArray("files");
            JSONArray deleted = response.optJSONArray("deleted");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null) {
                String resourcePath;
                int i = 0;
                while (i < files.length()) {
                    boolean updatedFolder;
                    boolean updatedFile;
                    JSONObject resource = files.getJSONObject(i);
                    resourcePath = resource.getString("path");
                    long timestamp = resource.getLong("timestamp");
                    String type = resource.optString("type");
                    String hash = resource.optString("hash");
                    boolean newFile = type != null && type.equals("file") && !connectedProject.containsResource(resourcePath);
                    boolean updatedFileTimestamp = type != null && type.equals("file") && connectedProject.containsResource(resourcePath) && connectedProject.getHash(resourcePath).equals(hash) && connectedProject.getTimestamp(resourcePath) < timestamp;
                    boolean bl = updatedFile = type != null && type.equals("file") && connectedProject.containsResource(resourcePath) && !connectedProject.getHash(resourcePath).equals(hash) && connectedProject.getTimestamp(resourcePath) < timestamp;
                    if (newFile || updatedFile) {
                        JSONObject message = new JSONObject();
                        message.put("callback_id", GET_RESOURCE_CALLBACK);
                        message.put("project", (Object)projectName);
                        message.put("username", (Object)this.username);
                        message.put("resource", (Object)resourcePath);
                        message.put("timestamp", timestamp);
                        message.put("hash", (Object)hash);
                        this.messagingConnector.send("getResourceRequest", message);
                    }
                    if (updatedFileTimestamp) {
                        connectedProject.setTimestamp(resourcePath, timestamp);
                        IResource file = connectedProject.getProject().findMember(resourcePath);
                        file.setLocalTimeStamp(timestamp);
                    }
                    boolean newFolder = type != null && type.equals("folder") && !connectedProject.containsResource(resourcePath);
                    boolean bl2 = updatedFolder = type != null && type.equals("folder") && connectedProject.containsResource(resourcePath) && connectedProject.getHash(resourcePath) != null && !connectedProject.getHash(resourcePath).equals(hash) && connectedProject.getTimestamp(resourcePath) < timestamp;
                    if (newFolder) {
                        IProject project = connectedProject.getProject();
                        IFolder folder = project.getFolder(resourcePath);
                        connectedProject.setHash(resourcePath, hash);
                        connectedProject.setTimestamp(resourcePath, timestamp);
                        folder.create(true, true, null);
                        folder.setLocalTimeStamp(timestamp);
                    }
                    ++i;
                }
                if (deleted != null) {
                    i = 0;
                    while (i < deleted.length()) {
                        long localTimestamp;
                        JSONObject deletedResource = deleted.getJSONObject(i);
                        resourcePath = deletedResource.getString("path");
                        long deletedTimestamp = deletedResource.getLong("timestamp");
                        IProject project = connectedProject.getProject();
                        IResource resource = project.findMember(resourcePath);
                        if (resource != null && resource.exists() && (resource instanceof IFile || resource instanceof IFolder) && (localTimestamp = connectedProject.getTimestamp(resourcePath)) < deletedTimestamp) {
                            resource.delete(true, null);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getResource(JSONObject request) {
        try {
            String username = request.getString("username");
            int callbackID = request.getInt("callback_id");
            String sender = request.getString("requestSenderID");
            String projectName = request.getString("project");
            String resourcePath = request.getString("resource");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null && connectedProject.containsResource(resourcePath)) {
                IProject project = connectedProject.getProject();
                if (request.has("timestamp") && request.getLong("timestamp") != connectedProject.getTimestamp(resourcePath)) {
                    return;
                }
                IResource resource = project.findMember(resourcePath);
                JSONObject message = new JSONObject();
                message.put("callback_id", callbackID);
                message.put("requestSenderID", (Object)sender);
                message.put("username", (Object)this.username);
                message.put("project", (Object)projectName);
                message.put("resource", (Object)resourcePath);
                message.put("timestamp", connectedProject.getTimestamp(resourcePath));
                message.put("hash", (Object)connectedProject.getHash(resourcePath));
                if (resource instanceof IFile) {
                    if (request.has("hash") && !request.getString("hash").equals(connectedProject.getHash(resourcePath))) {
                        return;
                    }
                    IFile file = (IFile)resource;
                    ByteArrayOutputStream array = new ByteArrayOutputStream();
                    if (!file.isSynchronized(0)) {
                        file.refreshLocal(0, null);
                    }
                    IOUtils.copy((InputStream)file.getContents(), (OutputStream)array);
                    String content = new String(array.toByteArray(), file.getCharset());
                    message.put("content", (Object)content);
                    message.put("type", (Object)"file");
                } else if (resource instanceof IFolder) {
                    message.put("type", (Object)"folder");
                }
                this.messagingConnector.send("getResourceResponse", message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getClasspathResource(JSONObject request) {
        try {
            int callbackID = request.getInt("callback_id");
            String sender = request.getString("requestSenderID");
            String projectName = request.getString("project");
            String resourcePath = request.getString("resource");
            String username = request.getString("username");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null) {
                IType type;
                IClassFile classFile;
                String typeName = resourcePath.substring("classpath:/".length());
                if (typeName.endsWith(".class")) {
                    typeName = typeName.substring(0, typeName.length() - ".class".length());
                }
                typeName = typeName.replace('/', '.');
                IJavaProject javaProject = JavaCore.create((IProject)connectedProject.getProject());
                if (javaProject != null && (classFile = (type = javaProject.findType(typeName)).getClassFile()) != null && classFile.getSourceRange() != null) {
                    JSONObject message = new JSONObject();
                    message.put("callback_id", callbackID);
                    message.put("requestSenderID", (Object)sender);
                    message.put("username", (Object)this.username);
                    message.put("project", (Object)projectName);
                    message.put("resource", (Object)resourcePath);
                    message.put("readonly", true);
                    String content = classFile.getSource();
                    message.put("content", (Object)content);
                    message.put("type", (Object)"file");
                    this.messagingConnector.send("getResourceResponse", message);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateResource(JSONObject request) {
        try {
            IProject project;
            IResource resource;
            String username = request.getString("username");
            String projectName = request.getString("project");
            String resourcePath = request.getString("resource");
            long updateTimestamp = request.getLong("timestamp");
            String updateHash = request.optString("hash");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null && (resource = (project = connectedProject.getProject()).findMember(resourcePath)) != null && resource instanceof IFile) {
                String localHash = connectedProject.getHash(resourcePath);
                long localTimestamp = connectedProject.getTimestamp(resourcePath);
                if (localHash != null && !localHash.equals(updateHash) && localTimestamp < updateTimestamp) {
                    JSONObject message = new JSONObject();
                    message.put("callback_id", GET_RESOURCE_CALLBACK);
                    message.put("username", (Object)this.username);
                    message.put("project", (Object)projectName);
                    message.put("resource", (Object)resourcePath);
                    message.put("timestamp", updateTimestamp);
                    message.put("hash", (Object)updateHash);
                    this.messagingConnector.send("getResourceRequest", message);
                    this.notifyResourceChanged(resource);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createResource(JSONObject request) {
        try {
            IProject project;
            IResource resource;
            String username = request.getString("username");
            String projectName = request.getString("project");
            String resourcePath = request.getString("resource");
            long updateTimestamp = request.getLong("timestamp");
            String updateHash = request.optString("hash");
            String type = request.optString("type");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null && (resource = (project = connectedProject.getProject()).findMember(resourcePath)) == null) {
                if ("folder".equals(type)) {
                    IFolder newFolder = project.getFolder(resourcePath);
                    connectedProject.setHash(resourcePath, updateHash);
                    connectedProject.setTimestamp(resourcePath, updateTimestamp);
                    newFolder.create(true, true, null);
                    newFolder.setLocalTimeStamp(updateTimestamp);
                    JSONObject message = new JSONObject();
                    message.put("username", (Object)this.username);
                    message.put("project", (Object)projectName);
                    message.put("resource", (Object)resourcePath);
                    message.put("timestamp", updateTimestamp);
                    message.put("hash", (Object)updateHash);
                    message.put("type", (Object)type);
                    this.messagingConnector.send("resourceStored", message);
                } else if ("file".equals(type)) {
                    JSONObject message = new JSONObject();
                    message.put("callback_id", GET_RESOURCE_CALLBACK);
                    message.put("username", (Object)this.username);
                    message.put("project", (Object)projectName);
                    message.put("resource", (Object)resourcePath);
                    message.put("timestamp", updateTimestamp);
                    message.put("hash", (Object)updateHash);
                    message.put("type", (Object)type);
                    this.messagingConnector.send("getResourceRequest", message);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteResource(JSONObject request) {
        try {
            long localTimestamp;
            IProject project;
            IResource resource;
            String username = request.getString("username");
            String projectName = request.getString("project");
            String resourcePath = request.getString("resource");
            long deletedTimestamp = request.getLong("timestamp");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null && (resource = (project = connectedProject.getProject()).findMember(resourcePath)) != null && resource.exists() && (resource instanceof IFile || resource instanceof IFolder) && (localTimestamp = connectedProject.getTimestamp(resourcePath)) < deletedTimestamp) {
                resource.delete(true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getResourceResponse(JSONObject response) {
        try {
            String username = response.getString("username");
            String projectName = response.getString("project");
            String resourcePath = response.getString("resource");
            long updateTimestamp = response.getLong("timestamp");
            String updateHash = response.getString("hash");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null) {
                boolean stored = false;
                IProject project = connectedProject.getProject();
                IResource resource = project.findMember(resourcePath);
                if (resource != null) {
                    if (resource instanceof IFile) {
                        String localHash = connectedProject.getHash(resourcePath);
                        long localTimestamp = connectedProject.getTimestamp(resourcePath);
                        if (localHash != null && !localHash.equals(updateHash) && localTimestamp < updateTimestamp) {
                            IFile file = (IFile)resource;
                            String newResourceContent = response.getString("content");
                            connectedProject.setTimestamp(resourcePath, updateTimestamp);
                            connectedProject.setHash(resourcePath, updateHash);
                            file.setContents((InputStream)new ByteArrayInputStream(newResourceContent.getBytes()), true, true, null);
                            file.setLocalTimeStamp(updateTimestamp);
                            stored = true;
                        }
                    }
                } else {
                    IFile newFile = project.getFile(resourcePath);
                    String newResourceContent = response.getString("content");
                    connectedProject.setHash(resourcePath, updateHash);
                    connectedProject.setTimestamp(resourcePath, updateTimestamp);
                    newFile.create((InputStream)new ByteArrayInputStream(newResourceContent.getBytes()), true, null);
                    newFile.setLocalTimeStamp(updateTimestamp);
                    stored = true;
                }
                if (stored) {
                    JSONObject message = new JSONObject();
                    message.put("username", (Object)this.username);
                    message.put("project", (Object)connectedProject.getName());
                    message.put("resource", (Object)resourcePath);
                    message.put("timestamp", updateTimestamp);
                    message.put("hash", (Object)updateHash);
                    message.put("type", (Object)"file");
                    this.messagingConnector.send("resourceStored", message);
                    if (resource != null) {
                        this.notifyResourceChanged(resource);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getMetadata(JSONObject request) {
        try {
            String username = request.getString("username");
            int callbackID = request.getInt("callback_id");
            String sender = request.getString("requestSenderID");
            String projectName = request.getString("project");
            String resourcePath = request.getString("resource");
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(projectName);
            if (this.username.equals(username) && connectedProject != null) {
                IProject project = connectedProject.getProject();
                IResource resource = project.findMember(resourcePath);
                JSONObject message = new JSONObject();
                message.put("callback_id", callbackID);
                message.put("requestSenderID", (Object)sender);
                message.put("username", (Object)this.username);
                message.put("project", (Object)projectName);
                message.put("resource", (Object)resourcePath);
                message.put("type", (Object)"marker");
                IMarker[] markers = resource.findMarkers(null, true, 2);
                String markerJSON = this.toJSON(markers);
                JSONArray content = new JSONArray(markerJSON);
                message.put("metadata", (Object)content);
                this.messagingConnector.send("getMetadataResponse", message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resourceChanged(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        if (project != null && this.isConnected(project)) {
            this.reactToResourceChange(delta);
        }
    }

    public void metadataChanged(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
        if (project != null && this.isConnected(project) && markerDeltas != null && markerDeltas.length > 0) {
            this.sendMetadataUpdate(delta.getResource());
        }
    }

    public void reactToResourceChange(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null && resource.isDerived(512)) {
            return;
        }
        switch (delta.getKind()) {
            case 1: {
                this.reactOnResourceAdded(resource);
                break;
            }
            case 2: {
                this.reactOnResourceRemoved(resource);
                break;
            }
            case 4: {
                this.reactOnResourceChange(resource);
            }
        }
    }

    protected void reactOnResourceAdded(IResource resource) {
        try {
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(resource.getProject().getName());
            String resourcePath = resource.getProjectRelativePath().toString();
            long timestamp = resource.getLocalTimeStamp();
            String hash = "0";
            String type = null;
            connectedProject.setTimestamp(resourcePath, timestamp);
            if (resource instanceof IFile) {
                try {
                    IFile file = (IFile)resource;
                    hash = DigestUtils.shaHex((InputStream)file.getContents());
                    type = "file";
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (resource instanceof IFolder) {
                type = "folder";
            }
            connectedProject.setHash(resourcePath, hash);
            JSONObject createdMessage = new JSONObject();
            createdMessage.put("username", (Object)this.username);
            createdMessage.put("project", (Object)connectedProject.getName());
            createdMessage.put("resource", (Object)resourcePath);
            createdMessage.put("timestamp", timestamp);
            createdMessage.put("hash", (Object)hash);
            createdMessage.put("type", (Object)type);
            this.messagingConnector.send("resourceCreated", createdMessage);
            JSONObject storedMessage = new JSONObject();
            storedMessage.put("username", (Object)this.username);
            storedMessage.put("project", (Object)connectedProject.getName());
            storedMessage.put("resource", (Object)resourcePath);
            storedMessage.put("timestamp", timestamp);
            storedMessage.put("hash", (Object)hash);
            storedMessage.put("type", (Object)type);
            this.messagingConnector.send("resourceStored", storedMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void reactOnResourceRemoved(IResource resource) {
        if (resource instanceof IProject) {
            this.removeProject((IProject)resource);
        } else if (!resource.isDerived() && (resource instanceof IFile || resource instanceof IFolder)) {
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(resource.getProject().getName());
            String resourcePath = resource.getProjectRelativePath().toString();
            long deletedTimestamp = System.currentTimeMillis();
            try {
                JSONObject message = new JSONObject();
                message.put("username", (Object)this.username);
                message.put("project", (Object)connectedProject.getName());
                message.put("resource", (Object)resourcePath);
                message.put("timestamp", deletedTimestamp);
                this.messagingConnector.send("resourceDeleted", message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void reactOnResourceChange(IResource resource) {
        if (resource != null && resource instanceof IFile) {
            IFile file = (IFile)resource;
            ConnectedProject connectedProject = (ConnectedProject)this.syncedProjects.get(file.getProject().getName());
            String resourcePath = resource.getProjectRelativePath().toString();
            try {
                String changeHash;
                long changeTimestamp = file.getLocalTimeStamp();
                if (changeTimestamp > connectedProject.getTimestamp(resourcePath) && !(changeHash = DigestUtils.shaHex((InputStream)file.getContents())).equals(connectedProject.getHash(resourcePath))) {
                    connectedProject.setTimestamp(resourcePath, changeTimestamp);
                    connectedProject.setHash(resourcePath, changeHash);
                    JSONObject changedMessage = new JSONObject();
                    changedMessage.put("username", (Object)this.username);
                    changedMessage.put("project", (Object)connectedProject.getName());
                    changedMessage.put("resource", (Object)resourcePath);
                    changedMessage.put("timestamp", changeTimestamp);
                    changedMessage.put("hash", (Object)changeHash);
                    this.messagingConnector.send("resourceChanged", changedMessage);
                    JSONObject storedMessage = new JSONObject();
                    storedMessage.put("username", (Object)this.username);
                    storedMessage.put("project", (Object)connectedProject.getName());
                    storedMessage.put("resource", (Object)resourcePath);
                    storedMessage.put("timestamp", changeTimestamp);
                    storedMessage.put("hash", (Object)changeHash);
                    this.messagingConnector.send("resourceStored", storedMessage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendMetadataUpdate(IResource resource) {
        try {
            String project = resource.getProject().getName();
            String resourcePath = resource.getProjectRelativePath().toString();
            JSONObject message = new JSONObject();
            message.put("username", (Object)this.username);
            message.put("project", (Object)project);
            message.put("resource", (Object)resourcePath);
            message.put("type", (Object)"marker");
            IMarker[] markers = resource.findMarkers(null, true, 2);
            String markerJSON = this.toJSON(markers);
            JSONArray content = new JSONArray(markerJSON);
            message.put("metadata", (Object)content);
            this.messagingConnector.send("metadataChanged", message);
        }
        catch (Exception exception) {}
    }

    public String toJSON(IMarker[] markers) {
        StringBuilder result = new StringBuilder();
        boolean flag = false;
        result.append("[");
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            if (flag) {
                result.append(",");
            }
            result.append("{");
            result.append("\"description\":" + JSONObject.quote((String)m.getAttribute("message", "")));
            result.append(",\"line\":" + m.getAttribute("lineNumber", 0));
            result.append(",\"severity\":\"" + (m.getAttribute("severity", 1) == 2 ? "error" : "warning") + "\"");
            result.append(",\"start\":" + m.getAttribute("charStart", 0));
            result.append(",\"end\":" + m.getAttribute("charEnd", 0));
            result.append("}");
            flag = true;
            ++n2;
        }
        result.append("]");
        return result.toString();
    }

    public void addRepositoryListener(IRepositoryListener listener) {
        this.repositoryListeners.add(listener);
    }

    public void removeRepositoryListener(IRepositoryListener listener) {
        this.repositoryListeners.remove(listener);
    }

    protected void notifyProjectConnected(IProject project) {
        for (IRepositoryListener listener : this.repositoryListeners) {
            listener.projectConnected(project);
        }
    }

    protected void notifyProjectDisonnected(IProject project) {
        for (IRepositoryListener listener : this.repositoryListeners) {
            listener.projectDisconnected(project);
        }
    }

    protected void notifyResourceChanged(IResource resource) {
        for (IRepositoryListener listener : this.repositoryListeners) {
            listener.resourceChanged(resource);
        }
    }

    public void dispose() {
        this.connected.set(false);
        for (IMessageHandler messageHandler : this.messageHandlers) {
            this.messagingConnector.removeMessageHandler(messageHandler);
        }
        this.syncedProjects.clear();
    }
}

