/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.common.util.FileCharsetDetector;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DefaultPomManager
extends AbstractLogEnabled
implements PomManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModule(File pom, String artifactId) throws IOException, XmlPullParserException, DocumentException, InvalidPackaging {
        boolean found = false;
        StringWriter writer = new StringWriter();
        FileReader fileReader = new FileReader(pom);
        try {
            fileReader = new FileReader(pom);
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)fileReader);
            Element project = document.getRootElement();
            String packaging = null;
            Element packagingElement = project.element("packaging");
            if (packagingElement != null) {
                packaging = packagingElement.getStringValue();
            }
            if (!"pom".equals(packaging)) {
                throw new InvalidPackaging("Unable to add module to the current project as it is not of packaging type 'pom'");
            }
            Element modules = project.element("modules");
            if (modules == null) {
                modules = project.addText("  ").addElement("modules");
                modules.setText("\n  ");
                project.addText("\n");
            }
            Iterator i = modules.elementIterator("module");
            while (i.hasNext() && !found) {
                Element module = (Element)i.next();
                if (!module.getText().equals(artifactId)) continue;
                found = true;
            }
            if (!found) {
                Node lastTextNode = null;
                Iterator i2 = modules.nodeIterator();
                while (i2.hasNext()) {
                    Node node = (Node)i2.next();
                    if (node.getNodeType() == 1) {
                        lastTextNode = null;
                        continue;
                    }
                    if (node.getNodeType() != 3) continue;
                    lastTextNode = node;
                }
                if (lastTextNode != null) {
                    modules.remove(lastTextNode);
                }
                modules.addText("\n    ");
                modules.addElement("module").setText(artifactId);
                modules.addText("\n  ");
                XMLWriter xmlWriter = new XMLWriter((Writer)writer);
                xmlWriter.write(document);
                FileUtils.fileWrite((String)pom.getAbsolutePath(), (String)writer.toString());
            }
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
    }

    public void addParent(File pom, File parentPom) throws IOException, XmlPullParserException {
        Model generatedModel = this.readPom(pom);
        Model parentModel = this.readPom(parentPom);
        Parent parent = new Parent();
        parent.setGroupId(parentModel.getGroupId());
        if (parent.getGroupId() == null) {
            parent.setGroupId(parentModel.getParent().getGroupId());
        }
        parent.setArtifactId(parentModel.getArtifactId());
        parent.setVersion(parentModel.getVersion());
        if (parent.getVersion() == null) {
            parent.setVersion(parentModel.getParent().getVersion());
        }
        generatedModel.setParent(parent);
        this.writePom(generatedModel, pom, pom);
    }

    public void mergePoms(File pom, File temporaryPom) throws IOException, XmlPullParserException {
        Model model = this.readPom(pom);
        Model generatedModel = this.readPom(temporaryPom);
        this.mergeDependencies(model, generatedModel);
        this.mergeBuildPlugins(model, generatedModel);
        this.mergeReportPlugins(model, generatedModel);
        this.writePom(model, pom, pom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model readPom(File pomFile) throws IOException, XmlPullParserException {
        Model model;
        InputStreamReader pomReader = null;
        try {
            FileCharsetDetector detector = new FileCharsetDetector(pomFile);
            String fileEncoding = detector.isFound() ? detector.getCharset() : "UTF-8";
            pomReader = new InputStreamReader((InputStream)new FileInputStream(pomFile), fileEncoding);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            model = reader.read((Reader)pomReader);
            if (StringUtils.isEmpty((String)model.getModelEncoding())) {
                model.setModelEncoding(fileEncoding);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(pomReader);
            pomReader = null;
            throw throwable;
        }
        IOUtil.close((Reader)pomReader);
        pomReader = null;
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model readPom(InputStream pomStream) throws IOException, XmlPullParserException {
        Model model;
        InputStreamReader pomReader = null;
        try {
            String fileEncoding = "UTF-8";
            pomReader = new InputStreamReader(pomStream, fileEncoding);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            model = reader.read((Reader)pomReader);
            if (StringUtils.isEmpty((String)model.getModelEncoding())) {
                model.setModelEncoding(fileEncoding);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(pomReader);
            pomReader = null;
            throw throwable;
        }
        IOUtil.close((Reader)pomReader);
        pomReader = null;
        return model;
    }

    /*
     * Exception decompiling
     */
    public void writePom(Model model, File pomFile, File initialPomFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map createDependencyMap(List dependencies) {
        HashMap<String, Dependency> dependencyMap = new HashMap<String, Dependency>();
        Iterator dependenciesIterator = dependencies.iterator();
        while (dependenciesIterator.hasNext()) {
            Dependency dependency = (Dependency)dependenciesIterator.next();
            dependencyMap.put(dependency.getGroupId() + ":" + dependency.getArtifactId(), dependency);
        }
        return dependencyMap;
    }

    private void mergeBuildPlugins(Model model, Model generatedModel) {
        if (generatedModel.getBuild() != null) {
            if (model.getBuild() == null) {
                model.setBuild(new Build());
            }
            Map pluginsByIds = model.getBuild().getPluginsAsMap();
            Map generatedPluginsByIds = generatedModel.getBuild().getPluginsAsMap();
            Iterator generatedPluginsIds = generatedPluginsByIds.keySet().iterator();
            while (generatedPluginsIds.hasNext()) {
                String generatedPluginsId = (String)generatedPluginsIds.next();
                if (!pluginsByIds.containsKey(generatedPluginsId)) {
                    model.getBuild().addPlugin((Plugin)generatedPluginsByIds.get(generatedPluginsId));
                    continue;
                }
                this.getLogger().warn("Can not override plugin: " + generatedPluginsId);
            }
        }
    }

    private void mergeDependencies(Model model, Model generatedModel) {
        Map dependenciesByIds = this.createDependencyMap(model.getDependencies());
        Map generatedDependenciesByIds = this.createDependencyMap(generatedModel.getDependencies());
        Iterator generatedDependencyIds = generatedDependenciesByIds.keySet().iterator();
        while (generatedDependencyIds.hasNext()) {
            String generatedDependencyId = (String)generatedDependencyIds.next();
            if (!dependenciesByIds.containsKey(generatedDependencyId)) {
                model.addDependency((Dependency)generatedDependenciesByIds.get(generatedDependencyId));
                continue;
            }
            this.getLogger().warn("Can not override property: " + generatedDependencyId);
        }
    }

    private void mergeReportPlugins(Model model, Model generatedModel) {
        if (generatedModel.getReporting() != null) {
            if (model.getReporting() == null) {
                model.setReporting(new Reporting());
            }
            Map reportPluginsByIds = model.getReporting().getReportPluginsAsMap();
            Map generatedReportPluginsByIds = generatedModel.getReporting().getReportPluginsAsMap();
            Iterator generatedReportPluginsIds = generatedReportPluginsByIds.keySet().iterator();
            while (generatedReportPluginsIds.hasNext()) {
                String generatedReportPluginsId = (String)generatedReportPluginsIds.next();
                if (!reportPluginsByIds.containsKey(generatedReportPluginsId)) {
                    model.getReporting().addPlugin((ReportPlugin)generatedReportPluginsByIds.get(generatedReportPluginsId));
                    continue;
                }
                this.getLogger().warn("Can not override report: " + generatedReportPluginsId);
            }
        }
    }
}

