/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;

public final class NonLoginAuthenticator
extends AuthenticatorBase {
    @Override
    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        Principal principal = request.getPrincipal();
        if (principal != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("Already authenticated as '" + principal.getName() + "'");
            }
            if (this.cache) {
                Session session = request.getSessionInternal(true);
                session.setPrincipal(principal);
                String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
                if (ssoId != null) {
                    if (this.containerLog.isDebugEnabled()) {
                        this.containerLog.debug("User authenticated by existing SSO");
                    }
                    this.associate(ssoId, session);
                }
            }
            return true;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug("User authenticated without any roles");
        }
        return true;
    }

    @Override
    protected String getAuthMethod() {
        return "NONE";
    }
}

