/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Random;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.StringCache;
import org.apache.tomcat.util.res.StringManager;

public final class StandardServer
extends LifecycleMBeanBase
implements Server {
    private static final Log log = LogFactory.getLog(StandardServer.class);
    private javax.naming.Context globalNamingContext = null;
    private NamingResourcesImpl globalNamingResources = null;
    private final NamingContextListener namingContextListener;
    private int port = 8005;
    private String address = "localhost";
    private Random random = null;
    private Service[] services = new Service[0];
    private final Object servicesLock = new Object();
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private volatile boolean stopAwait = false;
    private Catalina catalina = null;
    private ClassLoader parentClassLoader = null;
    private volatile Thread awaitThread = null;
    private volatile ServerSocket awaitSocket = null;
    private File catalinaHome = null;
    private File catalinaBase = null;
    private final Object namingToken = new Object();
    private ObjectName onameStringCache;
    private ObjectName onameMBeanFactory;

    public StandardServer() {
        this.globalNamingResources = new NamingResourcesImpl();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming()) {
            this.namingContextListener = new NamingContextListener();
            this.addLifecycleListener(this.namingContextListener);
        } else {
            this.namingContextListener = null;
        }
    }

    @Override
    public Object getNamingToken() {
        return this.namingToken;
    }

    @Override
    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    @Override
    public NamingResourcesImpl getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    @Override
    public void setGlobalNamingResources(NamingResourcesImpl globalNamingResources) {
        NamingResourcesImpl oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public Catalina getCatalina() {
        return this.catalina;
    }

    @Override
    public void setCatalina(Catalina catalina) {
        this.catalina = catalina;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(Service service) {
        service.setServer(this);
        Object object = this.servicesLock;
        synchronized (object) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.getState().isAvailable()) {
                try {
                    service.start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
        }
    }

    public void stopAwait() {
        this.stopAwait = true;
        Thread t = this.awaitThread;
        if (t != null) {
            ServerSocket s = this.awaitSocket;
            if (s != null) {
                this.awaitSocket = null;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            t.interrupt();
            try {
                t.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void await() {
        ServerSocket serverSocket;
        if (this.port == -2) {
            return;
        }
        if (this.port == -1) {
            try {
                this.awaitThread = Thread.currentThread();
                while (!this.stopAwait) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {}
                }
                return;
            }
            finally {
                this.awaitThread = null;
            }
        }
        try {
            this.awaitSocket = new ServerSocket(this.port, 1, InetAddress.getByName(this.address));
        }
        catch (IOException e) {
            log.error("StandardServer.await: create[" + this.address + ":" + this.port + "]: ", e);
            return;
        }
        try {
            this.awaitThread = Thread.currentThread();
            while (!this.stopAwait) {
                boolean match;
                InputStream stream;
                serverSocket = this.awaitSocket;
                if (serverSocket == null) {
                    return;
                }
                Socket socket = null;
                StringBuilder command = new StringBuilder();
                try {
                    socket = serverSocket.accept();
                    socket.setSoTimeout(10000);
                    stream = socket.getInputStream();
                }
                catch (AccessControlException ace) {
                    log.warn("StandardServer.accept security exception: " + ace.getMessage(), ace);
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
                catch (IOException e) {
                    if (this.stopAwait) {
                        return;
                    }
                    log.error("StandardServer.await: accept: ", e);
                    return;
                }
                {
                    int expected;
                    for (expected = 1024; expected < this.shutdown.length(); expected += this.random.nextInt() % 1024) {
                        if (this.random != null) continue;
                        this.random = new Random();
                    }
                    while (expected > 0) {
                        int ch = -1;
                        try {
                            ch = stream.read();
                        }
                        catch (IOException e) {
                            log.warn("StandardServer.await: read: ", e);
                            ch = -1;
                        }
                        if (ch < 32) break;
                        command.append((char)ch);
                        --expected;
                    }
                }
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
                if (match = command.toString().equals(this.shutdown)) {
                    log.info(sm.getString("standardServer.shutdownViaPort"));
                    return;
                }
                log.warn("StandardServer.await: Invalid command '" + command.toString() + "' received");
            }
            return;
        }
        finally {
            serverSocket = this.awaitSocket;
            this.awaitThread = null;
            this.awaitSocket = null;
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.servicesLock;
        synchronized (object) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!name.equals(this.services[i].getName())) continue;
                return this.services[i];
            }
        }
        return null;
    }

    @Override
    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            onames[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(Service service) {
        Object object = this.servicesLock;
        synchronized (object) {
            int j = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            try {
                this.services[j].stop();
            }
            catch (LifecycleException e) {
                // empty catch block
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == j) continue;
                results[k++] = this.services[i];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
        }
    }

    @Override
    public File getCatalinaBase() {
        if (this.catalinaBase != null) {
            return this.catalinaBase;
        }
        this.catalinaBase = this.getCatalinaHome();
        return this.catalinaBase;
    }

    @Override
    public void setCatalinaBase(File catalinaBase) {
        this.catalinaBase = catalinaBase;
    }

    @Override
    public File getCatalinaHome() {
        return this.catalinaHome;
    }

    @Override
    public void setCatalinaHome(File catalinaHome) {
        this.catalinaHome = catalinaHome;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void storeConfig() throws Exception {
        ObjectName sname = new ObjectName("Catalina:type=StoreConfig");
        this.mserver.invoke(sname, "storeConfig", null, null);
    }

    public synchronized void storeContext(Context context) throws Exception {
        ObjectName sname = null;
        try {
            sname = new ObjectName("Catalina:type=StoreConfig");
            if (this.mserver.isRegistered(sname)) {
                this.mserver.invoke(sname, "store", new Object[]{context}, new String[]{"java.lang.String"});
            } else {
                log.error("StoreConfig mbean not registered" + sname);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(t);
        }
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
        this.globalNamingResources.start();
        Object object = this.servicesLock;
        synchronized (object) {
            for (int i = 0; i < this.services.length; ++i) {
                this.services[i].start();
            }
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.fireLifecycleEvent("configure_stop", null);
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].stop();
        }
        this.globalNamingResources.stop();
        this.stopAwait();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.onameStringCache = this.register(new StringCache(), "type=StringCache");
        MBeanFactory factory = new MBeanFactory();
        factory.setContainer(this);
        this.onameMBeanFactory = this.register(factory, "type=MBeanFactory");
        this.globalNamingResources.init();
        if (this.getCatalina() != null) {
            for (ClassLoader cl = this.getCatalina().getParentClassLoader(); cl != null && cl != ClassLoader.getSystemClassLoader(); cl = cl.getParent()) {
                URL[] urls;
                if (!(cl instanceof URLClassLoader)) continue;
                for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                    if (!url.getProtocol().equals("file")) continue;
                    try {
                        File f = new File(url.toURI());
                        if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                        ExtensionValidator.addSystemResource(f);
                    }
                    catch (URISyntaxException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].init();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].destroy();
        }
        this.globalNamingResources.destroy();
        this.unregister(this.onameMBeanFactory);
        this.unregister(this.onameStringCache);
        super.destroyInternal();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.catalina != null) {
            return this.catalina.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        Service service;
        String domain = null;
        Service[] services = this.findServices();
        if (services.length > 0 && (service = services[0]) != null) {
            domain = service.getDomain();
        }
        return domain;
    }

    @Override
    protected final String getObjectNameKeyProperties() {
        return "type=Server";
    }
}

