/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;

public class DataSourceRealm
extends RealmBase {
    private String preparedRoles = null;
    private String preparedCredentials = null;
    protected String dataSourceName = null;
    protected boolean localDataSource = false;
    protected static final String name = "DataSourceRealm";
    protected String roleNameCol = null;
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean localDataSource) {
        this.localDataSource = localDataSource;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        if (username == null || credentials == null) {
            return null;
        }
        Connection dbConnection = null;
        dbConnection = this.open();
        if (dbConnection == null) {
            return null;
        }
        Principal principal = this.authenticate(dbConnection, username, credentials);
        this.close(dbConnection);
        return principal;
    }

    protected Principal authenticate(Connection dbConnection, String username, String credentials) {
        String dbCredentials = this.getPassword(dbConnection, username);
        boolean validated = this.compareCredentials(credentials, dbCredentials);
        if (validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("dataSourceRealm.authenticateSuccess", username));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("dataSourceRealm.authenticateFailure", username));
            }
            return null;
        }
        ArrayList<String> list = this.getRoles(dbConnection, username);
        return new GenericPrincipal(username, credentials, list);
    }

    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            this.containerLog.error("Exception committing connection before closing:", e);
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.containerLog.error(sm.getString("dataSourceRealm.close"), e);
        }
    }

    protected Connection open() {
        try {
            Context context = null;
            if (this.localDataSource) {
                context = ContextBindings.getClassLoader();
                context = (Context)context.lookup("comp/env");
            } else {
                context = this.getServer().getGlobalNamingContext();
            }
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            return dataSource.getConnection();
        }
        catch (Exception e) {
            this.containerLog.error(sm.getString("dataSourceRealm.exception"), e);
            return null;
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getPassword(String username) {
        Connection dbConnection = null;
        dbConnection = this.open();
        if (dbConnection == null) {
            return null;
        }
        try {
            String string = this.getPassword(dbConnection, username);
            return string;
        }
        finally {
            this.close(dbConnection);
        }
    }

    /*
     * Exception decompiling
     */
    protected String getPassword(Connection dbConnection, String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Principal getPrincipal(String username) {
        Connection dbConnection = this.open();
        if (dbConnection == null) {
            return new GenericPrincipal(username, null, null);
        }
        try {
            GenericPrincipal genericPrincipal = new GenericPrincipal(username, this.getPassword(dbConnection, username), this.getRoles(dbConnection, username));
            return genericPrincipal;
        }
        finally {
            this.close(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getRoles(String username) {
        Connection dbConnection = null;
        dbConnection = this.open();
        if (dbConnection == null) {
            return null;
        }
        try {
            ArrayList<String> arrayList = this.getRoles(dbConnection, username);
            return arrayList;
        }
        finally {
            this.close(dbConnection);
        }
    }

    /*
     * Exception decompiling
     */
    protected ArrayList<String> getRoles(Connection dbConnection, String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        PreparedStatement credentials = dbConnection.prepareStatement(this.preparedCredentials);
        credentials.setString(1, username);
        return credentials;
    }

    private PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        PreparedStatement roles = dbConnection.prepareStatement(this.preparedRoles);
        roles.setString(1, username);
        return roles;
    }

    private boolean isRoleStoreDefined() {
        return this.userRoleTable != null || this.roleNameCol != null;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        StringBuilder temp = new StringBuilder("SELECT ");
        temp.append(this.roleNameCol);
        temp.append(" FROM ");
        temp.append(this.userRoleTable);
        temp.append(" WHERE ");
        temp.append(this.userNameCol);
        temp.append(" = ?");
        this.preparedRoles = temp.toString();
        temp = new StringBuilder("SELECT ");
        temp.append(this.userCredCol);
        temp.append(" FROM ");
        temp.append(this.userTable);
        temp.append(" WHERE ");
        temp.append(this.userNameCol);
        temp.append(" = ?");
        this.preparedCredentials = temp.toString();
        super.startInternal();
    }
}

