/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.catalina.startup.Bootstrap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CatalinaProperties {
    private static final Log log = LogFactory.getLog(CatalinaProperties.class);
    private static Properties properties = null;

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    private static void loadProperties() {
        InputStream is = null;
        Throwable error = null;
        try {
            String configUrl = CatalinaProperties.getConfigUrl();
            if (configUrl != null) {
                is = new URL(configUrl).openStream();
            }
        }
        catch (Throwable t) {
            CatalinaProperties.handleThrowable(t);
        }
        if (is == null) {
            try {
                File home = new File(Bootstrap.getCatalinaBase());
                File conf = new File(home, "conf");
                File propsFile = new File(conf, "catalina.properties");
                is = new FileInputStream(propsFile);
            }
            catch (Throwable t) {
                CatalinaProperties.handleThrowable(t);
            }
        }
        if (is == null) {
            try {
                is = CatalinaProperties.class.getResourceAsStream("/org/apache/catalina/startup/catalina.properties");
            }
            catch (Throwable t) {
                CatalinaProperties.handleThrowable(t);
            }
        }
        if (is != null) {
            try {
                properties = new Properties();
                properties.load(is);
                is.close();
            }
            catch (Throwable t) {
                CatalinaProperties.handleThrowable(t);
                error = t;
            }
        }
        if (is == null || error != null) {
            log.warn("Failed to load catalina.properties", error);
            properties = new Properties();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            System.setProperty(name, value);
        }
    }

    private static String getConfigUrl() {
        return System.getProperty("catalina.config");
    }

    private static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }

    static {
        CatalinaProperties.loadProperties();
    }
}

