/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.MemoryGroup;
import org.apache.catalina.users.MemoryGroupCreationFactory;
import org.apache.catalina.users.MemoryRole;
import org.apache.catalina.users.MemoryRoleCreationFactory;
import org.apache.catalina.users.MemoryUser;
import org.apache.catalina.users.MemoryUserCreationFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.res.StringManager;

public class MemoryUserDatabase
implements UserDatabase {
    private static final Log log = LogFactory.getLog(MemoryUserDatabase.class);
    protected final HashMap<String, Group> groups = new HashMap();
    protected final String id;
    protected String pathname = "conf/tomcat-users.xml";
    protected String pathnameOld = this.pathname + ".old";
    protected String pathnameNew = this.pathname + ".new";
    protected boolean readonly = true;
    protected final HashMap<String, Role> roles = new HashMap();
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.users");
    protected final HashMap<String, User> users = new HashMap();

    public MemoryUserDatabase() {
        this(null);
    }

    public MemoryUserDatabase(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            return this.groups.values().iterator();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.pathnameOld = pathname + ".old";
        this.pathnameNew = pathname + ".new";
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            return this.roles.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<User> getUsers() {
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            return this.users.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.save();
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            HashMap<String, User> hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.clear();
                this.groups.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String groupname, String description) {
        if (groupname == null || groupname.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullGroup");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryGroup group = new MemoryGroup(this, groupname, description);
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            this.groups.put(group.getGroupname(), group);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String rolename, String description) {
        if (rolename == null || rolename.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullRole");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryRole role = new MemoryRole(this, rolename, description);
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            this.roles.put(role.getRolename(), role);
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String username, String password, String fullName) {
        if (username == null || username.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullUser");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryUser user = new MemoryUser(this, username, password, fullName);
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            this.users.put(user.getUsername(), user);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group findGroup(String groupname) {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            return this.groups.get(groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role findRole(String rolename) {
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            return this.roles.get(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User findUser(String username) {
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            return this.users.get(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws Exception {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            HashMap<String, User> hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.clear();
                this.groups.clear();
                this.roles.clear();
                File file = new File(this.pathname);
                if (!file.isAbsolute()) {
                    file = new File(System.getProperty("catalina.base"), this.pathname);
                }
                if (!file.exists()) {
                    log.error(sm.getString("memoryUserDatabase.fileNotFound", file.getAbsolutePath()));
                    return;
                }
                Digester digester = new Digester();
                try {
                    digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
                }
                catch (Exception e) {
                    log.warn(sm.getString("memoryUserDatabase.xmlFeatureEncoding"), e);
                }
                digester.addFactoryCreate("tomcat-users/group", new MemoryGroupCreationFactory(this), true);
                digester.addFactoryCreate("tomcat-users/role", new MemoryRoleCreationFactory(this), true);
                digester.addFactoryCreate("tomcat-users/user", new MemoryUserCreationFactory(this), true);
                try (FileInputStream fis = new FileInputStream(file);){
                    digester.parse(fis);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            Iterator<User> users = this.getUsers();
            while (users.hasNext()) {
                User user = users.next();
                user.removeGroup(group);
            }
            this.groups.remove(group.getGroupname());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            Iterator<Group> groups = this.getGroups();
            while (groups.hasNext()) {
                Group group = groups.next();
                group.removeRole(role);
            }
            Iterator<User> users = this.getUsers();
            while (users.hasNext()) {
                User user = users.next();
                user.removeRole(role);
            }
            this.roles.remove(role.getRolename());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(User user) {
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            this.users.remove(user.getUsername());
        }
    }

    public boolean isWriteable() {
        File dir;
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        return (dir = file.getParentFile()).exists() && dir.isDirectory() && dir.canWrite();
    }

    @Override
    public void save() throws Exception {
        if (this.getReadonly()) {
            log.error(sm.getString("memoryUserDatabase.readOnly"));
            return;
        }
        if (!this.isWriteable()) {
            log.warn(sm.getString("memoryUserDatabase.notPersistable"));
            return;
        }
        File fileNew = new File(this.pathnameNew);
        if (!fileNew.isAbsolute()) {
            fileNew = new File(System.getProperty("catalina.base"), this.pathnameNew);
        }
        PrintWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileNew);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
            writer = new PrintWriter(osw);
            writer.println("<?xml version='1.0' encoding='utf-8'?>");
            writer.println("<tomcat-users>");
            Iterator<Principal> values = null;
            values = this.getRoles();
            while (values.hasNext()) {
                writer.print("  ");
                writer.println(values.next());
            }
            values = this.getGroups();
            while (values.hasNext()) {
                writer.print("  ");
                writer.println(values.next());
            }
            values = this.getUsers();
            while (values.hasNext()) {
                writer.print("  ");
                writer.println(((MemoryUser)values.next()).toXml());
            }
            writer.println("</tomcat-users>");
            if (writer.checkError()) {
                writer.close();
                fileNew.delete();
                throw new IOException(sm.getString("memoryUserDatabase.writeException", fileNew.getAbsolutePath()));
            }
            writer.close();
        }
        catch (IOException e) {
            if (writer != null) {
                writer.close();
            }
            fileNew.delete();
            throw e;
        }
        File fileOld = new File(this.pathnameOld);
        if (!fileOld.isAbsolute()) {
            fileOld = new File(System.getProperty("catalina.base"), this.pathnameOld);
        }
        fileOld.delete();
        File fileOrig = new File(this.pathname);
        if (!fileOrig.isAbsolute()) {
            fileOrig = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (fileOrig.exists()) {
            fileOld.delete();
            if (!fileOrig.renameTo(fileOld)) {
                throw new IOException(sm.getString("memoryUserDatabase.renameOld", fileOld.getAbsolutePath()));
            }
        }
        if (!fileNew.renameTo(fileOrig)) {
            if (fileOld.exists()) {
                fileOld.renameTo(fileOrig);
            }
            throw new IOException(sm.getString("memoryUserDatabase.renameNew", fileOrig.getAbsolutePath()));
        }
        fileOld.delete();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MemoryUserDatabase[id=");
        sb.append(this.id);
        sb.append(",pathname=");
        sb.append(this.pathname);
        sb.append(",groupCount=");
        sb.append(this.groups.size());
        sb.append(",roleCount=");
        sb.append(this.roles.size());
        sb.append(",userCount=");
        sb.append(this.users.size());
        sb.append("]");
        return sb.toString();
    }
}

