/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpNio2Processor
extends AbstractAjpProcessor<Nio2Channel> {
    private static final Log log = LogFactory.getLog(AjpNio2Processor.class);
    protected CompletionHandler<Integer, SocketWrapper<Nio2Channel>> writeCompletionHandler;
    protected boolean flipped = false;
    protected volatile boolean writePending = false;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpNio2Processor(int packetSize, Nio2Endpoint endpoint0) {
        super(packetSize, endpoint0);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
        this.writeCompletionHandler = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Integer nBytes, SocketWrapper<Nio2Channel> attachment) {
                boolean notify = false;
                CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler = AjpNio2Processor.this.writeCompletionHandler;
                synchronized (completionHandler) {
                    if (nBytes < 0) {
                        this.failed((Throwable)new IOException(AbstractAjpProcessor.sm.getString("ajpprocessor.failedsend")), attachment);
                        return;
                    }
                    AjpNio2Processor.this.writePending = false;
                    if (!Nio2Endpoint.isInline()) {
                        notify = true;
                    }
                }
                if (notify) {
                    AjpNio2Processor.this.endpoint.processSocket(attachment, SocketStatus.OPEN_WRITE, false);
                }
            }

            @Override
            public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
                attachment.setError(true);
                AjpNio2Processor.this.writePending = false;
                AjpNio2Processor.this.endpoint.processSocket(attachment, SocketStatus.DISCONNECT, true);
            }
        };
    }

    @Override
    public void recycle(boolean socketClosing) {
        super.recycle(socketClosing);
        this.writePending = false;
        this.flipped = false;
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
    }

    @Override
    protected void resetTimeouts() {
        if (!this.error && this.socketWrapper != null && this.asyncStateMachine.isAsyncDispatching()) {
            long soTimeout = this.endpoint.getSoTimeout();
            if (this.keepAliveTimeout > 0) {
                this.socketWrapper.setTimeout(this.keepAliveTimeout);
            } else {
                this.socketWrapper.setTimeout(soTimeout);
            }
        }
    }

    @Override
    protected void setupSocket(SocketWrapper<Nio2Channel> socketWrapper) throws IOException {
    }

    @Override
    protected void setTimeout(SocketWrapper<Nio2Channel> socketWrapper, int timeout) throws IOException {
        socketWrapper.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int output(byte[] src, int offset, int length, boolean block) throws IOException {
        if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
            return -1;
        }
        ByteBuffer writeBuffer = ((Nio2Channel)this.socketWrapper.getSocket()).getBufHandler().getWriteBuffer();
        int result = 0;
        if (block) {
            writeBuffer.clear();
            writeBuffer.put(src, offset, length);
            writeBuffer.flip();
            try {
                result = ((Nio2Channel)this.socketWrapper.getSocket()).write(writeBuffer).get(this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IOException(sm.getString("ajpprocessor.failedsend"), e);
            }
        }
        CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler = this.writeCompletionHandler;
        synchronized (completionHandler) {
            if (!this.writePending) {
                writeBuffer.clear();
                writeBuffer.put(src, offset, length);
                writeBuffer.flip();
                this.writePending = true;
                Nio2Endpoint.startInline();
                ((Nio2Channel)this.socketWrapper.getSocket()).write(writeBuffer, this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS, this.socketWrapper, this.writeCompletionHandler);
                Nio2Endpoint.endInline();
                result = length;
            }
        }
        return result;
    }

    @Override
    protected boolean read(byte[] buf, int pos, int n, boolean blockFirstRead) throws IOException {
        int res = 0;
        boolean block = blockFirstRead;
        for (int read = 0; read < n; read += res) {
            res = this.readSocket(buf, read + pos, n - read, block);
            if (res > 0) {
            } else {
                if (res == 0 && !block) {
                    return false;
                }
                throw new IOException(sm.getString("ajpprocessor.failedread"));
            }
            block = true;
        }
        return true;
    }

    private int readSocket(byte[] buf, int pos, int n, boolean block) throws IOException {
        int nRead = 0;
        ByteBuffer readBuffer = ((Nio2Channel)this.socketWrapper.getSocket()).getBufHandler().getReadBuffer();
        if (block) {
            if (!this.flipped) {
                readBuffer.flip();
                this.flipped = true;
            }
            if (readBuffer.remaining() > 0) {
                nRead = Math.min(n, readBuffer.remaining());
                readBuffer.get(buf, pos, nRead);
                if (readBuffer.remaining() == 0) {
                    readBuffer.clear();
                    this.flipped = false;
                }
            } else {
                readBuffer.clear();
                this.flipped = false;
                readBuffer.limit(n);
                try {
                    nRead = ((Nio2Channel)this.socketWrapper.getSocket()).read(readBuffer).get(this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new IOException(sm.getString("ajpprocessor.failedread"), e);
                }
                if (nRead > 0) {
                    if (!this.flipped) {
                        readBuffer.flip();
                        this.flipped = true;
                    }
                    nRead = Math.min(n, readBuffer.remaining());
                    readBuffer.get(buf, pos, nRead);
                    if (readBuffer.remaining() == 0) {
                        readBuffer.clear();
                        this.flipped = false;
                    }
                }
            }
        } else {
            if (!this.flipped) {
                readBuffer.flip();
                this.flipped = true;
            }
            if (readBuffer.remaining() > 0) {
                nRead = Math.min(n, readBuffer.remaining());
                readBuffer.get(buf, pos, nRead);
                if (readBuffer.remaining() == 0) {
                    readBuffer.clear();
                    this.flipped = false;
                }
            } else {
                readBuffer.clear();
                this.flipped = false;
                readBuffer.limit(n);
            }
        }
        return nRead;
    }
}

