/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Nio2ServletOutputStream
extends AbstractServletOutputStream<Nio2Channel> {
    private final AbstractEndpoint<Nio2Channel> endpoint;
    private final Nio2Channel channel;
    private final int maxWrite;
    private final CompletionHandler<Integer, ByteBuffer> completionHandler;
    private final Semaphore writePending = new Semaphore(1);

    public Nio2ServletOutputStream(AbstractEndpoint<Nio2Channel> endpoint0, SocketWrapper<Nio2Channel> socketWrapper0) {
        super(socketWrapper0);
        this.endpoint = endpoint0;
        this.channel = socketWrapper0.getSocket();
        this.maxWrite = this.channel.getBufHandler().getWriteBuffer().capacity();
        this.completionHandler = new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer nBytes, ByteBuffer attachment) {
                if (nBytes < 0) {
                    this.failed((Throwable)new EOFException(), attachment);
                } else if (attachment.hasRemaining()) {
                    Nio2ServletOutputStream.this.channel.write(attachment, Nio2ServletOutputStream.this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS, attachment, Nio2ServletOutputStream.this.completionHandler);
                } else {
                    Nio2ServletOutputStream.this.writePending.release();
                    if (!Nio2Endpoint.isInline()) {
                        try {
                            Nio2ServletOutputStream.this.onWritePossible();
                        }
                        catch (IOException e) {
                            Nio2ServletOutputStream.this.socketWrapper.setError(true);
                            Nio2ServletOutputStream.this.onError(e);
                            Nio2ServletOutputStream.this.endpoint.processSocket(Nio2ServletOutputStream.this.socketWrapper, SocketStatus.ERROR, false);
                        }
                    }
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                Nio2ServletOutputStream.this.socketWrapper.setError(true);
                Nio2ServletOutputStream.this.writePending.release();
                if (exc instanceof AsynchronousCloseException) {
                    return;
                }
                Nio2ServletOutputStream.this.onError(exc);
                Nio2ServletOutputStream.this.endpoint.processSocket(Nio2ServletOutputStream.this.socketWrapper, SocketStatus.ERROR, true);
            }
        };
    }

    @Override
    protected int doWrite(boolean block, byte[] b, int off, int len) throws IOException {
        int writtenThisLoop;
        int count = 0;
        int offset = off;
        for (int leftToWrite = len; leftToWrite > 0; leftToWrite -= writtenThisLoop) {
            int writeThisLoop = leftToWrite > this.maxWrite ? this.maxWrite : leftToWrite;
            writtenThisLoop = this.doWriteInternal(block, b, offset, writeThisLoop);
            if (writtenThisLoop < 0) {
                throw new EOFException();
            }
            count += writtenThisLoop;
            if (!block && this.writePending.availablePermits() == 0) {
                return count;
            }
            offset += writtenThisLoop;
            if (writtenThisLoop >= writeThisLoop) continue;
            break;
        }
        return count;
    }

    private int doWriteInternal(boolean block, byte[] b, int off, int len) throws IOException {
        ByteBuffer buffer = this.channel.getBufHandler().getWriteBuffer();
        int written = 0;
        if (block) {
            buffer.clear();
            buffer.put(b, off, len);
            buffer.flip();
            try {
                written = this.channel.write(buffer).get(this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    this.onError(e.getCause());
                    throw (IOException)e.getCause();
                }
                this.onError(e);
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                this.onError(e);
                throw new IOException(e);
            }
            catch (TimeoutException e) {
                SocketTimeoutException ex = new SocketTimeoutException();
                this.onError(ex);
                throw ex;
            }
        } else if (this.writePending.tryAcquire()) {
            buffer.clear();
            buffer.put(b, off, len);
            buffer.flip();
            Nio2Endpoint.startInline();
            this.channel.write(buffer, this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS, buffer, this.completionHandler);
            Nio2Endpoint.endInline();
            written = len;
        }
        return written;
    }

    @Override
    protected void doFlush() throws IOException {
        try {
            if (!this.writePending.tryAcquire(this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
            this.writePending.release();
            this.channel.flush().get(this.socketWrapper.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                this.onError(e.getCause());
                throw (IOException)e.getCause();
            }
            this.onError(e);
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            this.onError(e);
            throw new IOException(e);
        }
        catch (TimeoutException e) {
            SocketTimeoutException ex = new SocketTimeoutException();
            this.onError(ex);
            throw ex;
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.channel.close(true);
    }
}

