/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.apache.tomcat.util.http.CookieSupport;

public class SetCookieSupport {
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> OLD_COOKIE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(SetCookieSupport.OLD_COOKIE_PATTERN, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        }
    };
    private static final String ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));

    public static String generateHeader(Cookie cookie) {
        int maxAge;
        StringBuffer buf = new StringBuffer();
        buf.append(cookie.getName());
        buf.append("=");
        String value = cookie.getValue();
        String path = cookie.getPath();
        String domain = cookie.getDomain();
        String comment = cookie.getComment();
        int newVersion = cookie.getVersion();
        if (newVersion == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && SetCookieSupport.isHttpToken(value) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && SetCookieSupport.isV0Token(value))) {
            newVersion = 1;
        }
        if (newVersion == 0 && comment != null) {
            newVersion = 1;
        }
        if (newVersion == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && SetCookieSupport.isHttpToken(path) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && SetCookieSupport.isV0Token(path))) {
            newVersion = 1;
        }
        if (newVersion == 0 && (!CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && SetCookieSupport.isHttpToken(domain) || CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && SetCookieSupport.isV0Token(domain))) {
            newVersion = 1;
        }
        SetCookieSupport.maybeQuote(buf, value);
        if (newVersion == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                SetCookieSupport.maybeQuote(buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            SetCookieSupport.maybeQuote(buf, domain);
        }
        if ((maxAge = cookie.getMaxAge()) >= 0) {
            if (newVersion > 0) {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
            if (newVersion == 0 || CookieSupport.ALWAYS_ADD_EXPIRES) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ancientDate);
                } else {
                    OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            }
        }
        if (path != null) {
            buf.append("; Path=");
            SetCookieSupport.maybeQuote(buf, path);
        }
        if (cookie.getSecure()) {
            buf.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            buf.append("; HttpOnly");
        }
        return buf.toString();
    }

    private static void maybeQuote(StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else if (SetCookieSupport.alreadyQuoted(value)) {
            buf.append('\"');
            buf.append(SetCookieSupport.escapeDoubleQuotes(value, 1, value.length() - 1));
            buf.append('\"');
        } else if (SetCookieSupport.isHttpToken(value) && !CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 || SetCookieSupport.isV0Token(value) && CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0) {
            buf.append('\"');
            buf.append(SetCookieSupport.escapeDoubleQuotes(value, 0, value.length()));
            buf.append('\"');
        } else {
            buf.append(value);
        }
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static boolean isV0Token(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length();
        if (SetCookieSupport.alreadyQuoted(value)) {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (CookieSupport.isV0Separator(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isHttpToken(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length();
        if (SetCookieSupport.alreadyQuoted(value)) {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (CookieSupport.isHttpSeparator(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean alreadyQuoted(String value) {
        if (value == null || value.length() < 2) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }
}

