/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.client.lib.RestLogCallback;
import org.cloudfoundry.client.lib.RestLogEntry;

public class RestLogger
implements RestLogCallback {
    private final Log logger;

    public RestLogger(String category) {
        this.logger = LogFactory.getLog(category == null ? this.getClass().getName() : category);
    }

    public void onNewLogEntry(RestLogEntry logEntry) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.formatLogMessage(logEntry));
        }
    }

    private String formatLogMessage(RestLogEntry restLogEntry) {
        return restLogEntry.getStatus() + " :: HTTP STATUS: " + (Object)((Object)restLogEntry.getHttpStatus()) + " :: REQUEST: " + (Object)((Object)restLogEntry.getMethod()) + " " + restLogEntry.getUri() + " :: " + restLogEntry.getMessage();
    }
}

